mod common;

pub use common::*;
use spamassassin_milter::*;

#[tokio::test]
async fn ham_message() {
    let config = configure_spamc(Config::builder())
        .spamc_args(&[format!("--port={}", SPAMD_PORT)])
        .build();

    let server = spawn_mock_spamd_server(SPAMD_PORT, |ham| {
        let mut ham = ham
            .replacen("X-Spam-Checker-Version: BogusChecker 1.0.0\r\n", "", 1)
            .replacen("X-Spam-Report: Bogus report\r\n", "", 1);

        // Prepend replaced and newly added SpamAssassin headers.
        ham.insert_str(
            0,
            "X-Spam-Checker-Version: MyChecker 1.0.0\r\n\
             X-Spam-Custom: Custom-Value\r\n",
        );

        Ok(ham)
    })
    .await
    .unwrap();

    let milter = SpamAssassinMilter::spawn(LOCALHOST, config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();
    server.await.unwrap().unwrap();

    assert!(exit_code.success());
}
