mod common;

pub use common::*;
use spamassassin_milter::*;

#[tokio::test]
async fn trusted_network_connection() {
    let config = Config::builder()
        .trusted_network("123.120.0.0/14".parse().unwrap())
        .build();

    let milter = SpamAssassinMilter::spawn(LOCALHOST, config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();

    assert!(exit_code.success());
}
