mod common;

pub use common::*;
use spamassassin_milter::*;

#[tokio::test]
async fn spamc_connection_error() {
    let config = configure_spamc(Config::builder())
        .spamc_args(&[format!("--port={}", SPAMD_PORT)])
        .build();

    let milter = SpamAssassinMilter::spawn(LOCALHOST, config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();

    assert!(exit_code.success());
}
