-- 1) A connection from the loopback IP address is accepted.

local conn = mt.connect("inet:" .. port .. "@127.0.0.1")
assert(conn, "could not open connection")

local err = mt.conninfo(conn, nil, "127.0.0.1")
assert(err == nil, err)
assert(mt.getreply(conn) == SMFIR_ACCEPT)

local err = mt.disconnect(conn)
assert(err == nil, err)

-- 2) A connection from an ‘unknown’ IP address (for example, from a UNIX
-- domain socket) is also accepted.

local conn = mt.connect("inet:" .. port .. "@127.0.0.1")
assert(conn, "could not open connection")

local err = mt.conninfo(conn, nil, "unspec")
assert(err == nil, err)
assert(mt.getreply(conn) == SMFIR_ACCEPT)

local err = mt.disconnect(conn)
assert(err == nil, err)
