mod common;

pub use common::*;
use spamassassin_milter::*;

/// Runs a ‘live’ test against a real SpamAssassin server instance. This test is
/// run on demand, as SpamAssassin will actually analyse the input, and do DNS
/// queries etc.
#[ignore]
#[tokio::test]
async fn live() {
    // When no port is specified, `spamc` will try to connect to the default
    // `spamd` port 783 (see also `/etc/services`).
    let config = configure_spamc(Config::builder()).build();

    let milter = SpamAssassinMilter::spawn(LOCALHOST, config).await.unwrap();

    let exit_code = run_miltertest(file!(), milter.addr()).await.unwrap();

    milter.shutdown().await.unwrap();

    assert!(exit_code.success());
}
