mod common;

pub use common::*;  // `pub` only to silence unused code warnings
use spamassassin_milter::*;

#[test]
fn ham_message() {
    let mut builder = configure_spamc(Config::builder());
    builder.spamc_args(&[format!("--port={}", SPAMD_PORT)]);
    let config = builder.build();

    let server = spawn_mock_spamd_server(SPAMD_PORT, |ham| {
        let mut ham = ham
            .replacen("X-Spam-Checker-Version: BogusChecker 1.0.0\r\n", "", 1)
            .replacen("X-Spam-Report: Bogus report\r\n", "", 1);

        // Prepend replaced and newly added SpamAssassin headers.
        ham.insert_str(
            0,
            "X-Spam-Checker-Version: MyChecker 1.0.0\r\n\
             X-Spam-Custom: Custom-Value\r\n",
        );

        Ok(ham)
    });
    let miltertest = spawn_miltertest_runner(file!());

    run("inet:3333@localhost", config).expect("milter execution failed");

    let exit_code = miltertest.join().expect("panic in miltertest runner");
    assert!(exit_code.success(), "miltertest returned error exit code");

    server.join().expect("panic in mock spamd server");
}
