# SpamAssassin Milter changelog

## 0.2.0 (2021-08-26)

*   Bump minimum supported Rust version to 1.46.0.
*   (defaults change) Invoke `spamc` using the absolute path `/usr/bin/spamc`
    (instead of any executable named `spamc` in the search path). To customise
    this, set the environment variable `SPAMASSASSIN_MILTER_SPAMC` to the
    desired path when building the application.
*   Revise header rewriting logic. Handling and placement of `X-Spam-` headers
    now more accurately mirrors that applied by SpamAssassin.
*   Include authentication status in information passed on to SpamAssassin.
*   Update dependencies.

## 0.1.6 (2021-05-17)

*   Improve processing of incoming `X-Spam-Flag` headers. Previously, in rare
    circumstances a message flagged as spam would not be rejected as requested.
    Reported by Petar Bogdanovic.
*   Update dependencies.

## 0.1.5 (2021-03-16)

*   Read output from `spamc` in a separate thread in order to avoid blocking
    when processing large messages in certain configurations.
*   Document requirement to keep `--max-message-size` setting in sync with
    `spamc`’s `--max-size` setting.
*   Remove overly strict validation of command-line options.
*   Properly specify minimal dependency versions in `Cargo.toml`.
*   Document minimum supported Rust version 1.42.0.

## 0.1.4 (2020-10-18)

*   Correct a typo in log messages.
*   Isolate integration tests from any existing `spamc` configuration present on
    the host.
*   Various à la mode style improvements in code and project metadata.

## 0.1.3 (2020-07-04)

*   Add `--reply-code`, `--reply-status-code`, and `--reply-text` options to
    allow customising the SMTP reply when rejecting spam.
*   Log a warning and do not truncate the message body when `--max-message-size`
    is misconfigured (must be ≥ `spamc` max size as documented).
*   Update dependencies in `Cargo.lock`.

## 0.1.2 (2020-06-07)

*   Bump milter dependency to version 0.2.1.
*   Remove existing UNIX domain socket at target path during startup.
*   Derive `Eq` and `PartialEq` for configuration structs.

## 0.1.1 (2020-04-13)

*   Use `Write::write_all` instead of `Write::write` in `spamc` client, in order
    to ensure buffers are written in their entirety.
*   Do not include `.gitignore` file in published crate.

## 0.1.0 (2020-02-23)

Initial release.
