mod common;

pub use common::*;  // `pub` only to silence unused code warnings
use spamassassin_milter::*;

#[test]
fn spamc_connection_error() {
    let mut builder = configure_spamc(Config::builder());
    builder.spamc_args(&[format!("--port={}", SPAMD_PORT)]);
    let config = builder.build();

    let miltertest = spawn_miltertest_runner(file!());

    run("inet:3333@localhost", config).expect("milter execution failed");

    let exit_code = miltertest.join().expect("panic in miltertest runner");
    assert!(exit_code.success(), "miltertest returned error exit code");
}
