// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::BackgroundPatternType;
use crate::Buffer;
use crate::ChangeCaseType;
use crate::Completion;
use crate::Gutter;
use crate::Hover;
use crate::Indenter;
use crate::MarkAttributes;
use crate::SmartHomeEndType;
use crate::SpaceDrawer;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceView")]
    pub struct View(Object<ffi::GtkSourceView, ffi::GtkSourceViewClass>) @extends gtk::TextView, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, gtk::Scrollable;

    match fn {
        type_ => || ffi::gtk_source_view_get_type(),
    }
}

impl View {
    pub const NONE: Option<&'static View> = None;

    #[doc(alias = "gtk_source_view_new")]
    pub fn new() -> View {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::gtk_source_view_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_source_view_new_with_buffer")]
    #[doc(alias = "new_with_buffer")]
    pub fn with_buffer(buffer: &impl IsA<Buffer>) -> View {
        skip_assert_initialized!();
        unsafe {
            gtk::Widget::from_glib_none(ffi::gtk_source_view_new_with_buffer(
                buffer.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`View`] objects.
    ///
    /// This method returns an instance of [`ViewBuilder`](crate::builders::ViewBuilder) which can be used to create [`View`] objects.
    pub fn builder() -> ViewBuilder {
        ViewBuilder::default()
    }
}

impl Default for View {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`View`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ViewBuilder {
    auto_indent: Option<bool>,
    background_pattern: Option<BackgroundPatternType>,
    enable_snippets: Option<bool>,
    highlight_current_line: Option<bool>,
    indent_on_tab: Option<bool>,
    indent_width: Option<i32>,
    indenter: Option<Indenter>,
    insert_spaces_instead_of_tabs: Option<bool>,
    right_margin_position: Option<u32>,
    show_line_marks: Option<bool>,
    show_line_numbers: Option<bool>,
    show_right_margin: Option<bool>,
    smart_backspace: Option<bool>,
    smart_home_end: Option<SmartHomeEndType>,
    tab_width: Option<u32>,
    accepts_tab: Option<bool>,
    bottom_margin: Option<i32>,
    buffer: Option<gtk::TextBuffer>,
    cursor_visible: Option<bool>,
    editable: Option<bool>,
    extra_menu: Option<gio::MenuModel>,
    im_module: Option<String>,
    indent: Option<i32>,
    input_hints: Option<gtk::InputHints>,
    input_purpose: Option<gtk::InputPurpose>,
    justification: Option<gtk::Justification>,
    left_margin: Option<i32>,
    monospace: Option<bool>,
    overwrite: Option<bool>,
    pixels_above_lines: Option<i32>,
    pixels_below_lines: Option<i32>,
    pixels_inside_wrap: Option<i32>,
    right_margin: Option<i32>,
    tabs: Option<pango::TabArray>,
    top_margin: Option<i32>,
    wrap_mode: Option<gtk::WrapMode>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<gtk::Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<gtk::LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<gtk::Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<gtk::AccessibleRole>,
    hadjustment: Option<gtk::Adjustment>,
    hscroll_policy: Option<gtk::ScrollablePolicy>,
    vadjustment: Option<gtk::Adjustment>,
    vscroll_policy: Option<gtk::ScrollablePolicy>,
}

impl ViewBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`ViewBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`View`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> View {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref auto_indent) = self.auto_indent {
            properties.push(("auto-indent", auto_indent));
        }
        if let Some(ref background_pattern) = self.background_pattern {
            properties.push(("background-pattern", background_pattern));
        }
        if let Some(ref enable_snippets) = self.enable_snippets {
            properties.push(("enable-snippets", enable_snippets));
        }
        if let Some(ref highlight_current_line) = self.highlight_current_line {
            properties.push(("highlight-current-line", highlight_current_line));
        }
        if let Some(ref indent_on_tab) = self.indent_on_tab {
            properties.push(("indent-on-tab", indent_on_tab));
        }
        if let Some(ref indent_width) = self.indent_width {
            properties.push(("indent-width", indent_width));
        }
        if let Some(ref indenter) = self.indenter {
            properties.push(("indenter", indenter));
        }
        if let Some(ref insert_spaces_instead_of_tabs) = self.insert_spaces_instead_of_tabs {
            properties.push((
                "insert-spaces-instead-of-tabs",
                insert_spaces_instead_of_tabs,
            ));
        }
        if let Some(ref right_margin_position) = self.right_margin_position {
            properties.push(("right-margin-position", right_margin_position));
        }
        if let Some(ref show_line_marks) = self.show_line_marks {
            properties.push(("show-line-marks", show_line_marks));
        }
        if let Some(ref show_line_numbers) = self.show_line_numbers {
            properties.push(("show-line-numbers", show_line_numbers));
        }
        if let Some(ref show_right_margin) = self.show_right_margin {
            properties.push(("show-right-margin", show_right_margin));
        }
        if let Some(ref smart_backspace) = self.smart_backspace {
            properties.push(("smart-backspace", smart_backspace));
        }
        if let Some(ref smart_home_end) = self.smart_home_end {
            properties.push(("smart-home-end", smart_home_end));
        }
        if let Some(ref tab_width) = self.tab_width {
            properties.push(("tab-width", tab_width));
        }
        if let Some(ref accepts_tab) = self.accepts_tab {
            properties.push(("accepts-tab", accepts_tab));
        }
        if let Some(ref bottom_margin) = self.bottom_margin {
            properties.push(("bottom-margin", bottom_margin));
        }
        if let Some(ref buffer) = self.buffer {
            properties.push(("buffer", buffer));
        }
        if let Some(ref cursor_visible) = self.cursor_visible {
            properties.push(("cursor-visible", cursor_visible));
        }
        if let Some(ref editable) = self.editable {
            properties.push(("editable", editable));
        }
        if let Some(ref extra_menu) = self.extra_menu {
            properties.push(("extra-menu", extra_menu));
        }
        if let Some(ref im_module) = self.im_module {
            properties.push(("im-module", im_module));
        }
        if let Some(ref indent) = self.indent {
            properties.push(("indent", indent));
        }
        if let Some(ref input_hints) = self.input_hints {
            properties.push(("input-hints", input_hints));
        }
        if let Some(ref input_purpose) = self.input_purpose {
            properties.push(("input-purpose", input_purpose));
        }
        if let Some(ref justification) = self.justification {
            properties.push(("justification", justification));
        }
        if let Some(ref left_margin) = self.left_margin {
            properties.push(("left-margin", left_margin));
        }
        if let Some(ref monospace) = self.monospace {
            properties.push(("monospace", monospace));
        }
        if let Some(ref overwrite) = self.overwrite {
            properties.push(("overwrite", overwrite));
        }
        if let Some(ref pixels_above_lines) = self.pixels_above_lines {
            properties.push(("pixels-above-lines", pixels_above_lines));
        }
        if let Some(ref pixels_below_lines) = self.pixels_below_lines {
            properties.push(("pixels-below-lines", pixels_below_lines));
        }
        if let Some(ref pixels_inside_wrap) = self.pixels_inside_wrap {
            properties.push(("pixels-inside-wrap", pixels_inside_wrap));
        }
        if let Some(ref right_margin) = self.right_margin {
            properties.push(("right-margin", right_margin));
        }
        if let Some(ref tabs) = self.tabs {
            properties.push(("tabs", tabs));
        }
        if let Some(ref top_margin) = self.top_margin {
            properties.push(("top-margin", top_margin));
        }
        if let Some(ref wrap_mode) = self.wrap_mode {
            properties.push(("wrap-mode", wrap_mode));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        if let Some(ref hadjustment) = self.hadjustment {
            properties.push(("hadjustment", hadjustment));
        }
        if let Some(ref hscroll_policy) = self.hscroll_policy {
            properties.push(("hscroll-policy", hscroll_policy));
        }
        if let Some(ref vadjustment) = self.vadjustment {
            properties.push(("vadjustment", vadjustment));
        }
        if let Some(ref vscroll_policy) = self.vscroll_policy {
            properties.push(("vscroll-policy", vscroll_policy));
        }
        glib::Object::new::<View>(&properties).expect("Failed to create an instance of View")
    }

    pub fn auto_indent(mut self, auto_indent: bool) -> Self {
        self.auto_indent = Some(auto_indent);
        self
    }

    pub fn background_pattern(mut self, background_pattern: BackgroundPatternType) -> Self {
        self.background_pattern = Some(background_pattern);
        self
    }

    pub fn enable_snippets(mut self, enable_snippets: bool) -> Self {
        self.enable_snippets = Some(enable_snippets);
        self
    }

    pub fn highlight_current_line(mut self, highlight_current_line: bool) -> Self {
        self.highlight_current_line = Some(highlight_current_line);
        self
    }

    pub fn indent_on_tab(mut self, indent_on_tab: bool) -> Self {
        self.indent_on_tab = Some(indent_on_tab);
        self
    }

    pub fn indent_width(mut self, indent_width: i32) -> Self {
        self.indent_width = Some(indent_width);
        self
    }

    pub fn indenter(mut self, indenter: &impl IsA<Indenter>) -> Self {
        self.indenter = Some(indenter.clone().upcast());
        self
    }

    pub fn insert_spaces_instead_of_tabs(mut self, insert_spaces_instead_of_tabs: bool) -> Self {
        self.insert_spaces_instead_of_tabs = Some(insert_spaces_instead_of_tabs);
        self
    }

    pub fn right_margin_position(mut self, right_margin_position: u32) -> Self {
        self.right_margin_position = Some(right_margin_position);
        self
    }

    pub fn show_line_marks(mut self, show_line_marks: bool) -> Self {
        self.show_line_marks = Some(show_line_marks);
        self
    }

    pub fn show_line_numbers(mut self, show_line_numbers: bool) -> Self {
        self.show_line_numbers = Some(show_line_numbers);
        self
    }

    pub fn show_right_margin(mut self, show_right_margin: bool) -> Self {
        self.show_right_margin = Some(show_right_margin);
        self
    }

    pub fn smart_backspace(mut self, smart_backspace: bool) -> Self {
        self.smart_backspace = Some(smart_backspace);
        self
    }

    pub fn smart_home_end(mut self, smart_home_end: SmartHomeEndType) -> Self {
        self.smart_home_end = Some(smart_home_end);
        self
    }

    pub fn tab_width(mut self, tab_width: u32) -> Self {
        self.tab_width = Some(tab_width);
        self
    }

    pub fn accepts_tab(mut self, accepts_tab: bool) -> Self {
        self.accepts_tab = Some(accepts_tab);
        self
    }

    pub fn bottom_margin(mut self, bottom_margin: i32) -> Self {
        self.bottom_margin = Some(bottom_margin);
        self
    }

    pub fn buffer(mut self, buffer: &impl IsA<gtk::TextBuffer>) -> Self {
        self.buffer = Some(buffer.clone().upcast());
        self
    }

    pub fn cursor_visible(mut self, cursor_visible: bool) -> Self {
        self.cursor_visible = Some(cursor_visible);
        self
    }

    pub fn editable(mut self, editable: bool) -> Self {
        self.editable = Some(editable);
        self
    }

    pub fn extra_menu(mut self, extra_menu: &impl IsA<gio::MenuModel>) -> Self {
        self.extra_menu = Some(extra_menu.clone().upcast());
        self
    }

    pub fn im_module(mut self, im_module: &str) -> Self {
        self.im_module = Some(im_module.to_string());
        self
    }

    pub fn indent(mut self, indent: i32) -> Self {
        self.indent = Some(indent);
        self
    }

    pub fn input_hints(mut self, input_hints: gtk::InputHints) -> Self {
        self.input_hints = Some(input_hints);
        self
    }

    pub fn input_purpose(mut self, input_purpose: gtk::InputPurpose) -> Self {
        self.input_purpose = Some(input_purpose);
        self
    }

    pub fn justification(mut self, justification: gtk::Justification) -> Self {
        self.justification = Some(justification);
        self
    }

    pub fn left_margin(mut self, left_margin: i32) -> Self {
        self.left_margin = Some(left_margin);
        self
    }

    pub fn monospace(mut self, monospace: bool) -> Self {
        self.monospace = Some(monospace);
        self
    }

    pub fn overwrite(mut self, overwrite: bool) -> Self {
        self.overwrite = Some(overwrite);
        self
    }

    pub fn pixels_above_lines(mut self, pixels_above_lines: i32) -> Self {
        self.pixels_above_lines = Some(pixels_above_lines);
        self
    }

    pub fn pixels_below_lines(mut self, pixels_below_lines: i32) -> Self {
        self.pixels_below_lines = Some(pixels_below_lines);
        self
    }

    pub fn pixels_inside_wrap(mut self, pixels_inside_wrap: i32) -> Self {
        self.pixels_inside_wrap = Some(pixels_inside_wrap);
        self
    }

    pub fn right_margin(mut self, right_margin: i32) -> Self {
        self.right_margin = Some(right_margin);
        self
    }

    pub fn tabs(mut self, tabs: &pango::TabArray) -> Self {
        self.tabs = Some(tabs.clone());
        self
    }

    pub fn top_margin(mut self, top_margin: i32) -> Self {
        self.top_margin = Some(top_margin);
        self
    }

    pub fn wrap_mode(mut self, wrap_mode: gtk::WrapMode) -> Self {
        self.wrap_mode = Some(wrap_mode);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager(mut self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: gtk::Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: gtk::AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }

    pub fn hadjustment(mut self, hadjustment: &impl IsA<gtk::Adjustment>) -> Self {
        self.hadjustment = Some(hadjustment.clone().upcast());
        self
    }

    pub fn hscroll_policy(mut self, hscroll_policy: gtk::ScrollablePolicy) -> Self {
        self.hscroll_policy = Some(hscroll_policy);
        self
    }

    pub fn vadjustment(mut self, vadjustment: &impl IsA<gtk::Adjustment>) -> Self {
        self.vadjustment = Some(vadjustment.clone().upcast());
        self
    }

    pub fn vscroll_policy(mut self, vscroll_policy: gtk::ScrollablePolicy) -> Self {
        self.vscroll_policy = Some(vscroll_policy);
        self
    }
}

pub trait ViewExt: 'static {
    #[doc(alias = "gtk_source_view_get_auto_indent")]
    #[doc(alias = "get_auto_indent")]
    fn is_auto_indent(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_background_pattern")]
    #[doc(alias = "get_background_pattern")]
    fn background_pattern(&self) -> BackgroundPatternType;

    #[doc(alias = "gtk_source_view_get_completion")]
    #[doc(alias = "get_completion")]
    fn completion(&self) -> Completion;

    #[doc(alias = "gtk_source_view_get_enable_snippets")]
    #[doc(alias = "get_enable_snippets")]
    fn enables_snippets(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_gutter")]
    #[doc(alias = "get_gutter")]
    fn gutter(&self, window_type: gtk::TextWindowType) -> Gutter;

    #[doc(alias = "gtk_source_view_get_highlight_current_line")]
    #[doc(alias = "get_highlight_current_line")]
    fn is_highlight_current_line(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_hover")]
    #[doc(alias = "get_hover")]
    fn hover(&self) -> Hover;

    #[doc(alias = "gtk_source_view_get_indent_on_tab")]
    #[doc(alias = "get_indent_on_tab")]
    fn is_indent_on_tab(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_indent_width")]
    #[doc(alias = "get_indent_width")]
    fn indent_width(&self) -> i32;

    #[doc(alias = "gtk_source_view_get_indenter")]
    #[doc(alias = "get_indenter")]
    fn indenter(&self) -> Option<Indenter>;

    #[doc(alias = "gtk_source_view_get_insert_spaces_instead_of_tabs")]
    #[doc(alias = "get_insert_spaces_instead_of_tabs")]
    fn is_insert_spaces_instead_of_tabs(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_right_margin_position")]
    #[doc(alias = "get_right_margin_position")]
    fn right_margin_position(&self) -> u32;

    #[doc(alias = "gtk_source_view_get_show_line_marks")]
    #[doc(alias = "get_show_line_marks")]
    fn shows_line_marks(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_show_line_numbers")]
    #[doc(alias = "get_show_line_numbers")]
    fn shows_line_numbers(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_show_right_margin")]
    #[doc(alias = "get_show_right_margin")]
    fn shows_right_margin(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_smart_backspace")]
    #[doc(alias = "get_smart_backspace")]
    fn is_smart_backspace(&self) -> bool;

    #[doc(alias = "gtk_source_view_get_smart_home_end")]
    #[doc(alias = "get_smart_home_end")]
    fn smart_home_end(&self) -> SmartHomeEndType;

    #[doc(alias = "gtk_source_view_get_space_drawer")]
    #[doc(alias = "get_space_drawer")]
    fn space_drawer(&self) -> SpaceDrawer;

    #[doc(alias = "gtk_source_view_get_tab_width")]
    #[doc(alias = "get_tab_width")]
    fn tab_width(&self) -> u32;

    #[doc(alias = "gtk_source_view_get_visual_column")]
    #[doc(alias = "get_visual_column")]
    fn visual_column(&self, iter: &gtk::TextIter) -> u32;

    #[doc(alias = "gtk_source_view_indent_lines")]
    fn indent_lines(&self, start: &mut gtk::TextIter, end: &mut gtk::TextIter);

    #[doc(alias = "gtk_source_view_set_auto_indent")]
    fn set_auto_indent(&self, enable: bool);

    #[doc(alias = "gtk_source_view_set_background_pattern")]
    fn set_background_pattern(&self, background_pattern: BackgroundPatternType);

    #[doc(alias = "gtk_source_view_set_enable_snippets")]
    fn set_enable_snippets(&self, enable_snippets: bool);

    #[doc(alias = "gtk_source_view_set_highlight_current_line")]
    fn set_highlight_current_line(&self, highlight: bool);

    #[doc(alias = "gtk_source_view_set_indent_on_tab")]
    fn set_indent_on_tab(&self, enable: bool);

    #[doc(alias = "gtk_source_view_set_indent_width")]
    fn set_indent_width(&self, width: i32);

    #[doc(alias = "gtk_source_view_set_indenter")]
    fn set_indenter(&self, indenter: Option<&impl IsA<Indenter>>);

    #[doc(alias = "gtk_source_view_set_insert_spaces_instead_of_tabs")]
    fn set_insert_spaces_instead_of_tabs(&self, enable: bool);

    #[doc(alias = "gtk_source_view_set_mark_attributes")]
    fn set_mark_attributes(&self, category: &str, attributes: &MarkAttributes, priority: i32);

    #[doc(alias = "gtk_source_view_set_right_margin_position")]
    fn set_right_margin_position(&self, pos: u32);

    #[doc(alias = "gtk_source_view_set_show_line_marks")]
    fn set_show_line_marks(&self, show: bool);

    #[doc(alias = "gtk_source_view_set_show_line_numbers")]
    fn set_show_line_numbers(&self, show: bool);

    #[doc(alias = "gtk_source_view_set_show_right_margin")]
    fn set_show_right_margin(&self, show: bool);

    #[doc(alias = "gtk_source_view_set_smart_backspace")]
    fn set_smart_backspace(&self, smart_backspace: bool);

    #[doc(alias = "gtk_source_view_set_smart_home_end")]
    fn set_smart_home_end(&self, smart_home_end: SmartHomeEndType);

    #[doc(alias = "gtk_source_view_set_tab_width")]
    fn set_tab_width(&self, width: u32);

    #[doc(alias = "gtk_source_view_unindent_lines")]
    fn unindent_lines(&self, start: &mut gtk::TextIter, end: &mut gtk::TextIter);

    #[doc(alias = "change-case")]
    fn connect_change_case<F: Fn(&Self, ChangeCaseType) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_change_case(&self, case_type: ChangeCaseType);

    #[doc(alias = "change-number")]
    fn connect_change_number<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_change_number(&self, count: i32);

    #[doc(alias = "join-lines")]
    fn connect_join_lines<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_join_lines(&self);

    #[doc(alias = "line-mark-activated")]
    fn connect_line_mark_activated<
        F: Fn(&Self, &gtk::TextIter, u32, gdk::ModifierType, i32) + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "move-lines")]
    fn connect_move_lines<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_move_lines(&self, down: bool);

    #[doc(alias = "move-to-matching-bracket")]
    fn connect_move_to_matching_bracket<F: Fn(&Self, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_to_matching_bracket(&self, extend_selection: bool);

    #[doc(alias = "move-words")]
    fn connect_move_words<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_move_words(&self, count: i32);

    //#[doc(alias = "push-snippet")]
    //fn connect_push_snippet<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-completion")]
    fn connect_show_completion<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_show_completion(&self);

    #[doc(alias = "smart-home-end")]
    fn connect_smart_home_end<F: Fn(&Self, &gtk::TextIter, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "auto-indent")]
    fn connect_auto_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background-pattern")]
    fn connect_background_pattern_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "completion")]
    fn connect_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "enable-snippets")]
    fn connect_enable_snippets_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "highlight-current-line")]
    fn connect_highlight_current_line_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "indent-on-tab")]
    fn connect_indent_on_tab_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "indent-width")]
    fn connect_indent_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "indenter")]
    fn connect_indenter_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "insert-spaces-instead-of-tabs")]
    fn connect_insert_spaces_instead_of_tabs_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "right-margin-position")]
    fn connect_right_margin_position_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "show-line-marks")]
    fn connect_show_line_marks_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-line-numbers")]
    fn connect_show_line_numbers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "show-right-margin")]
    fn connect_show_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "smart-backspace")]
    fn connect_smart_backspace_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "smart-home-end")]
    fn connect_smart_home_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "space-drawer")]
    fn connect_space_drawer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tab-width")]
    fn connect_tab_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<View>> ViewExt for O {
    fn is_auto_indent(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_auto_indent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn background_pattern(&self) -> BackgroundPatternType {
        unsafe {
            from_glib(ffi::gtk_source_view_get_background_pattern(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn completion(&self) -> Completion {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_completion(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn enables_snippets(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_enable_snippets(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn gutter(&self, window_type: gtk::TextWindowType) -> Gutter {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_gutter(
                self.as_ref().to_glib_none().0,
                window_type.into_glib(),
            ))
        }
    }

    fn is_highlight_current_line(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_highlight_current_line(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hover(&self) -> Hover {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_hover(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_indent_on_tab(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_indent_on_tab(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn indent_width(&self) -> i32 {
        unsafe { ffi::gtk_source_view_get_indent_width(self.as_ref().to_glib_none().0) }
    }

    fn indenter(&self) -> Option<Indenter> {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_indenter(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_insert_spaces_instead_of_tabs(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_insert_spaces_instead_of_tabs(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn right_margin_position(&self) -> u32 {
        unsafe { ffi::gtk_source_view_get_right_margin_position(self.as_ref().to_glib_none().0) }
    }

    fn shows_line_marks(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_show_line_marks(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shows_line_numbers(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_show_line_numbers(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shows_right_margin(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_show_right_margin(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_smart_backspace(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_view_get_smart_backspace(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn smart_home_end(&self) -> SmartHomeEndType {
        unsafe {
            from_glib(ffi::gtk_source_view_get_smart_home_end(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn space_drawer(&self) -> SpaceDrawer {
        unsafe {
            from_glib_none(ffi::gtk_source_view_get_space_drawer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tab_width(&self) -> u32 {
        unsafe { ffi::gtk_source_view_get_tab_width(self.as_ref().to_glib_none().0) }
    }

    fn visual_column(&self, iter: &gtk::TextIter) -> u32 {
        unsafe {
            ffi::gtk_source_view_get_visual_column(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none().0,
            )
        }
    }

    fn indent_lines(&self, start: &mut gtk::TextIter, end: &mut gtk::TextIter) {
        unsafe {
            ffi::gtk_source_view_indent_lines(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            );
        }
    }

    fn set_auto_indent(&self, enable: bool) {
        unsafe {
            ffi::gtk_source_view_set_auto_indent(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    fn set_background_pattern(&self, background_pattern: BackgroundPatternType) {
        unsafe {
            ffi::gtk_source_view_set_background_pattern(
                self.as_ref().to_glib_none().0,
                background_pattern.into_glib(),
            );
        }
    }

    fn set_enable_snippets(&self, enable_snippets: bool) {
        unsafe {
            ffi::gtk_source_view_set_enable_snippets(
                self.as_ref().to_glib_none().0,
                enable_snippets.into_glib(),
            );
        }
    }

    fn set_highlight_current_line(&self, highlight: bool) {
        unsafe {
            ffi::gtk_source_view_set_highlight_current_line(
                self.as_ref().to_glib_none().0,
                highlight.into_glib(),
            );
        }
    }

    fn set_indent_on_tab(&self, enable: bool) {
        unsafe {
            ffi::gtk_source_view_set_indent_on_tab(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    fn set_indent_width(&self, width: i32) {
        unsafe {
            ffi::gtk_source_view_set_indent_width(self.as_ref().to_glib_none().0, width);
        }
    }

    fn set_indenter(&self, indenter: Option<&impl IsA<Indenter>>) {
        unsafe {
            ffi::gtk_source_view_set_indenter(
                self.as_ref().to_glib_none().0,
                indenter.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_insert_spaces_instead_of_tabs(&self, enable: bool) {
        unsafe {
            ffi::gtk_source_view_set_insert_spaces_instead_of_tabs(
                self.as_ref().to_glib_none().0,
                enable.into_glib(),
            );
        }
    }

    fn set_mark_attributes(&self, category: &str, attributes: &MarkAttributes, priority: i32) {
        unsafe {
            ffi::gtk_source_view_set_mark_attributes(
                self.as_ref().to_glib_none().0,
                category.to_glib_none().0,
                attributes.to_glib_none().0,
                priority,
            );
        }
    }

    fn set_right_margin_position(&self, pos: u32) {
        unsafe {
            ffi::gtk_source_view_set_right_margin_position(self.as_ref().to_glib_none().0, pos);
        }
    }

    fn set_show_line_marks(&self, show: bool) {
        unsafe {
            ffi::gtk_source_view_set_show_line_marks(
                self.as_ref().to_glib_none().0,
                show.into_glib(),
            );
        }
    }

    fn set_show_line_numbers(&self, show: bool) {
        unsafe {
            ffi::gtk_source_view_set_show_line_numbers(
                self.as_ref().to_glib_none().0,
                show.into_glib(),
            );
        }
    }

    fn set_show_right_margin(&self, show: bool) {
        unsafe {
            ffi::gtk_source_view_set_show_right_margin(
                self.as_ref().to_glib_none().0,
                show.into_glib(),
            );
        }
    }

    fn set_smart_backspace(&self, smart_backspace: bool) {
        unsafe {
            ffi::gtk_source_view_set_smart_backspace(
                self.as_ref().to_glib_none().0,
                smart_backspace.into_glib(),
            );
        }
    }

    fn set_smart_home_end(&self, smart_home_end: SmartHomeEndType) {
        unsafe {
            ffi::gtk_source_view_set_smart_home_end(
                self.as_ref().to_glib_none().0,
                smart_home_end.into_glib(),
            );
        }
    }

    fn set_tab_width(&self, width: u32) {
        unsafe {
            ffi::gtk_source_view_set_tab_width(self.as_ref().to_glib_none().0, width);
        }
    }

    fn unindent_lines(&self, start: &mut gtk::TextIter, end: &mut gtk::TextIter) {
        unsafe {
            ffi::gtk_source_view_unindent_lines(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            );
        }
    }

    fn connect_change_case<F: Fn(&Self, ChangeCaseType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn change_case_trampoline<
            P: IsA<View>,
            F: Fn(&P, ChangeCaseType) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            case_type: ffi::GtkSourceChangeCaseType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(case_type),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"change-case\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    change_case_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_change_case(&self, case_type: ChangeCaseType) {
        self.emit_by_name::<()>("change-case", &[&case_type]);
    }

    fn connect_change_number<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn change_number_trampoline<P: IsA<View>, F: Fn(&P, i32) + 'static>(
            this: *mut ffi::GtkSourceView,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref(), count)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"change-number\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    change_number_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_change_number(&self, count: i32) {
        self.emit_by_name::<()>("change-number", &[&count]);
    }

    fn connect_join_lines<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn join_lines_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"join-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    join_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_join_lines(&self) {
        self.emit_by_name::<()>("join-lines", &[]);
    }

    fn connect_line_mark_activated<
        F: Fn(&Self, &gtk::TextIter, u32, gdk::ModifierType, i32) + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn line_mark_activated_trampoline<
            P: IsA<View>,
            F: Fn(&P, &gtk::TextIter, u32, gdk::ModifierType, i32) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            iter: *mut gtk::ffi::GtkTextIter,
            button: libc::c_uint,
            state: gdk::ffi::GdkModifierType,
            n_presses: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                button,
                from_glib(state),
                n_presses,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"line-mark-activated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    line_mark_activated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_move_lines<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_lines_trampoline<P: IsA<View>, F: Fn(&P, bool) + 'static>(
            this: *mut ffi::GtkSourceView,
            down: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(down),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_lines(&self, down: bool) {
        self.emit_by_name::<()>("move-lines", &[&down]);
    }

    fn connect_move_to_matching_bracket<F: Fn(&Self, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_to_matching_bracket_trampoline<
            P: IsA<View>,
            F: Fn(&P, bool) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            extend_selection: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-to-matching-bracket\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_to_matching_bracket_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_to_matching_bracket(&self, extend_selection: bool) {
        self.emit_by_name::<()>("move-to-matching-bracket", &[&extend_selection]);
    }

    fn connect_move_words<F: Fn(&Self, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_words_trampoline<P: IsA<View>, F: Fn(&P, i32) + 'static>(
            this: *mut ffi::GtkSourceView,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref(), count)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-words\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_words_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_words(&self, count: i32) {
        self.emit_by_name::<()>("move-words", &[&count]);
    }

    //fn connect_push_snippet<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    InOut location: Gtk.TextIter
    //}

    fn connect_show_completion<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn show_completion_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"show-completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    show_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_show_completion(&self) {
        self.emit_by_name::<()>("show-completion", &[]);
    }

    fn connect_smart_home_end<F: Fn(&Self, &gtk::TextIter, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn smart_home_end_trampoline<
            P: IsA<View>,
            F: Fn(&P, &gtk::TextIter, i32) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            iter: *mut gtk::ffi::GtkTextIter,
            count: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                View::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(iter),
                count,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"smart-home-end\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    smart_home_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_auto_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_auto_indent_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::auto-indent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_auto_indent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_pattern_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_pattern_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-pattern\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_pattern_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_completion_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_completion_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::completion\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_completion_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_enable_snippets_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_snippets_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-snippets\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_snippets_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_highlight_current_line_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_highlight_current_line_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::highlight-current-line\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_highlight_current_line_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_indent_on_tab_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_on_tab_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent-on-tab\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_on_tab_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_indent_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_width_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_indenter_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indenter_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indenter\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indenter_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_insert_spaces_instead_of_tabs_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_insert_spaces_instead_of_tabs_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::insert-spaces-instead-of-tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_insert_spaces_instead_of_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_right_margin_position_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_position_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin-position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_position_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_line_marks_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_line_marks_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-line-marks\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_line_marks_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_line_numbers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_line_numbers_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-line-numbers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_line_numbers_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_show_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_right_margin_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-right-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_show_right_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_smart_backspace_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_smart_backspace_trampoline<
            P: IsA<View>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::smart-backspace\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_smart_backspace_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_smart_home_end_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_smart_home_end_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::smart-home-end\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_smart_home_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_space_drawer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_space_drawer_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::space-drawer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_space_drawer_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tab_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tab_width_trampoline<P: IsA<View>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(View::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tab-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tab_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for View {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("View")
    }
}
