// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Snippet;
use glib::object::Cast;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceSnippetManager")]
    pub struct SnippetManager(Object<ffi::GtkSourceSnippetManager, ffi::GtkSourceSnippetManagerClass>);

    match fn {
        type_ => || ffi::gtk_source_snippet_manager_get_type(),
    }
}

impl SnippetManager {
    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SnippetManager`] objects.
    ///
    /// This method returns an instance of [`SnippetManagerBuilder`](crate::builders::SnippetManagerBuilder) which can be used to create [`SnippetManager`] objects.
    pub fn builder() -> SnippetManagerBuilder {
        SnippetManagerBuilder::default()
    }

    #[doc(alias = "gtk_source_snippet_manager_get_search_path")]
    #[doc(alias = "get_search_path")]
    pub fn search_path(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_source_snippet_manager_get_search_path(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_manager_get_snippet")]
    #[doc(alias = "get_snippet")]
    pub fn snippet(
        &self,
        group: Option<&str>,
        language_id: Option<&str>,
        trigger: &str,
    ) -> Option<Snippet> {
        unsafe {
            from_glib_full(ffi::gtk_source_snippet_manager_get_snippet(
                self.to_glib_none().0,
                group.to_glib_none().0,
                language_id.to_glib_none().0,
                trigger.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_manager_list_groups")]
    pub fn list_groups(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gtk_source_snippet_manager_list_groups(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_manager_list_matching")]
    pub fn list_matching(
        &self,
        group: Option<&str>,
        language_id: Option<&str>,
        trigger_prefix: Option<&str>,
    ) -> gio::ListModel {
        unsafe {
            from_glib_full(ffi::gtk_source_snippet_manager_list_matching(
                self.to_glib_none().0,
                group.to_glib_none().0,
                language_id.to_glib_none().0,
                trigger_prefix.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_manager_set_search_path")]
    pub fn set_search_path(&self, dirs: &[&str]) {
        unsafe {
            ffi::gtk_source_snippet_manager_set_search_path(
                self.to_glib_none().0,
                dirs.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_snippet_manager_get_default")]
    #[doc(alias = "get_default")]
    pub fn default() -> SnippetManager {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_source_snippet_manager_get_default()) }
    }

    #[doc(alias = "search-path")]
    pub fn connect_search_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_search_path_trampoline<F: Fn(&SnippetManager) + 'static>(
            this: *mut ffi::GtkSourceSnippetManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::search-path\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_search_path_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SnippetManager`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SnippetManagerBuilder {
    search_path: Option<Vec<String>>,
}

impl SnippetManagerBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`SnippetManagerBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SnippetManager`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SnippetManager {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref search_path) = self.search_path {
            properties.push(("search-path", search_path));
        }
        glib::Object::new::<SnippetManager>(&properties)
            .expect("Failed to create an instance of SnippetManager")
    }

    pub fn search_path(mut self, search_path: Vec<String>) -> Self {
        self.search_path = Some(search_path);
        self
    }
}

impl fmt::Display for SnippetManager {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SnippetManager")
    }
}
