// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::SnippetContext;
use glib::object::Cast;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceSnippetChunk")]
    pub struct SnippetChunk(Object<ffi::GtkSourceSnippetChunk, ffi::GtkSourceSnippetChunkClass>);

    match fn {
        type_ => || ffi::gtk_source_snippet_chunk_get_type(),
    }
}

impl SnippetChunk {
    #[doc(alias = "gtk_source_snippet_chunk_new")]
    pub fn new() -> SnippetChunk {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_source_snippet_chunk_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SnippetChunk`] objects.
    ///
    /// This method returns an instance of [`SnippetChunkBuilder`](crate::builders::SnippetChunkBuilder) which can be used to create [`SnippetChunk`] objects.
    pub fn builder() -> SnippetChunkBuilder {
        SnippetChunkBuilder::default()
    }

    #[doc(alias = "gtk_source_snippet_chunk_copy")]
    #[must_use]
    pub fn copy(&self) -> SnippetChunk {
        unsafe { from_glib_full(ffi::gtk_source_snippet_chunk_copy(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_source_snippet_chunk_get_context")]
    #[doc(alias = "get_context")]
    pub fn context(&self) -> SnippetContext {
        unsafe {
            from_glib_none(ffi::gtk_source_snippet_chunk_get_context(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_get_focus_position")]
    #[doc(alias = "get_focus_position")]
    pub fn focus_position(&self) -> i32 {
        unsafe { ffi::gtk_source_snippet_chunk_get_focus_position(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_source_snippet_chunk_get_spec")]
    #[doc(alias = "get_spec")]
    pub fn spec(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_source_snippet_chunk_get_spec(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_get_text")]
    #[doc(alias = "get_text")]
    pub fn text(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::gtk_source_snippet_chunk_get_text(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_get_text_set")]
    #[doc(alias = "get_text_set")]
    pub fn is_text_set(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_snippet_chunk_get_text_set(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_get_tooltip_text")]
    #[doc(alias = "get_tooltip_text")]
    pub fn tooltip_text(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::gtk_source_snippet_chunk_get_tooltip_text(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_set_context")]
    pub fn set_context(&self, context: &SnippetContext) {
        unsafe {
            ffi::gtk_source_snippet_chunk_set_context(
                self.to_glib_none().0,
                context.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_set_focus_position")]
    pub fn set_focus_position(&self, focus_position: i32) {
        unsafe {
            ffi::gtk_source_snippet_chunk_set_focus_position(self.to_glib_none().0, focus_position);
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_set_spec")]
    pub fn set_spec(&self, spec: &str) {
        unsafe {
            ffi::gtk_source_snippet_chunk_set_spec(self.to_glib_none().0, spec.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_set_text")]
    pub fn set_text(&self, text: &str) {
        unsafe {
            ffi::gtk_source_snippet_chunk_set_text(self.to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_set_text_set")]
    pub fn set_text_set(&self, text_set: bool) {
        unsafe {
            ffi::gtk_source_snippet_chunk_set_text_set(self.to_glib_none().0, text_set.into_glib());
        }
    }

    #[doc(alias = "gtk_source_snippet_chunk_set_tooltip_text")]
    pub fn set_tooltip_text(&self, tooltip_text: &str) {
        unsafe {
            ffi::gtk_source_snippet_chunk_set_tooltip_text(
                self.to_glib_none().0,
                tooltip_text.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "context")]
    pub fn connect_context_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_context_trampoline<F: Fn(&SnippetChunk) + 'static>(
            this: *mut ffi::GtkSourceSnippetChunk,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::context\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_context_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "focus-position")]
    pub fn connect_focus_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_focus_position_trampoline<F: Fn(&SnippetChunk) + 'static>(
            this: *mut ffi::GtkSourceSnippetChunk,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::focus-position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_focus_position_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "spec")]
    pub fn connect_spec_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spec_trampoline<F: Fn(&SnippetChunk) + 'static>(
            this: *mut ffi::GtkSourceSnippetChunk,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::spec\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_spec_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text")]
    pub fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<F: Fn(&SnippetChunk) + 'static>(
            this: *mut ffi::GtkSourceSnippetChunk,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text-set")]
    pub fn connect_text_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_set_trampoline<F: Fn(&SnippetChunk) + 'static>(
            this: *mut ffi::GtkSourceSnippetChunk,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_set_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tooltip-text")]
    pub fn connect_tooltip_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_text_trampoline<F: Fn(&SnippetChunk) + 'static>(
            this: *mut ffi::GtkSourceSnippetChunk,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tooltip-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tooltip_text_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for SnippetChunk {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SnippetChunk`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SnippetChunkBuilder {
    context: Option<SnippetContext>,
    focus_position: Option<i32>,
    spec: Option<String>,
    text: Option<String>,
    text_set: Option<bool>,
    tooltip_text: Option<String>,
}

impl SnippetChunkBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`SnippetChunkBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SnippetChunk`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SnippetChunk {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref context) = self.context {
            properties.push(("context", context));
        }
        if let Some(ref focus_position) = self.focus_position {
            properties.push(("focus-position", focus_position));
        }
        if let Some(ref spec) = self.spec {
            properties.push(("spec", spec));
        }
        if let Some(ref text) = self.text {
            properties.push(("text", text));
        }
        if let Some(ref text_set) = self.text_set {
            properties.push(("text-set", text_set));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        glib::Object::new::<SnippetChunk>(&properties)
            .expect("Failed to create an instance of SnippetChunk")
    }

    pub fn context(mut self, context: &SnippetContext) -> Self {
        self.context = Some(context.clone());
        self
    }

    pub fn focus_position(mut self, focus_position: i32) -> Self {
        self.focus_position = Some(focus_position);
        self
    }

    pub fn spec(mut self, spec: &str) -> Self {
        self.spec = Some(spec.to_string());
        self
    }

    pub fn text(mut self, text: &str) -> Self {
        self.text = Some(text.to_string());
        self
    }

    pub fn text_set(mut self, text_set: bool) -> Self {
        self.text_set = Some(text_set);
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }
}

impl fmt::Display for SnippetChunk {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SnippetChunk")
    }
}
