// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Buffer;
use crate::Completion;
use crate::CompletionActivation;
use crate::CompletionProvider;
use crate::Language;
use crate::View;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceCompletionContext")]
    pub struct CompletionContext(Object<ffi::GtkSourceCompletionContext, ffi::GtkSourceCompletionContextClass>) @implements gio::ListModel;

    match fn {
        type_ => || ffi::gtk_source_completion_context_get_type(),
    }
}

impl CompletionContext {
    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CompletionContext`] objects.
    ///
    /// This method returns an instance of [`CompletionContextBuilder`](crate::builders::CompletionContextBuilder) which can be used to create [`CompletionContext`] objects.
    pub fn builder() -> CompletionContextBuilder {
        CompletionContextBuilder::default()
    }

    #[doc(alias = "gtk_source_completion_context_get_activation")]
    #[doc(alias = "get_activation")]
    pub fn activation(&self) -> CompletionActivation {
        unsafe {
            from_glib(ffi::gtk_source_completion_context_get_activation(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_context_get_bounds")]
    #[doc(alias = "get_bounds")]
    pub fn bounds(&self) -> Option<(gtk::TextIter, gtk::TextIter)> {
        unsafe {
            let mut begin = gtk::TextIter::uninitialized();
            let mut end = gtk::TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_source_completion_context_get_bounds(
                self.to_glib_none().0,
                begin.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            ));
            if ret {
                Some((begin, end))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_source_completion_context_get_buffer")]
    #[doc(alias = "get_buffer")]
    pub fn buffer(&self) -> Option<Buffer> {
        unsafe {
            from_glib_none(ffi::gtk_source_completion_context_get_buffer(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_context_get_busy")]
    #[doc(alias = "get_busy")]
    pub fn is_busy(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_completion_context_get_busy(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_context_get_completion")]
    #[doc(alias = "get_completion")]
    pub fn completion(&self) -> Option<Completion> {
        unsafe {
            from_glib_none(ffi::gtk_source_completion_context_get_completion(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_context_get_empty")]
    #[doc(alias = "get_empty")]
    pub fn is_empty(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_completion_context_get_empty(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_context_get_language")]
    #[doc(alias = "get_language")]
    pub fn language(&self) -> Option<Language> {
        unsafe {
            from_glib_none(ffi::gtk_source_completion_context_get_language(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_context_get_view")]
    #[doc(alias = "get_view")]
    pub fn view(&self) -> Option<View> {
        unsafe {
            from_glib_none(ffi::gtk_source_completion_context_get_view(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_context_get_word")]
    #[doc(alias = "get_word")]
    pub fn word(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::gtk_source_completion_context_get_word(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_context_set_proposals_for_provider")]
    pub fn set_proposals_for_provider(
        &self,
        provider: &impl IsA<CompletionProvider>,
        results: Option<&impl IsA<gio::ListModel>>,
    ) {
        unsafe {
            ffi::gtk_source_completion_context_set_proposals_for_provider(
                self.to_glib_none().0,
                provider.as_ref().to_glib_none().0,
                results.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "busy")]
    pub fn connect_busy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_busy_trampoline<F: Fn(&CompletionContext) + 'static>(
            this: *mut ffi::GtkSourceCompletionContext,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::busy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_busy_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "empty")]
    pub fn connect_empty_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_empty_trampoline<F: Fn(&CompletionContext) + 'static>(
            this: *mut ffi::GtkSourceCompletionContext,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::empty\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_empty_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CompletionContext`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CompletionContextBuilder {
    completion: Option<Completion>,
}

impl CompletionContextBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`CompletionContextBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CompletionContext`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CompletionContext {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref completion) = self.completion {
            properties.push(("completion", completion));
        }
        glib::Object::new::<CompletionContext>(&properties)
            .expect("Failed to create an instance of CompletionContext")
    }

    pub fn completion(mut self, completion: &Completion) -> Self {
        self.completion = Some(completion.clone());
        self
    }
}

impl fmt::Display for CompletionContext {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("CompletionContext")
    }
}
