// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::RegionIter;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GtkSourceRegion")]
    pub struct Region(Object<ffi::GtkSourceRegion, ffi::GtkSourceRegionClass>);

    match fn {
        type_ => || ffi::gtk_source_region_get_type(),
    }
}

impl Region {
    pub const NONE: Option<&'static Region> = None;

    #[doc(alias = "gtk_source_region_new")]
    pub fn new(buffer: &impl IsA<gtk::TextBuffer>) -> Region {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_region_new(buffer.as_ref().to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Region`] objects.
    ///
    /// This method returns an instance of [`RegionBuilder`](crate::builders::RegionBuilder) which can be used to create [`Region`] objects.
    pub fn builder() -> RegionBuilder {
        RegionBuilder::default()
    }
}

impl Default for Region {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct Region object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Region`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct RegionBuilder {
    buffer: Option<gtk::TextBuffer>,
}

impl RegionBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`RegionBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Region`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Region {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref buffer) = self.buffer {
            properties.push(("buffer", buffer));
        }
        glib::Object::new::<Region>(&properties).expect("Failed to create an instance of Region")
    }

    pub fn buffer(mut self, buffer: &impl IsA<gtk::TextBuffer>) -> Self {
        self.buffer = Some(buffer.clone().upcast());
        self
    }
}

pub trait RegionExt: 'static {
    #[doc(alias = "gtk_source_region_add_region")]
    fn add_region(&self, region_to_add: Option<&impl IsA<Region>>);

    #[doc(alias = "gtk_source_region_add_subregion")]
    fn add_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter);

    #[doc(alias = "gtk_source_region_get_bounds")]
    #[doc(alias = "get_bounds")]
    fn bounds(&self) -> Option<(gtk::TextIter, gtk::TextIter)>;

    #[doc(alias = "gtk_source_region_get_buffer")]
    #[doc(alias = "get_buffer")]
    fn buffer(&self) -> Option<gtk::TextBuffer>;

    #[doc(alias = "gtk_source_region_get_start_region_iter")]
    #[doc(alias = "get_start_region_iter")]
    fn start_region_iter(&self) -> RegionIter;

    #[doc(alias = "gtk_source_region_intersect_region")]
    #[must_use]
    fn intersect_region(&self, region2: Option<&impl IsA<Region>>) -> Option<Region>;

    #[doc(alias = "gtk_source_region_intersect_subregion")]
    #[must_use]
    fn intersect_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) -> Option<Region>;

    #[doc(alias = "gtk_source_region_is_empty")]
    fn is_empty(&self) -> bool;

    #[doc(alias = "gtk_source_region_subtract_region")]
    fn subtract_region(&self, region_to_subtract: Option<&impl IsA<Region>>);

    #[doc(alias = "gtk_source_region_subtract_subregion")]
    fn subtract_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter);

    #[doc(alias = "gtk_source_region_to_string")]
    #[doc(alias = "to_string")]
    fn to_str(&self) -> Option<glib::GString>;
}

impl<O: IsA<Region>> RegionExt for O {
    fn add_region(&self, region_to_add: Option<&impl IsA<Region>>) {
        unsafe {
            ffi::gtk_source_region_add_region(
                self.as_ref().to_glib_none().0,
                region_to_add.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn add_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) {
        unsafe {
            ffi::gtk_source_region_add_subregion(
                self.as_ref().to_glib_none().0,
                _start.to_glib_none().0,
                _end.to_glib_none().0,
            );
        }
    }

    fn bounds(&self) -> Option<(gtk::TextIter, gtk::TextIter)> {
        unsafe {
            let mut start = gtk::TextIter::uninitialized();
            let mut end = gtk::TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_source_region_get_bounds(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            ));
            if ret {
                Some((start, end))
            } else {
                None
            }
        }
    }

    fn buffer(&self) -> Option<gtk::TextBuffer> {
        unsafe {
            from_glib_none(ffi::gtk_source_region_get_buffer(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn start_region_iter(&self) -> RegionIter {
        unsafe {
            let mut iter = RegionIter::uninitialized();
            ffi::gtk_source_region_get_start_region_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            );
            iter
        }
    }

    fn intersect_region(&self, region2: Option<&impl IsA<Region>>) -> Option<Region> {
        unsafe {
            from_glib_full(ffi::gtk_source_region_intersect_region(
                self.as_ref().to_glib_none().0,
                region2.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    fn intersect_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) -> Option<Region> {
        unsafe {
            from_glib_full(ffi::gtk_source_region_intersect_subregion(
                self.as_ref().to_glib_none().0,
                _start.to_glib_none().0,
                _end.to_glib_none().0,
            ))
        }
    }

    fn is_empty(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_region_is_empty(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn subtract_region(&self, region_to_subtract: Option<&impl IsA<Region>>) {
        unsafe {
            ffi::gtk_source_region_subtract_region(
                self.as_ref().to_glib_none().0,
                region_to_subtract.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn subtract_subregion(&self, _start: &gtk::TextIter, _end: &gtk::TextIter) {
        unsafe {
            ffi::gtk_source_region_subtract_subregion(
                self.as_ref().to_glib_none().0,
                _start.to_glib_none().0,
                _end.to_glib_none().0,
            );
        }
    }

    fn to_str(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_source_region_to_string(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for Region {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Region")
    }
}
