// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::HoverContext;
use crate::HoverDisplay;
use glib::object::IsA;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GtkSourceHoverProvider")]
    pub struct HoverProvider(Interface<ffi::GtkSourceHoverProvider, ffi::GtkSourceHoverProviderInterface>);

    match fn {
        type_ => || ffi::gtk_source_hover_provider_get_type(),
    }
}

impl HoverProvider {
    pub const NONE: Option<&'static HoverProvider> = None;
}

pub trait HoverProviderExt: 'static {
    #[doc(alias = "gtk_source_hover_provider_populate_async")]
    fn populate_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        context: &HoverContext,
        display: &HoverDisplay,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn populate_future(
        &self,
        context: &HoverContext,
        display: &HoverDisplay,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;
}

impl<O: IsA<HoverProvider>> HoverProviderExt for O {
    fn populate_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        context: &HoverContext,
        display: &HoverDisplay,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn populate_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_source_hover_provider_populate_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = populate_async_trampoline::<P>;
        unsafe {
            ffi::gtk_source_hover_provider_populate_async(
                self.as_ref().to_glib_none().0,
                context.to_glib_none().0,
                display.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn populate_future(
        &self,
        context: &HoverContext,
        display: &HoverDisplay,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let context = context.clone();
        let display = display.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.populate_async(&context, &display, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }
}

impl fmt::Display for HoverProvider {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("HoverProvider")
    }
}
