// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::CompressionType;
use crate::Encoding;
use crate::NewlineType;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceFile")]
    pub struct File(Object<ffi::GtkSourceFile, ffi::GtkSourceFileClass>);

    match fn {
        type_ => || ffi::gtk_source_file_get_type(),
    }
}

impl File {
    pub const NONE: Option<&'static File> = None;

    #[doc(alias = "gtk_source_file_new")]
    pub fn new() -> File {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_file_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`File`] objects.
    ///
    /// This method returns an instance of [`FileBuilder`](crate::builders::FileBuilder) which can be used to create [`File`] objects.
    pub fn builder() -> FileBuilder {
        FileBuilder::default()
    }
}

impl Default for File {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`File`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct FileBuilder {
    location: Option<gio::File>,
}

impl FileBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`FileBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`File`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> File {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref location) = self.location {
            properties.push(("location", location));
        }
        glib::Object::new::<File>(&properties).expect("Failed to create an instance of File")
    }

    pub fn location(mut self, location: &impl IsA<gio::File>) -> Self {
        self.location = Some(location.clone().upcast());
        self
    }
}

pub trait SourceFileExt: 'static {
    #[doc(alias = "gtk_source_file_check_file_on_disk")]
    fn check_file_on_disk(&self);

    #[doc(alias = "gtk_source_file_get_compression_type")]
    #[doc(alias = "get_compression_type")]
    fn compression_type(&self) -> CompressionType;

    #[doc(alias = "gtk_source_file_get_encoding")]
    #[doc(alias = "get_encoding")]
    fn encoding(&self) -> Encoding;

    #[doc(alias = "gtk_source_file_get_location")]
    #[doc(alias = "get_location")]
    fn location(&self) -> gio::File;

    #[doc(alias = "gtk_source_file_get_newline_type")]
    #[doc(alias = "get_newline_type")]
    fn newline_type(&self) -> NewlineType;

    #[doc(alias = "gtk_source_file_is_deleted")]
    fn is_deleted(&self) -> bool;

    #[doc(alias = "gtk_source_file_is_externally_modified")]
    fn is_externally_modified(&self) -> bool;

    #[doc(alias = "gtk_source_file_is_local")]
    fn is_local(&self) -> bool;

    #[doc(alias = "gtk_source_file_is_readonly")]
    fn is_readonly(&self) -> bool;

    #[doc(alias = "gtk_source_file_set_location")]
    fn set_location(&self, location: Option<&impl IsA<gio::File>>);

    //#[doc(alias = "gtk_source_file_set_mount_operation_factory")]
    //fn set_mount_operation_factory(&self, callback: /*Unimplemented*/Fn(&File, /*Unimplemented*/Option<Fundamental: Pointer>) -> gio::MountOperation, user_data: /*Unimplemented*/Option<Fundamental: Pointer>);

    #[doc(alias = "read-only")]
    fn is_read_only(&self) -> bool;

    #[doc(alias = "compression-type")]
    fn connect_compression_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "encoding")]
    fn connect_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "location")]
    fn connect_location_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "newline-type")]
    fn connect_newline_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "read-only")]
    fn connect_read_only_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<File>> SourceFileExt for O {
    fn check_file_on_disk(&self) {
        unsafe {
            ffi::gtk_source_file_check_file_on_disk(self.as_ref().to_glib_none().0);
        }
    }

    fn compression_type(&self) -> CompressionType {
        unsafe {
            from_glib(ffi::gtk_source_file_get_compression_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn encoding(&self) -> Encoding {
        unsafe {
            from_glib_none(ffi::gtk_source_file_get_encoding(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn location(&self) -> gio::File {
        unsafe {
            from_glib_none(ffi::gtk_source_file_get_location(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn newline_type(&self) -> NewlineType {
        unsafe {
            from_glib(ffi::gtk_source_file_get_newline_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_deleted(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_file_is_deleted(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_externally_modified(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_file_is_externally_modified(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_local(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_file_is_local(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_readonly(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_file_is_readonly(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_location(&self, location: Option<&impl IsA<gio::File>>) {
        unsafe {
            ffi::gtk_source_file_set_location(
                self.as_ref().to_glib_none().0,
                location.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    //fn set_mount_operation_factory(&self, callback: /*Unimplemented*/Fn(&File, /*Unimplemented*/Option<Fundamental: Pointer>) -> gio::MountOperation, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) {
    //    unsafe { TODO: call ffi:gtk_source_file_set_mount_operation_factory() }
    //}

    fn is_read_only(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "read-only")
    }

    fn connect_compression_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_compression_type_trampoline<
            P: IsA<File>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceFile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(File::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::compression-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_compression_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_encoding_trampoline<P: IsA<File>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceFile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(File::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::encoding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_encoding_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_location_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_location_trampoline<P: IsA<File>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceFile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(File::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::location\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_location_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_newline_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_newline_type_trampoline<P: IsA<File>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceFile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(File::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::newline-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_newline_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_read_only_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_read_only_trampoline<P: IsA<File>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceFile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(File::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::read-only\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_read_only_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for File {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("File")
    }
}
