// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::CompletionProvider;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceCompletionWords")]
    pub struct CompletionWords(Object<ffi::GtkSourceCompletionWords, ffi::GtkSourceCompletionWordsClass>) @implements CompletionProvider;

    match fn {
        type_ => || ffi::gtk_source_completion_words_get_type(),
    }
}

impl CompletionWords {
    pub const NONE: Option<&'static CompletionWords> = None;

    #[doc(alias = "gtk_source_completion_words_new")]
    pub fn new(title: Option<&str>) -> CompletionWords {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_completion_words_new(title.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CompletionWords`] objects.
    ///
    /// This method returns an instance of [`CompletionWordsBuilder`](crate::builders::CompletionWordsBuilder) which can be used to create [`CompletionWords`] objects.
    pub fn builder() -> CompletionWordsBuilder {
        CompletionWordsBuilder::default()
    }
}

impl Default for CompletionWords {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct CompletionWords object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CompletionWords`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CompletionWordsBuilder {
    minimum_word_size: Option<u32>,
    priority: Option<i32>,
    proposals_batch_size: Option<u32>,
    scan_batch_size: Option<u32>,
    title: Option<String>,
}

impl CompletionWordsBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`CompletionWordsBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CompletionWords`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CompletionWords {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref minimum_word_size) = self.minimum_word_size {
            properties.push(("minimum-word-size", minimum_word_size));
        }
        if let Some(ref priority) = self.priority {
            properties.push(("priority", priority));
        }
        if let Some(ref proposals_batch_size) = self.proposals_batch_size {
            properties.push(("proposals-batch-size", proposals_batch_size));
        }
        if let Some(ref scan_batch_size) = self.scan_batch_size {
            properties.push(("scan-batch-size", scan_batch_size));
        }
        if let Some(ref title) = self.title {
            properties.push(("title", title));
        }
        glib::Object::new::<CompletionWords>(&properties)
            .expect("Failed to create an instance of CompletionWords")
    }

    pub fn minimum_word_size(mut self, minimum_word_size: u32) -> Self {
        self.minimum_word_size = Some(minimum_word_size);
        self
    }

    pub fn priority(mut self, priority: i32) -> Self {
        self.priority = Some(priority);
        self
    }

    pub fn proposals_batch_size(mut self, proposals_batch_size: u32) -> Self {
        self.proposals_batch_size = Some(proposals_batch_size);
        self
    }

    pub fn scan_batch_size(mut self, scan_batch_size: u32) -> Self {
        self.scan_batch_size = Some(scan_batch_size);
        self
    }

    pub fn title(mut self, title: &str) -> Self {
        self.title = Some(title.to_string());
        self
    }
}

pub trait CompletionWordsExt: 'static {
    #[doc(alias = "gtk_source_completion_words_register")]
    fn register(&self, buffer: &impl IsA<gtk::TextBuffer>);

    #[doc(alias = "gtk_source_completion_words_unregister")]
    fn unregister(&self, buffer: &impl IsA<gtk::TextBuffer>);

    #[doc(alias = "minimum-word-size")]
    fn minimum_word_size(&self) -> u32;

    #[doc(alias = "minimum-word-size")]
    fn set_minimum_word_size(&self, minimum_word_size: u32);

    fn priority(&self) -> i32;

    fn set_priority(&self, priority: i32);

    #[doc(alias = "proposals-batch-size")]
    fn proposals_batch_size(&self) -> u32;

    #[doc(alias = "proposals-batch-size")]
    fn set_proposals_batch_size(&self, proposals_batch_size: u32);

    #[doc(alias = "scan-batch-size")]
    fn scan_batch_size(&self) -> u32;

    #[doc(alias = "scan-batch-size")]
    fn set_scan_batch_size(&self, scan_batch_size: u32);

    fn set_title(&self, title: Option<&str>);

    #[doc(alias = "minimum-word-size")]
    fn connect_minimum_word_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "priority")]
    fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "proposals-batch-size")]
    fn connect_proposals_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scan-batch-size")]
    fn connect_scan_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<CompletionWords>> CompletionWordsExt for O {
    fn register(&self, buffer: &impl IsA<gtk::TextBuffer>) {
        unsafe {
            ffi::gtk_source_completion_words_register(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    fn unregister(&self, buffer: &impl IsA<gtk::TextBuffer>) {
        unsafe {
            ffi::gtk_source_completion_words_unregister(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    fn minimum_word_size(&self) -> u32 {
        glib::ObjectExt::property(self.as_ref(), "minimum-word-size")
    }

    fn set_minimum_word_size(&self, minimum_word_size: u32) {
        glib::ObjectExt::set_property(self.as_ref(), "minimum-word-size", &minimum_word_size)
    }

    fn priority(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "priority")
    }

    fn set_priority(&self, priority: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "priority", &priority)
    }

    fn proposals_batch_size(&self) -> u32 {
        glib::ObjectExt::property(self.as_ref(), "proposals-batch-size")
    }

    fn set_proposals_batch_size(&self, proposals_batch_size: u32) {
        glib::ObjectExt::set_property(self.as_ref(), "proposals-batch-size", &proposals_batch_size)
    }

    fn scan_batch_size(&self) -> u32 {
        glib::ObjectExt::property(self.as_ref(), "scan-batch-size")
    }

    fn set_scan_batch_size(&self, scan_batch_size: u32) {
        glib::ObjectExt::set_property(self.as_ref(), "scan-batch-size", &scan_batch_size)
    }

    fn set_title(&self, title: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "title", &title)
    }

    fn connect_minimum_word_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_minimum_word_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::minimum-word-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_minimum_word_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_priority_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::priority\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_priority_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_proposals_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_proposals_batch_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::proposals-batch-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_proposals_batch_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scan_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scan_batch_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scan-batch-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scan_batch_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for CompletionWords {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("CompletionWords")
    }
}
