// Take a look at the license at the top of the repository in the LICENSE file.
#![cfg_attr(feature = "dox", feature(doc_cfg))]
// Re-export -sys
pub use ffi;

macro_rules! assert_initialized_main_thread {
    () => {
        if !::gtk::is_initialized_main_thread() {
            if ::gtk::is_initialized() {
                panic!("GtkSourceView may only be used from the main thread.");
            } else {
                panic!("Gtk has to be initialized before using GtkSourceView.");
            }
        }
    };
}

macro_rules! skip_assert_initialized {
    () => {};
}

#[allow(clippy::clone_on_copy)]
#[allow(clippy::let_and_return)]
#[allow(clippy::type_complexity)]
#[allow(unused_doc_comments)]
#[allow(unused_imports)]
mod auto;
pub use auto::*;

mod gutter_lines;
mod view;

pub mod prelude;
