// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::CompletionProvider;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceCompletionWords")]
    pub struct CompletionWords(Object<ffi::GtkSourceCompletionWords, ffi::GtkSourceCompletionWordsClass>) @implements CompletionProvider;

    match fn {
        type_ => || ffi::gtk_source_completion_words_get_type(),
    }
}

impl CompletionWords {
    #[doc(alias = "gtk_source_completion_words_new")]
    pub fn new(title: Option<&str>) -> CompletionWords {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_completion_words_new(title.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CompletionWords`] objects.
    ///
    /// This method returns an instance of [`CompletionWordsBuilder`] which can be used to create [`CompletionWords`] objects.
    pub fn builder() -> CompletionWordsBuilder {
        CompletionWordsBuilder::default()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CompletionWords`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct CompletionWordsBuilder {
    minimum_word_size: Option<u32>,
    priority: Option<i32>,
    proposals_batch_size: Option<u32>,
    scan_batch_size: Option<u32>,
    title: Option<String>,
}

impl CompletionWordsBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`CompletionWordsBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CompletionWords`].
    pub fn build(self) -> CompletionWords {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref minimum_word_size) = self.minimum_word_size {
            properties.push(("minimum-word-size", minimum_word_size));
        }
        if let Some(ref priority) = self.priority {
            properties.push(("priority", priority));
        }
        if let Some(ref proposals_batch_size) = self.proposals_batch_size {
            properties.push(("proposals-batch-size", proposals_batch_size));
        }
        if let Some(ref scan_batch_size) = self.scan_batch_size {
            properties.push(("scan-batch-size", scan_batch_size));
        }
        if let Some(ref title) = self.title {
            properties.push(("title", title));
        }
        glib::Object::new::<CompletionWords>(&properties)
            .expect("Failed to create an instance of CompletionWords")
    }

    pub fn minimum_word_size(mut self, minimum_word_size: u32) -> Self {
        self.minimum_word_size = Some(minimum_word_size);
        self
    }

    pub fn priority(mut self, priority: i32) -> Self {
        self.priority = Some(priority);
        self
    }

    pub fn proposals_batch_size(mut self, proposals_batch_size: u32) -> Self {
        self.proposals_batch_size = Some(proposals_batch_size);
        self
    }

    pub fn scan_batch_size(mut self, scan_batch_size: u32) -> Self {
        self.scan_batch_size = Some(scan_batch_size);
        self
    }

    pub fn title(mut self, title: &str) -> Self {
        self.title = Some(title.to_string());
        self
    }
}

pub const NONE_COMPLETION_WORDS: Option<&CompletionWords> = None;

pub trait CompletionWordsExt: 'static {
    #[doc(alias = "gtk_source_completion_words_register")]
    fn register<P: IsA<gtk::TextBuffer>>(&self, buffer: &P);

    #[doc(alias = "gtk_source_completion_words_unregister")]
    fn unregister<P: IsA<gtk::TextBuffer>>(&self, buffer: &P);

    #[doc(alias = "minimum-word-size")]
    fn minimum_word_size(&self) -> u32;

    #[doc(alias = "minimum-word-size")]
    fn set_minimum_word_size(&self, minimum_word_size: u32);

    fn priority(&self) -> i32;

    fn set_priority(&self, priority: i32);

    #[doc(alias = "proposals-batch-size")]
    fn proposals_batch_size(&self) -> u32;

    #[doc(alias = "proposals-batch-size")]
    fn set_proposals_batch_size(&self, proposals_batch_size: u32);

    #[doc(alias = "scan-batch-size")]
    fn scan_batch_size(&self) -> u32;

    #[doc(alias = "scan-batch-size")]
    fn set_scan_batch_size(&self, scan_batch_size: u32);

    fn set_title(&self, title: Option<&str>);

    #[doc(alias = "minimum-word-size")]
    fn connect_minimum_word_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "priority")]
    fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "proposals-batch-size")]
    fn connect_proposals_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scan-batch-size")]
    fn connect_scan_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<CompletionWords>> CompletionWordsExt for O {
    fn register<P: IsA<gtk::TextBuffer>>(&self, buffer: &P) {
        unsafe {
            ffi::gtk_source_completion_words_register(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    fn unregister<P: IsA<gtk::TextBuffer>>(&self, buffer: &P) {
        unsafe {
            ffi::gtk_source_completion_words_unregister(
                self.as_ref().to_glib_none().0,
                buffer.as_ref().to_glib_none().0,
            );
        }
    }

    fn minimum_word_size(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"minimum-word-size\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `minimum-word-size` getter")
        }
    }

    fn set_minimum_word_size(&self, minimum_word_size: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"minimum-word-size\0".as_ptr() as *const _,
                minimum_word_size.to_value().to_glib_none().0,
            );
        }
    }

    fn priority(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"priority\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `priority` getter")
        }
    }

    fn set_priority(&self, priority: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"priority\0".as_ptr() as *const _,
                priority.to_value().to_glib_none().0,
            );
        }
    }

    fn proposals_batch_size(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"proposals-batch-size\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `proposals-batch-size` getter")
        }
    }

    fn set_proposals_batch_size(&self, proposals_batch_size: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"proposals-batch-size\0".as_ptr() as *const _,
                proposals_batch_size.to_value().to_glib_none().0,
            );
        }
    }

    fn scan_batch_size(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"scan-batch-size\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `scan-batch-size` getter")
        }
    }

    fn set_scan_batch_size(&self, scan_batch_size: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"scan-batch-size\0".as_ptr() as *const _,
                scan_batch_size.to_value().to_glib_none().0,
            );
        }
    }

    fn set_title(&self, title: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"title\0".as_ptr() as *const _,
                title.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_minimum_word_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_minimum_word_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::minimum-word-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_minimum_word_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_priority_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::priority\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_priority_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_proposals_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_proposals_batch_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::proposals-batch-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_proposals_batch_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scan_batch_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scan_batch_size_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scan-batch-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scan_batch_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<
            P: IsA<CompletionWords>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletionWords,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(CompletionWords::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for CompletionWords {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("CompletionWords")
    }
}
