// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::SpaceLocationFlags;
use crate::SpaceTypeFlags;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceSpaceDrawer")]
    pub struct SpaceDrawer(Object<ffi::GtkSourceSpaceDrawer, ffi::GtkSourceSpaceDrawerClass>);

    match fn {
        type_ => || ffi::gtk_source_space_drawer_get_type(),
    }
}

impl SpaceDrawer {
    pub const NONE: Option<&'static SpaceDrawer> = None;

    #[doc(alias = "gtk_source_space_drawer_new")]
    pub fn new() -> SpaceDrawer {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_space_drawer_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`SpaceDrawer`] objects.
    ///
    /// This method returns an instance of [`SpaceDrawerBuilder`](crate::builders::SpaceDrawerBuilder) which can be used to create [`SpaceDrawer`] objects.
    pub fn builder() -> SpaceDrawerBuilder {
        SpaceDrawerBuilder::default()
    }
}

impl Default for SpaceDrawer {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`SpaceDrawer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct SpaceDrawerBuilder {
    enable_matrix: Option<bool>,
    matrix: Option<glib::Variant>,
}

impl SpaceDrawerBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`SpaceDrawerBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`SpaceDrawer`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> SpaceDrawer {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref enable_matrix) = self.enable_matrix {
            properties.push(("enable-matrix", enable_matrix));
        }
        if let Some(ref matrix) = self.matrix {
            properties.push(("matrix", matrix));
        }
        glib::Object::new::<SpaceDrawer>(&properties)
            .expect("Failed to create an instance of SpaceDrawer")
    }

    pub fn enable_matrix(mut self, enable_matrix: bool) -> Self {
        self.enable_matrix = Some(enable_matrix);
        self
    }

    pub fn matrix(mut self, matrix: &glib::Variant) -> Self {
        self.matrix = Some(matrix.clone());
        self
    }
}

pub trait SpaceDrawerExt: 'static {
    #[doc(alias = "gtk_source_space_drawer_bind_matrix_setting")]
    fn bind_matrix_setting(
        &self,
        settings: &impl IsA<gio::Settings>,
        key: &str,
        flags: gio::SettingsBindFlags,
    );

    #[doc(alias = "gtk_source_space_drawer_get_enable_matrix")]
    #[doc(alias = "get_enable_matrix")]
    fn enables_matrix(&self) -> bool;

    #[doc(alias = "gtk_source_space_drawer_get_matrix")]
    #[doc(alias = "get_matrix")]
    fn matrix(&self) -> Option<glib::Variant>;

    #[doc(alias = "gtk_source_space_drawer_get_types_for_locations")]
    #[doc(alias = "get_types_for_locations")]
    fn types_for_locations(&self, locations: SpaceLocationFlags) -> SpaceTypeFlags;

    #[doc(alias = "gtk_source_space_drawer_set_enable_matrix")]
    fn set_enable_matrix(&self, enable_matrix: bool);

    #[doc(alias = "gtk_source_space_drawer_set_matrix")]
    fn set_matrix(&self, matrix: Option<&glib::Variant>);

    #[doc(alias = "gtk_source_space_drawer_set_types_for_locations")]
    fn set_types_for_locations(&self, locations: SpaceLocationFlags, types: SpaceTypeFlags);

    #[doc(alias = "enable-matrix")]
    fn connect_enable_matrix_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "matrix")]
    fn connect_matrix_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<SpaceDrawer>> SpaceDrawerExt for O {
    fn bind_matrix_setting(
        &self,
        settings: &impl IsA<gio::Settings>,
        key: &str,
        flags: gio::SettingsBindFlags,
    ) {
        unsafe {
            ffi::gtk_source_space_drawer_bind_matrix_setting(
                self.as_ref().to_glib_none().0,
                settings.as_ref().to_glib_none().0,
                key.to_glib_none().0,
                flags.into_glib(),
            );
        }
    }

    fn enables_matrix(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_space_drawer_get_enable_matrix(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn matrix(&self) -> Option<glib::Variant> {
        unsafe {
            from_glib_full(ffi::gtk_source_space_drawer_get_matrix(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn types_for_locations(&self, locations: SpaceLocationFlags) -> SpaceTypeFlags {
        unsafe {
            from_glib(ffi::gtk_source_space_drawer_get_types_for_locations(
                self.as_ref().to_glib_none().0,
                locations.into_glib(),
            ))
        }
    }

    fn set_enable_matrix(&self, enable_matrix: bool) {
        unsafe {
            ffi::gtk_source_space_drawer_set_enable_matrix(
                self.as_ref().to_glib_none().0,
                enable_matrix.into_glib(),
            );
        }
    }

    fn set_matrix(&self, matrix: Option<&glib::Variant>) {
        unsafe {
            ffi::gtk_source_space_drawer_set_matrix(
                self.as_ref().to_glib_none().0,
                matrix.to_glib_none().0,
            );
        }
    }

    fn set_types_for_locations(&self, locations: SpaceLocationFlags, types: SpaceTypeFlags) {
        unsafe {
            ffi::gtk_source_space_drawer_set_types_for_locations(
                self.as_ref().to_glib_none().0,
                locations.into_glib(),
                types.into_glib(),
            );
        }
    }

    fn connect_enable_matrix_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_enable_matrix_trampoline<
            P: IsA<SpaceDrawer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceSpaceDrawer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SpaceDrawer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::enable-matrix\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_enable_matrix_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_matrix_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_matrix_trampoline<P: IsA<SpaceDrawer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceSpaceDrawer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(SpaceDrawer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::matrix\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_matrix_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for SpaceDrawer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("SpaceDrawer")
    }
}
