// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "GtkSourceMark")]
    pub struct Mark(Object<ffi::GtkSourceMark, ffi::GtkSourceMarkClass>) @extends gtk::TextMark;

    match fn {
        type_ => || ffi::gtk_source_mark_get_type(),
    }
}

impl Mark {
    pub const NONE: Option<&'static Mark> = None;

    #[doc(alias = "gtk_source_mark_new")]
    pub fn new(name: Option<&str>, category: &str) -> Mark {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_source_mark_new(
                name.to_glib_none().0,
                category.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Mark`] objects.
    ///
    /// This method returns an instance of [`MarkBuilder`](crate::builders::MarkBuilder) which can be used to create [`Mark`] objects.
    pub fn builder() -> MarkBuilder {
        MarkBuilder::default()
    }
}

impl Default for Mark {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct Mark object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Mark`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MarkBuilder {
    category: Option<String>,
    left_gravity: Option<bool>,
    name: Option<String>,
}

impl MarkBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`MarkBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Mark`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Mark {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref category) = self.category {
            properties.push(("category", category));
        }
        if let Some(ref left_gravity) = self.left_gravity {
            properties.push(("left-gravity", left_gravity));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        glib::Object::new::<Mark>(&properties).expect("Failed to create an instance of Mark")
    }

    pub fn category(mut self, category: &str) -> Self {
        self.category = Some(category.to_string());
        self
    }

    pub fn left_gravity(mut self, left_gravity: bool) -> Self {
        self.left_gravity = Some(left_gravity);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }
}

pub trait MarkExt: 'static {
    #[doc(alias = "gtk_source_mark_get_category")]
    #[doc(alias = "get_category")]
    fn category(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_source_mark_next")]
    #[must_use]
    fn next(&self, category: Option<&str>) -> Option<Mark>;

    #[doc(alias = "gtk_source_mark_prev")]
    #[must_use]
    fn prev(&self, category: &str) -> Option<Mark>;
}

impl<O: IsA<Mark>> MarkExt for O {
    fn category(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_source_mark_get_category(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn next(&self, category: Option<&str>) -> Option<Mark> {
        unsafe {
            from_glib_none(ffi::gtk_source_mark_next(
                self.as_ref().to_glib_none().0,
                category.to_glib_none().0,
            ))
        }
    }

    fn prev(&self, category: &str) -> Option<Mark> {
        unsafe {
            from_glib_none(ffi::gtk_source_mark_prev(
                self.as_ref().to_glib_none().0,
                category.to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for Mark {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Mark")
    }
}
