// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Language;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkSourceLanguageManager")]
    pub struct LanguageManager(Object<ffi::GtkSourceLanguageManager, ffi::GtkSourceLanguageManagerClass>);

    match fn {
        type_ => || ffi::gtk_source_language_manager_get_type(),
    }
}

impl LanguageManager {
    pub const NONE: Option<&'static LanguageManager> = None;

    #[doc(alias = "gtk_source_language_manager_new")]
    pub fn new() -> LanguageManager {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_language_manager_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`LanguageManager`] objects.
    ///
    /// This method returns an instance of [`LanguageManagerBuilder`](crate::builders::LanguageManagerBuilder) which can be used to create [`LanguageManager`] objects.
    pub fn builder() -> LanguageManagerBuilder {
        LanguageManagerBuilder::default()
    }

    #[doc(alias = "gtk_source_language_manager_get_default")]
    #[doc(alias = "get_default")]
    pub fn default() -> Option<LanguageManager> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gtk_source_language_manager_get_default()) }
    }
}

impl Default for LanguageManager {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`LanguageManager`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct LanguageManagerBuilder {
    search_path: Option<Vec<String>>,
}

impl LanguageManagerBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`LanguageManagerBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`LanguageManager`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> LanguageManager {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref search_path) = self.search_path {
            properties.push(("search-path", search_path));
        }
        glib::Object::new::<LanguageManager>(&properties)
            .expect("Failed to create an instance of LanguageManager")
    }

    pub fn search_path(mut self, search_path: Vec<String>) -> Self {
        self.search_path = Some(search_path);
        self
    }
}

pub trait LanguageManagerExt: 'static {
    #[doc(alias = "gtk_source_language_manager_get_language")]
    #[doc(alias = "get_language")]
    fn language(&self, id: &str) -> Option<Language>;

    #[doc(alias = "gtk_source_language_manager_get_language_ids")]
    #[doc(alias = "get_language_ids")]
    fn language_ids(&self) -> Vec<glib::GString>;

    #[doc(alias = "gtk_source_language_manager_get_search_path")]
    #[doc(alias = "get_search_path")]
    fn search_path(&self) -> Vec<glib::GString>;

    #[doc(alias = "gtk_source_language_manager_guess_language")]
    fn guess_language(
        &self,
        filename: Option<impl AsRef<std::path::Path>>,
        content_type: Option<&str>,
    ) -> Option<Language>;

    #[doc(alias = "gtk_source_language_manager_set_search_path")]
    fn set_search_path(&self, dirs: &[&str]);

    #[doc(alias = "language-ids")]
    fn connect_language_ids_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "search-path")]
    fn connect_search_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<LanguageManager>> LanguageManagerExt for O {
    fn language(&self, id: &str) -> Option<Language> {
        unsafe {
            from_glib_none(ffi::gtk_source_language_manager_get_language(
                self.as_ref().to_glib_none().0,
                id.to_glib_none().0,
            ))
        }
    }

    fn language_ids(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_source_language_manager_get_language_ids(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn search_path(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_source_language_manager_get_search_path(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn guess_language(
        &self,
        filename: Option<impl AsRef<std::path::Path>>,
        content_type: Option<&str>,
    ) -> Option<Language> {
        unsafe {
            from_glib_none(ffi::gtk_source_language_manager_guess_language(
                self.as_ref().to_glib_none().0,
                filename.as_ref().map(|p| p.as_ref()).to_glib_none().0,
                content_type.to_glib_none().0,
            ))
        }
    }

    fn set_search_path(&self, dirs: &[&str]) {
        unsafe {
            ffi::gtk_source_language_manager_set_search_path(
                self.as_ref().to_glib_none().0,
                dirs.to_glib_none().0,
            );
        }
    }

    fn connect_language_ids_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_ids_trampoline<
            P: IsA<LanguageManager>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceLanguageManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(LanguageManager::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language-ids\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_ids_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_search_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_search_path_trampoline<
            P: IsA<LanguageManager>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkSourceLanguageManager,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(LanguageManager::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::search-path\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_search_path_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for LanguageManager {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("LanguageManager")
    }
}
