// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::translate::*;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct MessageBody(Shared<ffi::SoupMessageBody>);

    match fn {
        ref => |ptr| ffi::soup_message_body_ref(ptr),
        unref => |ptr| ffi::soup_message_body_unref(ptr),
        type_ => || ffi::soup_message_body_get_type(),
    }
}

impl MessageBody {
    #[doc(alias = "soup_message_body_new")]
    pub fn new() -> MessageBody {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::soup_message_body_new()) }
    }

    #[doc(alias = "soup_message_body_append_bytes")]
    pub fn append_bytes(&self, buffer: &glib::Bytes) {
        unsafe {
            ffi::soup_message_body_append_bytes(self.to_glib_none().0, buffer.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_body_append_take")]
    pub fn append_take(&self, data: &[u8]) {
        let length = data.len() as usize;
        unsafe {
            ffi::soup_message_body_append_take(self.to_glib_none().0, data.to_glib_full(), length);
        }
    }

    #[doc(alias = "soup_message_body_complete")]
    pub fn complete(&self) {
        unsafe {
            ffi::soup_message_body_complete(self.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_body_flatten")]
    pub fn flatten(&self) -> Option<glib::Bytes> {
        unsafe { from_glib_full(ffi::soup_message_body_flatten(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_body_get_accumulate")]
    #[doc(alias = "get_accumulate")]
    pub fn is_accumulate(&self) -> bool {
        unsafe { from_glib(ffi::soup_message_body_get_accumulate(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_body_get_chunk")]
    #[doc(alias = "get_chunk")]
    pub fn chunk(&self, offset: i64) -> Option<glib::Bytes> {
        unsafe {
            from_glib_full(ffi::soup_message_body_get_chunk(
                self.to_glib_none().0,
                offset,
            ))
        }
    }

    #[doc(alias = "soup_message_body_got_chunk")]
    pub fn got_chunk(&self, chunk: &glib::Bytes) {
        unsafe {
            ffi::soup_message_body_got_chunk(self.to_glib_none().0, chunk.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_body_set_accumulate")]
    pub fn set_accumulate(&self, accumulate: bool) {
        unsafe {
            ffi::soup_message_body_set_accumulate(self.to_glib_none().0, accumulate.into_glib());
        }
    }

    #[doc(alias = "soup_message_body_truncate")]
    pub fn truncate(&self) {
        unsafe {
            ffi::soup_message_body_truncate(self.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_body_wrote_chunk")]
    pub fn wrote_chunk(&self, chunk: &glib::Bytes) {
        unsafe {
            ffi::soup_message_body_wrote_chunk(self.to_glib_none().0, chunk.to_glib_none().0);
        }
    }
}

impl Default for MessageBody {
    fn default() -> Self {
        Self::new()
    }
}
