// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/vhdirk/gir-files)
// DO NOT EDIT

use crate::AuthDomain;
use crate::ServerListenOptions;
use crate::ServerMessage;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "SoupServer")]
    pub struct Server(Object<ffi::SoupServer, ffi::SoupServerClass>);

    match fn {
        type_ => || ffi::soup_server_get_type(),
    }
}

impl Server {
    //#[doc(alias = "soup_server_new")]
    //pub fn new(optname1: &str, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> Option<Server> {
    //    unsafe { TODO: call ffi:soup_server_new() }
    //}
}

impl Server {
    pub const NONE: Option<&'static Server> = None;
}

pub trait ServerExt: 'static {
    #[doc(alias = "soup_server_accept_iostream")]
    fn accept_iostream(
        &self,
        stream: &impl IsA<gio::IOStream>,
        local_addr: Option<&impl IsA<gio::SocketAddress>>,
        remote_addr: Option<&impl IsA<gio::SocketAddress>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "soup_server_add_auth_domain")]
    fn add_auth_domain(&self, auth_domain: &impl IsA<AuthDomain>);

    //#[doc(alias = "soup_server_add_early_handler")]
    //fn add_early_handler(&self, path: Option<&str>, callback: /*Unimplemented*/Fn(&Server, &ServerMessage, &str, /*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }), user_data: /*Unimplemented*/Option<Fundamental: Pointer>);

    //#[doc(alias = "soup_server_add_handler")]
    //fn add_handler(&self, path: Option<&str>, callback: /*Unimplemented*/Fn(&Server, &ServerMessage, &str, /*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }), user_data: /*Unimplemented*/Option<Fundamental: Pointer>);

    #[doc(alias = "soup_server_add_websocket_extension")]
    fn add_websocket_extension(&self, extension_type: glib::types::Type);

    #[doc(alias = "soup_server_disconnect")]
    fn disconnect(&self);

    #[doc(alias = "soup_server_get_listeners")]
    #[doc(alias = "get_listeners")]
    fn listeners(&self) -> Vec<gio::Socket>;

    #[doc(alias = "soup_server_get_tls_auth_mode")]
    #[doc(alias = "get_tls_auth_mode")]
    fn tls_auth_mode(&self) -> gio::TlsAuthenticationMode;

    #[doc(alias = "soup_server_get_tls_certificate")]
    #[doc(alias = "get_tls_certificate")]
    fn tls_certificate(&self) -> Option<gio::TlsCertificate>;

    #[doc(alias = "soup_server_get_tls_database")]
    #[doc(alias = "get_tls_database")]
    fn tls_database(&self) -> Option<gio::TlsDatabase>;

    #[doc(alias = "soup_server_get_uris")]
    #[doc(alias = "get_uris")]
    fn uris(&self) -> Vec<glib::Uri>;

    #[doc(alias = "soup_server_is_https")]
    fn is_https(&self) -> bool;

    #[doc(alias = "soup_server_listen")]
    fn listen(
        &self,
        address: &impl IsA<gio::SocketAddress>,
        options: ServerListenOptions,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "soup_server_listen_all")]
    fn listen_all(&self, port: u32, options: ServerListenOptions) -> Result<(), glib::Error>;

    #[doc(alias = "soup_server_listen_local")]
    fn listen_local(&self, port: u32, options: ServerListenOptions) -> Result<(), glib::Error>;

    #[doc(alias = "soup_server_listen_socket")]
    fn listen_socket(
        &self,
        socket: &impl IsA<gio::Socket>,
        options: ServerListenOptions,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "soup_server_pause_message")]
    fn pause_message(&self, msg: &ServerMessage);

    #[doc(alias = "soup_server_remove_auth_domain")]
    fn remove_auth_domain(&self, auth_domain: &impl IsA<AuthDomain>);

    #[doc(alias = "soup_server_remove_handler")]
    fn remove_handler(&self, path: &str);

    #[doc(alias = "soup_server_remove_websocket_extension")]
    fn remove_websocket_extension(&self, extension_type: glib::types::Type);

    #[doc(alias = "soup_server_set_tls_auth_mode")]
    fn set_tls_auth_mode(&self, mode: gio::TlsAuthenticationMode);

    #[doc(alias = "soup_server_set_tls_certificate")]
    fn set_tls_certificate(&self, certificate: &impl IsA<gio::TlsCertificate>);

    #[doc(alias = "soup_server_set_tls_database")]
    fn set_tls_database(&self, tls_database: &impl IsA<gio::TlsDatabase>);

    #[doc(alias = "soup_server_unpause_message")]
    fn unpause_message(&self, msg: &ServerMessage);

    #[doc(alias = "raw-paths")]
    fn is_raw_paths(&self) -> bool;

    #[doc(alias = "server-header")]
    fn server_header(&self) -> Option<glib::GString>;

    #[doc(alias = "server-header")]
    fn set_server_header(&self, server_header: Option<&str>);

    #[doc(alias = "request-aborted")]
    fn connect_request_aborted<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "request-finished")]
    fn connect_request_finished<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "request-read")]
    fn connect_request_read<F: Fn(&Self, &ServerMessage) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "request-started")]
    fn connect_request_started<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "server-header")]
    fn connect_server_header_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tls-auth-mode")]
    fn connect_tls_auth_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tls-certificate")]
    fn connect_tls_certificate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tls-database")]
    fn connect_tls_database_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Server>> ServerExt for O {
    fn accept_iostream(
        &self,
        stream: &impl IsA<gio::IOStream>,
        local_addr: Option<&impl IsA<gio::SocketAddress>>,
        remote_addr: Option<&impl IsA<gio::SocketAddress>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::soup_server_accept_iostream(
                self.as_ref().to_glib_none().0,
                stream.as_ref().to_glib_none().0,
                local_addr.map(|p| p.as_ref()).to_glib_none().0,
                remote_addr.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn add_auth_domain(&self, auth_domain: &impl IsA<AuthDomain>) {
        unsafe {
            ffi::soup_server_add_auth_domain(
                self.as_ref().to_glib_none().0,
                auth_domain.as_ref().to_glib_none().0,
            );
        }
    }

    //fn add_early_handler(&self, path: Option<&str>, callback: /*Unimplemented*/Fn(&Server, &ServerMessage, &str, /*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }), user_data: /*Unimplemented*/Option<Fundamental: Pointer>) {
    //    unsafe { TODO: call ffi:soup_server_add_early_handler() }
    //}

    //fn add_handler(&self, path: Option<&str>, callback: /*Unimplemented*/Fn(&Server, &ServerMessage, &str, /*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }), user_data: /*Unimplemented*/Option<Fundamental: Pointer>) {
    //    unsafe { TODO: call ffi:soup_server_add_handler() }
    //}

    fn add_websocket_extension(&self, extension_type: glib::types::Type) {
        unsafe {
            ffi::soup_server_add_websocket_extension(
                self.as_ref().to_glib_none().0,
                extension_type.into_glib(),
            );
        }
    }

    fn disconnect(&self) {
        unsafe {
            ffi::soup_server_disconnect(self.as_ref().to_glib_none().0);
        }
    }

    fn listeners(&self) -> Vec<gio::Socket> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::soup_server_get_listeners(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tls_auth_mode(&self) -> gio::TlsAuthenticationMode {
        unsafe {
            from_glib(ffi::soup_server_get_tls_auth_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tls_certificate(&self) -> Option<gio::TlsCertificate> {
        unsafe {
            from_glib_none(ffi::soup_server_get_tls_certificate(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn tls_database(&self) -> Option<gio::TlsDatabase> {
        unsafe {
            from_glib_none(ffi::soup_server_get_tls_database(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn uris(&self) -> Vec<glib::Uri> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::soup_server_get_uris(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_https(&self) -> bool {
        unsafe { from_glib(ffi::soup_server_is_https(self.as_ref().to_glib_none().0)) }
    }

    fn listen(
        &self,
        address: &impl IsA<gio::SocketAddress>,
        options: ServerListenOptions,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::soup_server_listen(
                self.as_ref().to_glib_none().0,
                address.as_ref().to_glib_none().0,
                options.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn listen_all(&self, port: u32, options: ServerListenOptions) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::soup_server_listen_all(
                self.as_ref().to_glib_none().0,
                port,
                options.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn listen_local(&self, port: u32, options: ServerListenOptions) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::soup_server_listen_local(
                self.as_ref().to_glib_none().0,
                port,
                options.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn listen_socket(
        &self,
        socket: &impl IsA<gio::Socket>,
        options: ServerListenOptions,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::soup_server_listen_socket(
                self.as_ref().to_glib_none().0,
                socket.as_ref().to_glib_none().0,
                options.into_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn pause_message(&self, msg: &ServerMessage) {
        unsafe {
            ffi::soup_server_pause_message(self.as_ref().to_glib_none().0, msg.to_glib_none().0);
        }
    }

    fn remove_auth_domain(&self, auth_domain: &impl IsA<AuthDomain>) {
        unsafe {
            ffi::soup_server_remove_auth_domain(
                self.as_ref().to_glib_none().0,
                auth_domain.as_ref().to_glib_none().0,
            );
        }
    }

    fn remove_handler(&self, path: &str) {
        unsafe {
            ffi::soup_server_remove_handler(self.as_ref().to_glib_none().0, path.to_glib_none().0);
        }
    }

    fn remove_websocket_extension(&self, extension_type: glib::types::Type) {
        unsafe {
            ffi::soup_server_remove_websocket_extension(
                self.as_ref().to_glib_none().0,
                extension_type.into_glib(),
            );
        }
    }

    fn set_tls_auth_mode(&self, mode: gio::TlsAuthenticationMode) {
        unsafe {
            ffi::soup_server_set_tls_auth_mode(self.as_ref().to_glib_none().0, mode.into_glib());
        }
    }

    fn set_tls_certificate(&self, certificate: &impl IsA<gio::TlsCertificate>) {
        unsafe {
            ffi::soup_server_set_tls_certificate(
                self.as_ref().to_glib_none().0,
                certificate.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_tls_database(&self, tls_database: &impl IsA<gio::TlsDatabase>) {
        unsafe {
            ffi::soup_server_set_tls_database(
                self.as_ref().to_glib_none().0,
                tls_database.as_ref().to_glib_none().0,
            );
        }
    }

    fn unpause_message(&self, msg: &ServerMessage) {
        unsafe {
            ffi::soup_server_unpause_message(self.as_ref().to_glib_none().0, msg.to_glib_none().0);
        }
    }

    fn is_raw_paths(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"raw-paths\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `raw-paths` getter")
        }
    }

    fn server_header(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"server-header\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `server-header` getter")
        }
    }

    fn set_server_header(&self, server_header: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"server-header\0".as_ptr() as *const _,
                server_header.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_request_aborted<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_aborted_trampoline<
            P: IsA<Server>,
            F: Fn(&P, &ServerMessage) + 'static,
        >(
            this: *mut ffi::SoupServer,
            message: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Server::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(message),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-aborted\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    request_aborted_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_request_finished<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_finished_trampoline<
            P: IsA<Server>,
            F: Fn(&P, &ServerMessage) + 'static,
        >(
            this: *mut ffi::SoupServer,
            message: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Server::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(message),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-finished\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    request_finished_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_request_read<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_read_trampoline<
            P: IsA<Server>,
            F: Fn(&P, &ServerMessage) + 'static,
        >(
            this: *mut ffi::SoupServer,
            message: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Server::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(message),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-read\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    request_read_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_request_started<F: Fn(&Self, &ServerMessage) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn request_started_trampoline<
            P: IsA<Server>,
            F: Fn(&P, &ServerMessage) + 'static,
        >(
            this: *mut ffi::SoupServer,
            message: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Server::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(message),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"request-started\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    request_started_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_server_header_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_server_header_trampoline<
            P: IsA<Server>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Server::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::server-header\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_server_header_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tls_auth_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_auth_mode_trampoline<
            P: IsA<Server>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Server::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-auth-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tls_auth_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tls_certificate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_certificate_trampoline<
            P: IsA<Server>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Server::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-certificate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tls_certificate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tls_database_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_database_trampoline<P: IsA<Server>, F: Fn(&P) + 'static>(
            this: *mut ffi::SoupServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Server::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-database\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tls_database_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Server {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Server")
    }
}
