// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/vhdirk/gir-files)
// DO NOT EDIT

use crate::Encoding;
use crate::Expectation;
use crate::MessageHeadersType;
use glib::translate::*;
use std::mem;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct MessageHeaders(Shared<ffi::SoupMessageHeaders>);

    match fn {
        ref => |ptr| ffi::soup_message_headers_ref(ptr),
        unref => |ptr| ffi::soup_message_headers_unref(ptr),
        type_ => || ffi::soup_message_headers_get_type(),
    }
}

impl MessageHeaders {
    #[doc(alias = "soup_message_headers_new")]
    pub fn new(type_: MessageHeadersType) -> MessageHeaders {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::soup_message_headers_new(type_.into_glib())) }
    }

    #[doc(alias = "soup_message_headers_append")]
    pub fn append(&self, name: &str, value: &str) {
        unsafe {
            ffi::soup_message_headers_append(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_message_headers_clean_connection_headers")]
    pub fn clean_connection_headers(&self) {
        unsafe {
            ffi::soup_message_headers_clean_connection_headers(self.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_headers_clear")]
    pub fn clear(&self) {
        unsafe {
            ffi::soup_message_headers_clear(self.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_headers_foreach")]
    pub fn foreach<P: FnMut(&str, &str)>(&self, func: P) {
        let func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&str, &str)>(
            name: *const libc::c_char,
            value: *const libc::c_char,
            user_data: glib::ffi::gpointer,
        ) {
            let name: Borrowed<glib::GString> = from_glib_borrow(name);
            let value: Borrowed<glib::GString> = from_glib_borrow(value);
            let callback: *mut P = user_data as *const _ as usize as *mut P;
            (*callback)(name.as_str(), value.as_str());
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &P = &func_data;
        unsafe {
            ffi::soup_message_headers_foreach(
                self.to_glib_none().0,
                func,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    //#[doc(alias = "soup_message_headers_free_ranges")]
    //pub fn free_ranges(&self, ranges: /*Ignored*/&mut Range) {
    //    unsafe { TODO: call ffi:soup_message_headers_free_ranges() }
    //}

    //#[doc(alias = "soup_message_headers_get_content_disposition")]
    //#[doc(alias = "get_content_disposition")]
    //pub fn content_disposition(&self, params: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }) -> Option<glib::GString> {
    //    unsafe { TODO: call ffi:soup_message_headers_get_content_disposition() }
    //}

    #[doc(alias = "soup_message_headers_get_content_length")]
    #[doc(alias = "get_content_length")]
    pub fn content_length(&self) -> i64 {
        unsafe { ffi::soup_message_headers_get_content_length(self.to_glib_none().0) }
    }

    #[doc(alias = "soup_message_headers_get_content_range")]
    #[doc(alias = "get_content_range")]
    pub fn content_range(&self) -> Option<(i64, i64, i64)> {
        unsafe {
            let mut start = mem::MaybeUninit::uninit();
            let mut end = mem::MaybeUninit::uninit();
            let mut total_length = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::soup_message_headers_get_content_range(
                self.to_glib_none().0,
                start.as_mut_ptr(),
                end.as_mut_ptr(),
                total_length.as_mut_ptr(),
            ));
            let start = start.assume_init();
            let end = end.assume_init();
            let total_length = total_length.assume_init();
            if ret {
                Some((start, end, total_length))
            } else {
                None
            }
        }
    }

    //#[doc(alias = "soup_message_headers_get_content_type")]
    //#[doc(alias = "get_content_type")]
    //pub fn content_type(&self, params: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }) -> Option<glib::GString> {
    //    unsafe { TODO: call ffi:soup_message_headers_get_content_type() }
    //}

    #[doc(alias = "soup_message_headers_get_encoding")]
    #[doc(alias = "get_encoding")]
    pub fn encoding(&self) -> Encoding {
        unsafe {
            from_glib(ffi::soup_message_headers_get_encoding(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_headers_get_expectations")]
    #[doc(alias = "get_expectations")]
    pub fn expectations(&self) -> Expectation {
        unsafe {
            from_glib(ffi::soup_message_headers_get_expectations(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_headers_get_headers_type")]
    #[doc(alias = "get_headers_type")]
    pub fn headers_type(&self) -> MessageHeadersType {
        unsafe {
            from_glib(ffi::soup_message_headers_get_headers_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_headers_get_list")]
    #[doc(alias = "get_list")]
    pub fn list(&self, name: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_message_headers_get_list(
                self.to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_headers_get_one")]
    #[doc(alias = "get_one")]
    pub fn one(&self, name: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_message_headers_get_one(
                self.to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    //#[doc(alias = "soup_message_headers_get_ranges")]
    //#[doc(alias = "get_ranges")]
    //pub fn ranges(&self, total_length: i64, ranges: /*Ignored*/Vec<Range>) -> Option<i32> {
    //    unsafe { TODO: call ffi:soup_message_headers_get_ranges() }
    //}

    #[doc(alias = "soup_message_headers_header_contains")]
    pub fn header_contains(&self, name: &str, token: &str) -> bool {
        unsafe {
            from_glib(ffi::soup_message_headers_header_contains(
                self.to_glib_none().0,
                name.to_glib_none().0,
                token.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_headers_header_equals")]
    pub fn header_equals(&self, name: &str, value: &str) -> bool {
        unsafe {
            from_glib(ffi::soup_message_headers_header_equals(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_headers_remove")]
    pub fn remove(&self, name: &str) {
        unsafe {
            ffi::soup_message_headers_remove(self.to_glib_none().0, name.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_headers_replace")]
    pub fn replace(&self, name: &str, value: &str) {
        unsafe {
            ffi::soup_message_headers_replace(
                self.to_glib_none().0,
                name.to_glib_none().0,
                value.to_glib_none().0,
            );
        }
    }

    //#[doc(alias = "soup_message_headers_set_content_disposition")]
    //pub fn set_content_disposition(&self, disposition: &str, params: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }) {
    //    unsafe { TODO: call ffi:soup_message_headers_set_content_disposition() }
    //}

    #[doc(alias = "soup_message_headers_set_content_length")]
    pub fn set_content_length(&self, content_length: i64) {
        unsafe {
            ffi::soup_message_headers_set_content_length(self.to_glib_none().0, content_length);
        }
    }

    #[doc(alias = "soup_message_headers_set_content_range")]
    pub fn set_content_range(&self, start: i64, end: i64, total_length: i64) {
        unsafe {
            ffi::soup_message_headers_set_content_range(
                self.to_glib_none().0,
                start,
                end,
                total_length,
            );
        }
    }

    //#[doc(alias = "soup_message_headers_set_content_type")]
    //pub fn set_content_type(&self, content_type: &str, params: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }) {
    //    unsafe { TODO: call ffi:soup_message_headers_set_content_type() }
    //}

    #[doc(alias = "soup_message_headers_set_encoding")]
    pub fn set_encoding(&self, encoding: Encoding) {
        unsafe {
            ffi::soup_message_headers_set_encoding(self.to_glib_none().0, encoding.into_glib());
        }
    }

    #[doc(alias = "soup_message_headers_set_expectations")]
    pub fn set_expectations(&self, expectations: Expectation) {
        unsafe {
            ffi::soup_message_headers_set_expectations(
                self.to_glib_none().0,
                expectations.into_glib(),
            );
        }
    }

    #[doc(alias = "soup_message_headers_set_range")]
    pub fn set_range(&self, start: i64, end: i64) {
        unsafe {
            ffi::soup_message_headers_set_range(self.to_glib_none().0, start, end);
        }
    }

    //#[doc(alias = "soup_message_headers_set_ranges")]
    //pub fn set_ranges(&self, ranges: /*Ignored*/&mut Range, length: i32) {
    //    unsafe { TODO: call ffi:soup_message_headers_set_ranges() }
    //}
}
