// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/vhdirk/gir-files)
// DO NOT EDIT

use crate::CacheType;
use crate::SessionFeature;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "SoupCache")]
    pub struct Cache(Object<ffi::SoupCache, ffi::SoupCacheClass>) @implements SessionFeature;

    match fn {
        type_ => || ffi::soup_cache_get_type(),
    }
}

impl Cache {
    #[doc(alias = "soup_cache_new")]
    pub fn new(cache_dir: Option<&str>, cache_type: CacheType) -> Cache {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_cache_new(
                cache_dir.to_glib_none().0,
                cache_type.into_glib(),
            ))
        }
    }
}

impl Cache {
    pub const NONE: Option<&'static Cache> = None;
}

pub trait CacheExt: 'static {
    #[doc(alias = "soup_cache_clear")]
    fn clear(&self);

    #[doc(alias = "soup_cache_dump")]
    fn dump(&self);

    #[doc(alias = "soup_cache_flush")]
    fn flush(&self);

    #[doc(alias = "soup_cache_get_max_size")]
    #[doc(alias = "get_max_size")]
    fn max_size(&self) -> u32;

    #[doc(alias = "soup_cache_load")]
    fn load(&self);

    #[doc(alias = "soup_cache_set_max_size")]
    fn set_max_size(&self, max_size: u32);

    #[doc(alias = "cache-dir")]
    fn cache_dir(&self) -> Option<glib::GString>;

    #[doc(alias = "cache-type")]
    fn cache_type(&self) -> CacheType;
}

impl<O: IsA<Cache>> CacheExt for O {
    fn clear(&self) {
        unsafe {
            ffi::soup_cache_clear(self.as_ref().to_glib_none().0);
        }
    }

    fn dump(&self) {
        unsafe {
            ffi::soup_cache_dump(self.as_ref().to_glib_none().0);
        }
    }

    fn flush(&self) {
        unsafe {
            ffi::soup_cache_flush(self.as_ref().to_glib_none().0);
        }
    }

    fn max_size(&self) -> u32 {
        unsafe { ffi::soup_cache_get_max_size(self.as_ref().to_glib_none().0) }
    }

    fn load(&self) {
        unsafe {
            ffi::soup_cache_load(self.as_ref().to_glib_none().0);
        }
    }

    fn set_max_size(&self, max_size: u32) {
        unsafe {
            ffi::soup_cache_set_max_size(self.as_ref().to_glib_none().0, max_size);
        }
    }

    fn cache_dir(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"cache-dir\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `cache-dir` getter")
        }
    }

    fn cache_type(&self) -> CacheType {
        unsafe {
            let mut value = glib::Value::from_type(<CacheType as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"cache-type\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `cache-type` getter")
        }
    }
}

impl fmt::Display for Cache {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Cache")
    }
}
