// // Copyright 2013-2017, The Gtk-rs Project Developers.
// // See the COPYRIGHT file at the top-level directory of this distribution.
// // Licensed under the MIT license, see the LICENSE file or <https://opensource.org/licenses/MIT>
#![cfg_attr(feature = "dox", feature(doc_cfg))]

use ffi::*;
use glib::translate::{FromGlibPtrFull, FromGlibPtrNone};
use std::ptr;

pub use gio;
pub use glib;

pub use glib::{
    Bytes, ChecksumType, DateTime, Error, IOCondition, Priority, SeekType, Source, Variant,
    VariantType,
};

#[macro_use]
mod rt;

mod auto;
pub use auto::{traits::*, *};

mod functions;
pub use functions::*;

mod cookie_jar;
pub use cookie_jar::CookieJarExtManual;

mod session;
pub use session::SessionExtManual;

mod server;
pub use server::ServerExtManual;
