// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::HTTPVersion;
use crate::MemoryUse;
use crate::MessageBody;
use crate::MessageHeaders;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "SoupServerMessage")]
    pub struct ServerMessage(Object<ffi::SoupServerMessage, ffi::SoupServerMessageClass>);

    match fn {
        type_ => || ffi::soup_server_message_get_type(),
    }
}

impl ServerMessage {
    #[doc(alias = "soup_server_message_get_http_version")]
    #[doc(alias = "get_http_version")]
    pub fn http_version(&self) -> HTTPVersion {
        unsafe {
            from_glib(ffi::soup_server_message_get_http_version(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_local_address")]
    #[doc(alias = "get_local_address")]
    pub fn local_address(&self) -> Option<gio::SocketAddress> {
        unsafe {
            from_glib_none(ffi::soup_server_message_get_local_address(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_method")]
    #[doc(alias = "get_method")]
    pub fn method(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::soup_server_message_get_method(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_server_message_get_reason_phrase")]
    #[doc(alias = "get_reason_phrase")]
    pub fn reason_phrase(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_server_message_get_reason_phrase(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_remote_address")]
    #[doc(alias = "get_remote_address")]
    pub fn remote_address(&self) -> Option<gio::SocketAddress> {
        unsafe {
            from_glib_none(ffi::soup_server_message_get_remote_address(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_remote_host")]
    #[doc(alias = "get_remote_host")]
    pub fn remote_host(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_server_message_get_remote_host(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_request_body")]
    #[doc(alias = "get_request_body")]
    pub fn request_body(&self) -> Option<MessageBody> {
        unsafe {
            from_glib_none(ffi::soup_server_message_get_request_body(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_request_headers")]
    #[doc(alias = "get_request_headers")]
    pub fn request_headers(&self) -> Option<MessageHeaders> {
        unsafe {
            from_glib_none(ffi::soup_server_message_get_request_headers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_response_body")]
    #[doc(alias = "get_response_body")]
    pub fn response_body(&self) -> Option<MessageBody> {
        unsafe {
            from_glib_none(ffi::soup_server_message_get_response_body(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_response_headers")]
    #[doc(alias = "get_response_headers")]
    pub fn response_headers(&self) -> Option<MessageHeaders> {
        unsafe {
            from_glib_none(ffi::soup_server_message_get_response_headers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_get_socket")]
    #[doc(alias = "get_socket")]
    pub fn socket(&self) -> Option<gio::Socket> {
        unsafe { from_glib_none(ffi::soup_server_message_get_socket(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_server_message_get_status")]
    #[doc(alias = "get_status")]
    pub fn status(&self) -> u32 {
        unsafe { ffi::soup_server_message_get_status(self.to_glib_none().0) }
    }

    #[doc(alias = "soup_server_message_get_uri")]
    #[doc(alias = "get_uri")]
    pub fn uri(&self) -> Option<glib::Uri> {
        unsafe { from_glib_none(ffi::soup_server_message_get_uri(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_server_message_is_options_ping")]
    pub fn is_options_ping(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_server_message_is_options_ping(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_server_message_set_http_version")]
    pub fn set_http_version(&self, version: HTTPVersion) {
        unsafe {
            ffi::soup_server_message_set_http_version(self.to_glib_none().0, version.into_glib());
        }
    }

    #[doc(alias = "soup_server_message_set_redirect")]
    pub fn set_redirect(&self, status_code: u32, redirect_uri: &str) {
        unsafe {
            ffi::soup_server_message_set_redirect(
                self.to_glib_none().0,
                status_code,
                redirect_uri.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_server_message_set_response")]
    pub fn set_response(&self, content_type: Option<&str>, resp_use: MemoryUse, resp_body: &[u8]) {
        let resp_length = resp_body.len() as usize;
        unsafe {
            ffi::soup_server_message_set_response(
                self.to_glib_none().0,
                content_type.to_glib_none().0,
                resp_use.into_glib(),
                resp_body.to_glib_none().0,
                resp_length,
            );
        }
    }

    #[doc(alias = "soup_server_message_set_status")]
    pub fn set_status(&self, status_code: u32, reason_phrase: Option<&str>) {
        unsafe {
            ffi::soup_server_message_set_status(
                self.to_glib_none().0,
                status_code,
                reason_phrase.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_server_message_steal_connection")]
    pub fn steal_connection(&self) -> Option<gio::IOStream> {
        unsafe {
            from_glib_full(ffi::soup_server_message_steal_connection(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "accept-certificate")]
    pub fn connect_accept_certificate<
        F: Fn(&Self, &gio::TlsCertificate, gio::TlsCertificateFlags) -> bool + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn accept_certificate_trampoline<
            F: Fn(&ServerMessage, &gio::TlsCertificate, gio::TlsCertificateFlags) -> bool + 'static,
        >(
            this: *mut ffi::SoupServerMessage,
            tls_peer_certificate: *mut gio::ffi::GTlsCertificate,
            tls_peer_errors: gio::ffi::GTlsCertificateFlags,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(tls_peer_certificate),
                from_glib(tls_peer_errors),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"accept-certificate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    accept_certificate_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "disconnected")]
    pub fn connect_disconnected<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn disconnected_trampoline<F: Fn(&ServerMessage) + 'static>(
            this: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"disconnected\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    disconnected_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "finished")]
    pub fn connect_finished<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn finished_trampoline<F: Fn(&ServerMessage) + 'static>(
            this: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"finished\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    finished_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "got-body")]
    pub fn connect_got_body<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_body_trampoline<F: Fn(&ServerMessage) + 'static>(
            this: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"got-body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    got_body_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "got-chunk")]
    pub fn connect_got_chunk<F: Fn(&Self, &glib::Bytes) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_chunk_trampoline<F: Fn(&ServerMessage, &glib::Bytes) + 'static>(
            this: *mut ffi::SoupServerMessage,
            chunk: *mut glib::ffi::GBytes,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(chunk))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"got-chunk\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    got_chunk_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "got-headers")]
    pub fn connect_got_headers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_headers_trampoline<F: Fn(&ServerMessage) + 'static>(
            this: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"got-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    got_headers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrote-body")]
    pub fn connect_wrote_body<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_body_trampoline<F: Fn(&ServerMessage) + 'static>(
            this: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"wrote-body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    wrote_body_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrote-body-data")]
    pub fn connect_wrote_body_data<F: Fn(&Self, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_body_data_trampoline<F: Fn(&ServerMessage, u32) + 'static>(
            this: *mut ffi::SoupServerMessage,
            chunk_size: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), chunk_size)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"wrote-body-data\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    wrote_body_data_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrote-chunk")]
    pub fn connect_wrote_chunk<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_chunk_trampoline<F: Fn(&ServerMessage) + 'static>(
            this: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"wrote-chunk\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    wrote_chunk_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrote-headers")]
    pub fn connect_wrote_headers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_headers_trampoline<F: Fn(&ServerMessage) + 'static>(
            this: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"wrote-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    wrote_headers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrote-informational")]
    pub fn connect_wrote_informational<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_informational_trampoline<F: Fn(&ServerMessage) + 'static>(
            this: *mut ffi::SoupServerMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"wrote-informational\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    wrote_informational_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for ServerMessage {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ServerMessage")
    }
}
