use crate::AuthDomain;
use crate::Server;
use crate::ServerListenOptions;
use crate::ServerMessage;
use crate::WebsocketConnection;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

pub trait ServerExtManual: 'static {
    #[doc(alias = "soup_server_add_websocket_handler")]
    fn add_websocket_handler<P: Fn(&Server, &ServerMessage, &str, &WebsocketConnection) + 'static>(
        &self,
        path: Option<&str>,
        origin: Option<&str>,
        protocols: &[&str],
        callback: P,
    );
}

impl<O: IsA<Server>> ServerExtManual for O {
    fn add_websocket_handler<
        P: Fn(&Server, &ServerMessage, &str, &WebsocketConnection) + 'static,
    >(
        &self,
        path: Option<&str>,
        origin: Option<&str>,
        protocols: &[&str],
        callback: P,
    ) {
        let callback_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn callback_func<
            P: Fn(&Server, &ServerMessage, &str, &WebsocketConnection) + 'static,
        >(
            server: *mut ffi::SoupServer,
            msg: *mut ffi::SoupServerMessage,
            path: *const libc::c_char,
            connection: *mut ffi::SoupWebsocketConnection,
            user_data: glib::ffi::gpointer,
        ) {
            let server = from_glib_borrow(server);
            let msg: Borrowed<ServerMessage> = from_glib_borrow(msg);
            let path: Borrowed<glib::GString> = from_glib_borrow(path);
            let connection = from_glib_borrow(connection);
            let callback: &P = &*(user_data as *mut _);
            (*callback)(&server, &msg, path.as_str(), &connection);
        }
        let callback = Some(callback_func::<P> as _);
        unsafe extern "C" fn destroy_func<
            P: Fn(&Server, &ServerMessage, &str, &WebsocketConnection) + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<P> = Box_::from_raw(data as *mut _);
        }
        let destroy_call6 = Some(destroy_func::<P> as _);
        let super_callback0: Box_<P> = callback_data;
        unsafe {
            ffi::soup_server_add_websocket_handler(
                self.as_ref().to_glib_none().0,
                path.to_glib_none().0,
                origin.to_glib_none().0,
                protocols.to_glib_none().0,
                callback,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call6,
            );
        }
    }
}
