// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::WebsocketConnectionType;
use crate::WebsocketExtension;
use crate::WebsocketState;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "SoupWebsocketConnection")]
    pub struct WebsocketConnection(Object<ffi::SoupWebsocketConnection, ffi::SoupWebsocketConnectionClass>);

    match fn {
        type_ => || ffi::soup_websocket_connection_get_type(),
    }
}

impl WebsocketConnection {
    #[doc(alias = "soup_websocket_connection_new")]
    pub fn new(
        stream: &impl IsA<gio::IOStream>,
        uri: &glib::Uri,
        type_: WebsocketConnectionType,
        origin: Option<&str>,
        protocol: Option<&str>,
        extensions: &[WebsocketExtension],
    ) -> WebsocketConnection {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_websocket_connection_new(
                stream.as_ref().to_glib_none().0,
                uri.to_glib_none().0,
                type_.into_glib(),
                origin.to_glib_none().0,
                protocol.to_glib_none().0,
                extensions.to_glib_full(),
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_close")]
    pub fn close(&self, code: libc::c_ushort, data: Option<&str>) {
        unsafe {
            ffi::soup_websocket_connection_close(
                self.to_glib_none().0,
                code,
                data.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_websocket_connection_get_close_code")]
    #[doc(alias = "get_close_code")]
    pub fn close_code(&self) -> libc::c_ushort {
        unsafe { ffi::soup_websocket_connection_get_close_code(self.to_glib_none().0) }
    }

    #[doc(alias = "soup_websocket_connection_get_close_data")]
    #[doc(alias = "get_close_data")]
    pub fn close_data(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_close_data(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_get_connection_type")]
    #[doc(alias = "get_connection_type")]
    pub fn connection_type(&self) -> WebsocketConnectionType {
        unsafe {
            from_glib(ffi::soup_websocket_connection_get_connection_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_get_extensions")]
    #[doc(alias = "get_extensions")]
    pub fn extensions(&self) -> Vec<WebsocketExtension> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::soup_websocket_connection_get_extensions(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_get_io_stream")]
    #[doc(alias = "get_io_stream")]
    pub fn io_stream(&self) -> Option<gio::IOStream> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_io_stream(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_get_keepalive_interval")]
    #[doc(alias = "get_keepalive_interval")]
    pub fn keepalive_interval(&self) -> u32 {
        unsafe { ffi::soup_websocket_connection_get_keepalive_interval(self.to_glib_none().0) }
    }

    #[doc(alias = "soup_websocket_connection_get_max_incoming_payload_size")]
    #[doc(alias = "get_max_incoming_payload_size")]
    pub fn max_incoming_payload_size(&self) -> u64 {
        unsafe {
            ffi::soup_websocket_connection_get_max_incoming_payload_size(self.to_glib_none().0)
        }
    }

    #[doc(alias = "soup_websocket_connection_get_origin")]
    #[doc(alias = "get_origin")]
    pub fn origin(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_origin(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_get_protocol")]
    #[doc(alias = "get_protocol")]
    pub fn protocol(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_protocol(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_get_state")]
    #[doc(alias = "get_state")]
    pub fn state(&self) -> WebsocketState {
        unsafe {
            from_glib(ffi::soup_websocket_connection_get_state(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_get_uri")]
    #[doc(alias = "get_uri")]
    pub fn uri(&self) -> Option<glib::Uri> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_uri(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_websocket_connection_send_text")]
    pub fn send_text(&self, text: &str) {
        unsafe {
            ffi::soup_websocket_connection_send_text(self.to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_websocket_connection_set_keepalive_interval")]
    pub fn set_keepalive_interval(&self, interval: u32) {
        unsafe {
            ffi::soup_websocket_connection_set_keepalive_interval(self.to_glib_none().0, interval);
        }
    }

    #[doc(alias = "soup_websocket_connection_set_max_incoming_payload_size")]
    pub fn set_max_incoming_payload_size(&self, max_incoming_payload_size: u64) {
        unsafe {
            ffi::soup_websocket_connection_set_max_incoming_payload_size(
                self.to_glib_none().0,
                max_incoming_payload_size,
            );
        }
    }

    #[doc(alias = "closed")]
    pub fn connect_closed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn closed_trampoline<F: Fn(&WebsocketConnection) + 'static>(
            this: *mut ffi::SoupWebsocketConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"closed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    closed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "closing")]
    pub fn connect_closing<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn closing_trampoline<F: Fn(&WebsocketConnection) + 'static>(
            this: *mut ffi::SoupWebsocketConnection,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"closing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    closing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "error")]
    pub fn connect_error<F: Fn(&Self, &glib::Error) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn error_trampoline<
            F: Fn(&WebsocketConnection, &glib::Error) + 'static,
        >(
            this: *mut ffi::SoupWebsocketConnection,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(error))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"error\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "message")]
    pub fn connect_message<F: Fn(&Self, i32, &glib::Bytes) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn message_trampoline<
            F: Fn(&WebsocketConnection, i32, &glib::Bytes) + 'static,
        >(
            this: *mut ffi::SoupWebsocketConnection,
            type_: libc::c_int,
            message: *mut glib::ffi::GBytes,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), type_, &from_glib_borrow(message))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"message\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    message_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pong")]
    pub fn connect_pong<F: Fn(&Self, &glib::Bytes) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn pong_trampoline<
            F: Fn(&WebsocketConnection, &glib::Bytes) + 'static,
        >(
            this: *mut ffi::SoupWebsocketConnection,
            message: *mut glib::ffi::GBytes,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(message))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"pong\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    pong_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "keepalive-interval")]
    pub fn connect_keepalive_interval_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_keepalive_interval_trampoline<
            F: Fn(&WebsocketConnection) + 'static,
        >(
            this: *mut ffi::SoupWebsocketConnection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::keepalive-interval\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_keepalive_interval_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "max-incoming-payload-size")]
    pub fn connect_max_incoming_payload_size_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_incoming_payload_size_trampoline<
            F: Fn(&WebsocketConnection) + 'static,
        >(
            this: *mut ffi::SoupWebsocketConnection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-incoming-payload-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_incoming_payload_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "state")]
    pub fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_trampoline<F: Fn(&WebsocketConnection) + 'static>(
            this: *mut ffi::SoupWebsocketConnection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for WebsocketConnection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("WebsocketConnection")
    }
}
