// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Auth;
use crate::HTTPVersion;
use crate::MessageFlags;
use crate::MessageHeaders;
use crate::MessagePriority;
use crate::Multipart;
use crate::Status;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "SoupMessage")]
    pub struct Message(Object<ffi::SoupMessage, ffi::SoupMessageClass>);

    match fn {
        type_ => || ffi::soup_message_get_type(),
    }
}

impl Message {
    #[doc(alias = "soup_message_new")]
    pub fn new(method: &str, uri_string: &str) -> Option<Message> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_message_new(
                method.to_glib_none().0,
                uri_string.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_new_from_encoded_form")]
    #[doc(alias = "new_from_encoded_form")]
    pub fn from_encoded_form(
        method: &str,
        uri_string: &str,
        encoded_form: &str,
    ) -> Option<Message> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_message_new_from_encoded_form(
                method.to_glib_none().0,
                uri_string.to_glib_none().0,
                encoded_form.to_glib_full(),
            ))
        }
    }

    #[doc(alias = "soup_message_new_from_multipart")]
    #[doc(alias = "new_from_multipart")]
    pub fn from_multipart(uri_string: &str, multipart: &mut Multipart) -> Option<Message> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_message_new_from_multipart(
                uri_string.to_glib_none().0,
                multipart.to_glib_none_mut().0,
            ))
        }
    }

    #[doc(alias = "soup_message_new_from_uri")]
    #[doc(alias = "new_from_uri")]
    pub fn from_uri(method: &str, uri: &glib::Uri) -> Message {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_message_new_from_uri(
                method.to_glib_none().0,
                uri.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_new_options_ping")]
    pub fn new_options_ping(base_uri: &glib::Uri) -> Message {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_message_new_options_ping(
                base_uri.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_add_flags")]
    pub fn add_flags(&self, flags: MessageFlags) {
        unsafe {
            ffi::soup_message_add_flags(self.to_glib_none().0, flags.into_glib());
        }
    }

    //#[doc(alias = "soup_message_add_header_handler")]
    //pub fn add_header_handler<P: Fn() + 'static>(&self, signal: &str, header: &str, callback: P, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> u32 {
    //    unsafe { TODO: call ffi:soup_message_add_header_handler() }
    //}

    //#[doc(alias = "soup_message_add_status_code_handler")]
    //pub fn add_status_code_handler<P: Fn() + 'static>(&self, signal: &str, status_code: u32, callback: P, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> u32 {
    //    unsafe { TODO: call ffi:soup_message_add_status_code_handler() }
    //}

    #[doc(alias = "soup_message_disable_feature")]
    pub fn disable_feature(&self, feature_type: glib::types::Type) {
        unsafe {
            ffi::soup_message_disable_feature(self.to_glib_none().0, feature_type.into_glib());
        }
    }

    #[doc(alias = "soup_message_get_connection_id")]
    #[doc(alias = "get_connection_id")]
    pub fn connection_id(&self) -> u64 {
        unsafe { ffi::soup_message_get_connection_id(self.to_glib_none().0) }
    }

    #[doc(alias = "soup_message_get_first_party")]
    #[doc(alias = "get_first_party")]
    pub fn first_party(&self) -> Option<glib::Uri> {
        unsafe { from_glib_none(ffi::soup_message_get_first_party(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_flags")]
    #[doc(alias = "get_flags")]
    pub fn flags(&self) -> MessageFlags {
        unsafe { from_glib(ffi::soup_message_get_flags(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_http_version")]
    #[doc(alias = "get_http_version")]
    pub fn http_version(&self) -> HTTPVersion {
        unsafe { from_glib(ffi::soup_message_get_http_version(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_is_options_ping")]
    #[doc(alias = "get_is_options_ping")]
    pub fn is_options_ping(&self) -> bool {
        unsafe { from_glib(ffi::soup_message_get_is_options_ping(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_is_top_level_navigation")]
    #[doc(alias = "get_is_top_level_navigation")]
    pub fn is_top_level_navigation(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_message_get_is_top_level_navigation(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_get_method")]
    #[doc(alias = "get_method")]
    pub fn method(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::soup_message_get_method(self.to_glib_none().0)) }
    }

    //#[doc(alias = "soup_message_get_metrics")]
    //#[doc(alias = "get_metrics")]
    //pub fn metrics(&self) -> /*Ignored*/Option<MessageMetrics> {
    //    unsafe { TODO: call ffi:soup_message_get_metrics() }
    //}

    #[doc(alias = "soup_message_get_priority")]
    #[doc(alias = "get_priority")]
    pub fn priority(&self) -> MessagePriority {
        unsafe { from_glib(ffi::soup_message_get_priority(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_reason_phrase")]
    #[doc(alias = "get_reason_phrase")]
    pub fn reason_phrase(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::soup_message_get_reason_phrase(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_remote_address")]
    #[doc(alias = "get_remote_address")]
    pub fn remote_address(&self) -> Option<gio::SocketAddress> {
        unsafe { from_glib_none(ffi::soup_message_get_remote_address(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_request_headers")]
    #[doc(alias = "get_request_headers")]
    pub fn request_headers(&self) -> Option<MessageHeaders> {
        unsafe { from_glib_none(ffi::soup_message_get_request_headers(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_response_headers")]
    #[doc(alias = "get_response_headers")]
    pub fn response_headers(&self) -> Option<MessageHeaders> {
        unsafe {
            from_glib_none(ffi::soup_message_get_response_headers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_get_site_for_cookies")]
    #[doc(alias = "get_site_for_cookies")]
    pub fn site_for_cookies(&self) -> Option<glib::Uri> {
        unsafe {
            from_glib_none(ffi::soup_message_get_site_for_cookies(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_get_status")]
    #[doc(alias = "get_status")]
    pub fn status(&self) -> Status {
        unsafe { from_glib(ffi::soup_message_get_status(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_get_tls_ciphersuite_name")]
    #[doc(alias = "get_tls_ciphersuite_name")]
    pub fn tls_ciphersuite_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_message_get_tls_ciphersuite_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_get_tls_peer_certificate")]
    #[doc(alias = "get_tls_peer_certificate")]
    pub fn tls_peer_certificate(&self) -> Option<gio::TlsCertificate> {
        unsafe {
            from_glib_none(ffi::soup_message_get_tls_peer_certificate(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_get_tls_peer_certificate_errors")]
    #[doc(alias = "get_tls_peer_certificate_errors")]
    pub fn tls_peer_certificate_errors(&self) -> gio::TlsCertificateFlags {
        unsafe {
            from_glib(ffi::soup_message_get_tls_peer_certificate_errors(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_message_get_uri")]
    #[doc(alias = "get_uri")]
    pub fn uri(&self) -> Option<glib::Uri> {
        unsafe { from_glib_none(ffi::soup_message_get_uri(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_is_feature_disabled")]
    pub fn is_feature_disabled(&self, feature_type: glib::types::Type) -> bool {
        unsafe {
            from_glib(ffi::soup_message_is_feature_disabled(
                self.to_glib_none().0,
                feature_type.into_glib(),
            ))
        }
    }

    #[doc(alias = "soup_message_is_keepalive")]
    pub fn is_keepalive(&self) -> bool {
        unsafe { from_glib(ffi::soup_message_is_keepalive(self.to_glib_none().0)) }
    }

    #[doc(alias = "soup_message_query_flags")]
    pub fn query_flags(&self, flags: MessageFlags) -> bool {
        unsafe {
            from_glib(ffi::soup_message_query_flags(
                self.to_glib_none().0,
                flags.into_glib(),
            ))
        }
    }

    #[doc(alias = "soup_message_remove_flags")]
    pub fn remove_flags(&self, flags: MessageFlags) {
        unsafe {
            ffi::soup_message_remove_flags(self.to_glib_none().0, flags.into_glib());
        }
    }

    #[doc(alias = "soup_message_set_first_party")]
    pub fn set_first_party(&self, first_party: &glib::Uri) {
        unsafe {
            ffi::soup_message_set_first_party(self.to_glib_none().0, first_party.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_set_flags")]
    pub fn set_flags(&self, flags: MessageFlags) {
        unsafe {
            ffi::soup_message_set_flags(self.to_glib_none().0, flags.into_glib());
        }
    }

    #[doc(alias = "soup_message_set_is_options_ping")]
    pub fn set_is_options_ping(&self, is_options_ping: bool) {
        unsafe {
            ffi::soup_message_set_is_options_ping(
                self.to_glib_none().0,
                is_options_ping.into_glib(),
            );
        }
    }

    #[doc(alias = "soup_message_set_is_top_level_navigation")]
    pub fn set_is_top_level_navigation(&self, is_top_level_navigation: bool) {
        unsafe {
            ffi::soup_message_set_is_top_level_navigation(
                self.to_glib_none().0,
                is_top_level_navigation.into_glib(),
            );
        }
    }

    #[doc(alias = "soup_message_set_method")]
    pub fn set_method(&self, method: &str) {
        unsafe {
            ffi::soup_message_set_method(self.to_glib_none().0, method.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_set_priority")]
    pub fn set_priority(&self, priority: MessagePriority) {
        unsafe {
            ffi::soup_message_set_priority(self.to_glib_none().0, priority.into_glib());
        }
    }

    #[doc(alias = "soup_message_set_request_body")]
    pub fn set_request_body(
        &self,
        content_type: Option<&str>,
        stream: Option<&impl IsA<gio::InputStream>>,
        content_length: isize,
    ) {
        unsafe {
            ffi::soup_message_set_request_body(
                self.to_glib_none().0,
                content_type.to_glib_none().0,
                stream.map(|p| p.as_ref()).to_glib_none().0,
                content_length,
            );
        }
    }

    #[doc(alias = "soup_message_set_request_body_from_bytes")]
    pub fn set_request_body_from_bytes(
        &self,
        content_type: Option<&str>,
        bytes: Option<&glib::Bytes>,
    ) {
        unsafe {
            ffi::soup_message_set_request_body_from_bytes(
                self.to_glib_none().0,
                content_type.to_glib_none().0,
                bytes.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_message_set_site_for_cookies")]
    pub fn set_site_for_cookies(&self, site_for_cookies: Option<&glib::Uri>) {
        unsafe {
            ffi::soup_message_set_site_for_cookies(
                self.to_glib_none().0,
                site_for_cookies.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_message_set_tls_client_certificate")]
    pub fn set_tls_client_certificate(&self, certificate: Option<&impl IsA<gio::TlsCertificate>>) {
        unsafe {
            ffi::soup_message_set_tls_client_certificate(
                self.to_glib_none().0,
                certificate.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_message_set_uri")]
    pub fn set_uri(&self, uri: &glib::Uri) {
        unsafe {
            ffi::soup_message_set_uri(self.to_glib_none().0, uri.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_message_tls_client_certificate_password_request_complete")]
    pub fn tls_client_certificate_password_request_complete(&self) {
        unsafe {
            ffi::soup_message_tls_client_certificate_password_request_complete(
                self.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "status-code")]
    pub fn status_code(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.as_ptr() as *mut glib::gobject_ffi::GObject,
                b"status-code\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `status-code` getter")
        }
    }

    #[doc(alias = "accept-certificate")]
    pub fn connect_accept_certificate<
        F: Fn(&Self, &gio::TlsCertificate, gio::TlsCertificateFlags) -> bool + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn accept_certificate_trampoline<
            F: Fn(&Message, &gio::TlsCertificate, gio::TlsCertificateFlags) -> bool + 'static,
        >(
            this: *mut ffi::SoupMessage,
            tls_peer_certificate: *mut gio::ffi::GTlsCertificate,
            tls_peer_errors: gio::ffi::GTlsCertificateFlags,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(tls_peer_certificate),
                from_glib(tls_peer_errors),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"accept-certificate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    accept_certificate_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "authenticate")]
    pub fn connect_authenticate<F: Fn(&Self, &Auth, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn authenticate_trampoline<
            F: Fn(&Message, &Auth, bool) -> bool + 'static,
        >(
            this: *mut ffi::SoupMessage,
            auth: *mut ffi::SoupAuth,
            retrying: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(auth),
                from_glib(retrying),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"authenticate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    authenticate_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    //#[doc(alias = "content-sniffed")]
    //pub fn connect_content_sniffed<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Empty ctype params: *.HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }
    //}

    #[doc(alias = "finished")]
    pub fn connect_finished<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn finished_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"finished\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    finished_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "got-body")]
    pub fn connect_got_body<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_body_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"got-body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    got_body_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "got-headers")]
    pub fn connect_got_headers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_headers_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"got-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    got_headers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "got-informational")]
    pub fn connect_got_informational<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_informational_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"got-informational\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    got_informational_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "hsts-enforced")]
    pub fn connect_hsts_enforced<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn hsts_enforced_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"hsts-enforced\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    hsts_enforced_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "network-event")]
    pub fn connect_network_event<F: Fn(&Self, gio::SocketClientEvent, &gio::IOStream) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn network_event_trampoline<
            F: Fn(&Message, gio::SocketClientEvent, &gio::IOStream) + 'static,
        >(
            this: *mut ffi::SoupMessage,
            event: gio::ffi::GSocketClientEvent,
            connection: *mut gio::ffi::GIOStream,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                from_glib(event),
                &from_glib_borrow(connection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"network-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    network_event_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    //#[doc(alias = "request-certificate")]
    //pub fn connect_request_certificate<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Ignored tls_connection: Gio.TlsClientConnection
    //}

    //#[doc(alias = "request-certificate-password")]
    //pub fn connect_request_certificate_password<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Ignored tls_password: Gio.TlsPassword
    //}

    #[doc(alias = "restarted")]
    pub fn connect_restarted<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn restarted_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"restarted\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    restarted_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "starting")]
    pub fn connect_starting<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn starting_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"starting\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    starting_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrote-body")]
    pub fn connect_wrote_body<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_body_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"wrote-body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    wrote_body_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrote-body-data")]
    pub fn connect_wrote_body_data<F: Fn(&Self, u32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_body_data_trampoline<F: Fn(&Message, u32) + 'static>(
            this: *mut ffi::SoupMessage,
            chunk_size: libc::c_uint,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), chunk_size)
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"wrote-body-data\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    wrote_body_data_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "wrote-headers")]
    pub fn connect_wrote_headers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_headers_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"wrote-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    wrote_headers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "first-party")]
    pub fn connect_first_party_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_first_party_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::first-party\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_first_party_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "flags")]
    pub fn connect_flags_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_flags_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::flags\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_flags_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "http-version")]
    pub fn connect_http_version_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_http_version_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::http-version\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_http_version_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-options-ping")]
    pub fn connect_is_options_ping_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_options_ping_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-options-ping\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_options_ping_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-top-level-navigation")]
    pub fn connect_is_top_level_navigation_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_top_level_navigation_trampoline<
            F: Fn(&Message) + 'static,
        >(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-top-level-navigation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_top_level_navigation_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "method")]
    pub fn connect_method_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_method_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::method\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_method_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "priority")]
    pub fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_priority_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::priority\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_priority_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reason-phrase")]
    pub fn connect_reason_phrase_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reason_phrase_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reason-phrase\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reason_phrase_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "remote-address")]
    pub fn connect_remote_address_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_remote_address_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::remote-address\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_remote_address_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "request-headers")]
    pub fn connect_request_headers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_request_headers_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::request-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_request_headers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "response-headers")]
    pub fn connect_response_headers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_response_headers_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::response-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_response_headers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "site-for-cookies")]
    pub fn connect_site_for_cookies_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_site_for_cookies_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::site-for-cookies\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_site_for_cookies_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "status-code")]
    pub fn connect_status_code_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_status_code_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::status-code\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_status_code_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tls-ciphersuite-name")]
    pub fn connect_tls_ciphersuite_name_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_ciphersuite_name_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-ciphersuite-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tls_ciphersuite_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tls-peer-certificate")]
    pub fn connect_tls_peer_certificate_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_peer_certificate_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-peer-certificate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tls_peer_certificate_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tls-peer-certificate-errors")]
    pub fn connect_tls_peer_certificate_errors_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_peer_certificate_errors_trampoline<
            F: Fn(&Message) + 'static,
        >(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tls-peer-certificate-errors\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tls_peer_certificate_errors_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "uri")]
    pub fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_uri_trampoline<F: Fn(&Message) + 'static>(
            this: *mut ffi::SoupMessage,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_uri_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Message {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Message")
    }
}
