// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupCacheResponse")]
pub enum CacheResponse {
    #[doc(alias = "SOUP_CACHE_RESPONSE_FRESH")]
    Fresh,
    #[doc(alias = "SOUP_CACHE_RESPONSE_NEEDS_VALIDATION")]
    NeedsValidation,
    #[doc(alias = "SOUP_CACHE_RESPONSE_STALE")]
    Stale,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CacheResponse {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CacheResponse::{}",
            match *self {
                Self::Fresh => "Fresh",
                Self::NeedsValidation => "NeedsValidation",
                Self::Stale => "Stale",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CacheResponse {
    type GlibType = ffi::SoupCacheResponse;

    fn into_glib(self) -> ffi::SoupCacheResponse {
        match self {
            Self::Fresh => ffi::SOUP_CACHE_RESPONSE_FRESH,
            Self::NeedsValidation => ffi::SOUP_CACHE_RESPONSE_NEEDS_VALIDATION,
            Self::Stale => ffi::SOUP_CACHE_RESPONSE_STALE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupCacheResponse> for CacheResponse {
    unsafe fn from_glib(value: ffi::SoupCacheResponse) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_CACHE_RESPONSE_FRESH => Self::Fresh,
            ffi::SOUP_CACHE_RESPONSE_NEEDS_VALIDATION => Self::NeedsValidation,
            ffi::SOUP_CACHE_RESPONSE_STALE => Self::Stale,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CacheResponse {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_cache_response_get_type()) }
    }
}

impl glib::value::ValueType for CacheResponse {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CacheResponse {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CacheResponse {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupCacheType")]
pub enum CacheType {
    #[doc(alias = "SOUP_CACHE_SINGLE_USER")]
    SingleUser,
    #[doc(alias = "SOUP_CACHE_SHARED")]
    Shared,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CacheType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CacheType::{}",
            match *self {
                Self::SingleUser => "SingleUser",
                Self::Shared => "Shared",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CacheType {
    type GlibType = ffi::SoupCacheType;

    fn into_glib(self) -> ffi::SoupCacheType {
        match self {
            Self::SingleUser => ffi::SOUP_CACHE_SINGLE_USER,
            Self::Shared => ffi::SOUP_CACHE_SHARED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupCacheType> for CacheType {
    unsafe fn from_glib(value: ffi::SoupCacheType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_CACHE_SINGLE_USER => Self::SingleUser,
            ffi::SOUP_CACHE_SHARED => Self::Shared,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CacheType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_cache_type_get_type()) }
    }
}

impl glib::value::ValueType for CacheType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CacheType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CacheType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupCookieJarAcceptPolicy")]
pub enum CookieJarAcceptPolicy {
    #[doc(alias = "SOUP_COOKIE_JAR_ACCEPT_ALWAYS")]
    Always,
    #[doc(alias = "SOUP_COOKIE_JAR_ACCEPT_NEVER")]
    Never,
    #[doc(alias = "SOUP_COOKIE_JAR_ACCEPT_NO_THIRD_PARTY")]
    NoThirdParty,
    #[doc(alias = "SOUP_COOKIE_JAR_ACCEPT_GRANDFATHERED_THIRD_PARTY")]
    GrandfatheredThirdParty,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CookieJarAcceptPolicy {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CookieJarAcceptPolicy::{}",
            match *self {
                Self::Always => "Always",
                Self::Never => "Never",
                Self::NoThirdParty => "NoThirdParty",
                Self::GrandfatheredThirdParty => "GrandfatheredThirdParty",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for CookieJarAcceptPolicy {
    type GlibType = ffi::SoupCookieJarAcceptPolicy;

    fn into_glib(self) -> ffi::SoupCookieJarAcceptPolicy {
        match self {
            Self::Always => ffi::SOUP_COOKIE_JAR_ACCEPT_ALWAYS,
            Self::Never => ffi::SOUP_COOKIE_JAR_ACCEPT_NEVER,
            Self::NoThirdParty => ffi::SOUP_COOKIE_JAR_ACCEPT_NO_THIRD_PARTY,
            Self::GrandfatheredThirdParty => ffi::SOUP_COOKIE_JAR_ACCEPT_GRANDFATHERED_THIRD_PARTY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupCookieJarAcceptPolicy> for CookieJarAcceptPolicy {
    unsafe fn from_glib(value: ffi::SoupCookieJarAcceptPolicy) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_COOKIE_JAR_ACCEPT_ALWAYS => Self::Always,
            ffi::SOUP_COOKIE_JAR_ACCEPT_NEVER => Self::Never,
            ffi::SOUP_COOKIE_JAR_ACCEPT_NO_THIRD_PARTY => Self::NoThirdParty,
            ffi::SOUP_COOKIE_JAR_ACCEPT_GRANDFATHERED_THIRD_PARTY => Self::GrandfatheredThirdParty,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CookieJarAcceptPolicy {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_cookie_jar_accept_policy_get_type()) }
    }
}

impl glib::value::ValueType for CookieJarAcceptPolicy {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CookieJarAcceptPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CookieJarAcceptPolicy {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupDateFormat")]
pub enum DateFormat {
    #[doc(alias = "SOUP_DATE_HTTP")]
    Http,
    #[doc(alias = "SOUP_DATE_COOKIE")]
    Cookie,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DateFormat {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DateFormat::{}",
            match *self {
                Self::Http => "Http",
                Self::Cookie => "Cookie",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DateFormat {
    type GlibType = ffi::SoupDateFormat;

    fn into_glib(self) -> ffi::SoupDateFormat {
        match self {
            Self::Http => ffi::SOUP_DATE_HTTP,
            Self::Cookie => ffi::SOUP_DATE_COOKIE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupDateFormat> for DateFormat {
    unsafe fn from_glib(value: ffi::SoupDateFormat) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_DATE_HTTP => Self::Http,
            ffi::SOUP_DATE_COOKIE => Self::Cookie,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DateFormat {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_date_format_get_type()) }
    }
}

impl glib::value::ValueType for DateFormat {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DateFormat {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DateFormat {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupEncoding")]
pub enum Encoding {
    #[doc(alias = "SOUP_ENCODING_UNRECOGNIZED")]
    Unrecognized,
    #[doc(alias = "SOUP_ENCODING_NONE")]
    None,
    #[doc(alias = "SOUP_ENCODING_CONTENT_LENGTH")]
    ContentLength,
    #[doc(alias = "SOUP_ENCODING_EOF")]
    Eof,
    #[doc(alias = "SOUP_ENCODING_CHUNKED")]
    Chunked,
    #[doc(alias = "SOUP_ENCODING_BYTERANGES")]
    Byteranges,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Encoding {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Encoding::{}",
            match *self {
                Self::Unrecognized => "Unrecognized",
                Self::None => "None",
                Self::ContentLength => "ContentLength",
                Self::Eof => "Eof",
                Self::Chunked => "Chunked",
                Self::Byteranges => "Byteranges",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Encoding {
    type GlibType = ffi::SoupEncoding;

    fn into_glib(self) -> ffi::SoupEncoding {
        match self {
            Self::Unrecognized => ffi::SOUP_ENCODING_UNRECOGNIZED,
            Self::None => ffi::SOUP_ENCODING_NONE,
            Self::ContentLength => ffi::SOUP_ENCODING_CONTENT_LENGTH,
            Self::Eof => ffi::SOUP_ENCODING_EOF,
            Self::Chunked => ffi::SOUP_ENCODING_CHUNKED,
            Self::Byteranges => ffi::SOUP_ENCODING_BYTERANGES,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupEncoding> for Encoding {
    unsafe fn from_glib(value: ffi::SoupEncoding) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_ENCODING_UNRECOGNIZED => Self::Unrecognized,
            ffi::SOUP_ENCODING_NONE => Self::None,
            ffi::SOUP_ENCODING_CONTENT_LENGTH => Self::ContentLength,
            ffi::SOUP_ENCODING_EOF => Self::Eof,
            ffi::SOUP_ENCODING_CHUNKED => Self::Chunked,
            ffi::SOUP_ENCODING_BYTERANGES => Self::Byteranges,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Encoding {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_encoding_get_type()) }
    }
}

impl glib::value::ValueType for Encoding {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Encoding {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Encoding {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupHTTPVersion")]
pub enum HTTPVersion {
    #[doc(alias = "SOUP_HTTP_1_0")]
    Http10,
    #[doc(alias = "SOUP_HTTP_1_1")]
    Http11,
    #[doc(alias = "SOUP_HTTP_2_0")]
    Http20,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for HTTPVersion {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "HTTPVersion::{}",
            match *self {
                Self::Http10 => "Http10",
                Self::Http11 => "Http11",
                Self::Http20 => "Http20",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for HTTPVersion {
    type GlibType = ffi::SoupHTTPVersion;

    fn into_glib(self) -> ffi::SoupHTTPVersion {
        match self {
            Self::Http10 => ffi::SOUP_HTTP_1_0,
            Self::Http11 => ffi::SOUP_HTTP_1_1,
            Self::Http20 => ffi::SOUP_HTTP_2_0,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupHTTPVersion> for HTTPVersion {
    unsafe fn from_glib(value: ffi::SoupHTTPVersion) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_HTTP_1_0 => Self::Http10,
            ffi::SOUP_HTTP_1_1 => Self::Http11,
            ffi::SOUP_HTTP_2_0 => Self::Http20,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for HTTPVersion {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_http_version_get_type()) }
    }
}

impl glib::value::ValueType for HTTPVersion {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for HTTPVersion {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for HTTPVersion {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupLoggerLogLevel")]
pub enum LoggerLogLevel {
    #[doc(alias = "SOUP_LOGGER_LOG_NONE")]
    None,
    #[doc(alias = "SOUP_LOGGER_LOG_MINIMAL")]
    Minimal,
    #[doc(alias = "SOUP_LOGGER_LOG_HEADERS")]
    Headers,
    #[doc(alias = "SOUP_LOGGER_LOG_BODY")]
    Body,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for LoggerLogLevel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "LoggerLogLevel::{}",
            match *self {
                Self::None => "None",
                Self::Minimal => "Minimal",
                Self::Headers => "Headers",
                Self::Body => "Body",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for LoggerLogLevel {
    type GlibType = ffi::SoupLoggerLogLevel;

    fn into_glib(self) -> ffi::SoupLoggerLogLevel {
        match self {
            Self::None => ffi::SOUP_LOGGER_LOG_NONE,
            Self::Minimal => ffi::SOUP_LOGGER_LOG_MINIMAL,
            Self::Headers => ffi::SOUP_LOGGER_LOG_HEADERS,
            Self::Body => ffi::SOUP_LOGGER_LOG_BODY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupLoggerLogLevel> for LoggerLogLevel {
    unsafe fn from_glib(value: ffi::SoupLoggerLogLevel) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_LOGGER_LOG_NONE => Self::None,
            ffi::SOUP_LOGGER_LOG_MINIMAL => Self::Minimal,
            ffi::SOUP_LOGGER_LOG_HEADERS => Self::Headers,
            ffi::SOUP_LOGGER_LOG_BODY => Self::Body,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for LoggerLogLevel {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_logger_log_level_get_type()) }
    }
}

impl glib::value::ValueType for LoggerLogLevel {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for LoggerLogLevel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for LoggerLogLevel {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupMemoryUse")]
pub enum MemoryUse {
    #[doc(alias = "SOUP_MEMORY_STATIC")]
    Static,
    #[doc(alias = "SOUP_MEMORY_TAKE")]
    Take,
    #[doc(alias = "SOUP_MEMORY_COPY")]
    Copy,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MemoryUse {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MemoryUse::{}",
            match *self {
                Self::Static => "Static",
                Self::Take => "Take",
                Self::Copy => "Copy",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MemoryUse {
    type GlibType = ffi::SoupMemoryUse;

    fn into_glib(self) -> ffi::SoupMemoryUse {
        match self {
            Self::Static => ffi::SOUP_MEMORY_STATIC,
            Self::Take => ffi::SOUP_MEMORY_TAKE,
            Self::Copy => ffi::SOUP_MEMORY_COPY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupMemoryUse> for MemoryUse {
    unsafe fn from_glib(value: ffi::SoupMemoryUse) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_MEMORY_STATIC => Self::Static,
            ffi::SOUP_MEMORY_TAKE => Self::Take,
            ffi::SOUP_MEMORY_COPY => Self::Copy,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MemoryUse {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_memory_use_get_type()) }
    }
}

impl glib::value::ValueType for MemoryUse {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MemoryUse {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MemoryUse {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupMessageHeadersType")]
pub enum MessageHeadersType {
    #[doc(alias = "SOUP_MESSAGE_HEADERS_REQUEST")]
    Request,
    #[doc(alias = "SOUP_MESSAGE_HEADERS_RESPONSE")]
    Response,
    #[doc(alias = "SOUP_MESSAGE_HEADERS_MULTIPART")]
    Multipart,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MessageHeadersType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MessageHeadersType::{}",
            match *self {
                Self::Request => "Request",
                Self::Response => "Response",
                Self::Multipart => "Multipart",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MessageHeadersType {
    type GlibType = ffi::SoupMessageHeadersType;

    fn into_glib(self) -> ffi::SoupMessageHeadersType {
        match self {
            Self::Request => ffi::SOUP_MESSAGE_HEADERS_REQUEST,
            Self::Response => ffi::SOUP_MESSAGE_HEADERS_RESPONSE,
            Self::Multipart => ffi::SOUP_MESSAGE_HEADERS_MULTIPART,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupMessageHeadersType> for MessageHeadersType {
    unsafe fn from_glib(value: ffi::SoupMessageHeadersType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_MESSAGE_HEADERS_REQUEST => Self::Request,
            ffi::SOUP_MESSAGE_HEADERS_RESPONSE => Self::Response,
            ffi::SOUP_MESSAGE_HEADERS_MULTIPART => Self::Multipart,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MessageHeadersType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_message_headers_type_get_type()) }
    }
}

impl glib::value::ValueType for MessageHeadersType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MessageHeadersType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MessageHeadersType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupMessagePriority")]
pub enum MessagePriority {
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_VERY_LOW")]
    VeryLow,
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_LOW")]
    Low,
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_NORMAL")]
    Normal,
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_HIGH")]
    High,
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_VERY_HIGH")]
    VeryHigh,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MessagePriority {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MessagePriority::{}",
            match *self {
                Self::VeryLow => "VeryLow",
                Self::Low => "Low",
                Self::Normal => "Normal",
                Self::High => "High",
                Self::VeryHigh => "VeryHigh",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MessagePriority {
    type GlibType = ffi::SoupMessagePriority;

    fn into_glib(self) -> ffi::SoupMessagePriority {
        match self {
            Self::VeryLow => ffi::SOUP_MESSAGE_PRIORITY_VERY_LOW,
            Self::Low => ffi::SOUP_MESSAGE_PRIORITY_LOW,
            Self::Normal => ffi::SOUP_MESSAGE_PRIORITY_NORMAL,
            Self::High => ffi::SOUP_MESSAGE_PRIORITY_HIGH,
            Self::VeryHigh => ffi::SOUP_MESSAGE_PRIORITY_VERY_HIGH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupMessagePriority> for MessagePriority {
    unsafe fn from_glib(value: ffi::SoupMessagePriority) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_MESSAGE_PRIORITY_VERY_LOW => Self::VeryLow,
            ffi::SOUP_MESSAGE_PRIORITY_LOW => Self::Low,
            ffi::SOUP_MESSAGE_PRIORITY_NORMAL => Self::Normal,
            ffi::SOUP_MESSAGE_PRIORITY_HIGH => Self::High,
            ffi::SOUP_MESSAGE_PRIORITY_VERY_HIGH => Self::VeryHigh,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MessagePriority {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_message_priority_get_type()) }
    }
}

impl glib::value::ValueType for MessagePriority {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MessagePriority {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MessagePriority {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupSameSitePolicy")]
pub enum SameSitePolicy {
    #[doc(alias = "SOUP_SAME_SITE_POLICY_NONE")]
    None,
    #[doc(alias = "SOUP_SAME_SITE_POLICY_LAX")]
    Lax,
    #[doc(alias = "SOUP_SAME_SITE_POLICY_STRICT")]
    Strict,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SameSitePolicy {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SameSitePolicy::{}",
            match *self {
                Self::None => "None",
                Self::Lax => "Lax",
                Self::Strict => "Strict",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SameSitePolicy {
    type GlibType = ffi::SoupSameSitePolicy;

    fn into_glib(self) -> ffi::SoupSameSitePolicy {
        match self {
            Self::None => ffi::SOUP_SAME_SITE_POLICY_NONE,
            Self::Lax => ffi::SOUP_SAME_SITE_POLICY_LAX,
            Self::Strict => ffi::SOUP_SAME_SITE_POLICY_STRICT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupSameSitePolicy> for SameSitePolicy {
    unsafe fn from_glib(value: ffi::SoupSameSitePolicy) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_SAME_SITE_POLICY_NONE => Self::None,
            ffi::SOUP_SAME_SITE_POLICY_LAX => Self::Lax,
            ffi::SOUP_SAME_SITE_POLICY_STRICT => Self::Strict,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SameSitePolicy {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_same_site_policy_get_type()) }
    }
}

impl glib::value::ValueType for SameSitePolicy {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SameSitePolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SameSitePolicy {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupStatus")]
pub enum Status {
    #[doc(alias = "SOUP_STATUS_NONE")]
    None,
    #[doc(alias = "SOUP_STATUS_CONTINUE")]
    Continue,
    #[doc(alias = "SOUP_STATUS_SWITCHING_PROTOCOLS")]
    SwitchingProtocols,
    #[doc(alias = "SOUP_STATUS_PROCESSING")]
    Processing,
    #[doc(alias = "SOUP_STATUS_OK")]
    Ok,
    #[doc(alias = "SOUP_STATUS_CREATED")]
    Created,
    #[doc(alias = "SOUP_STATUS_ACCEPTED")]
    Accepted,
    #[doc(alias = "SOUP_STATUS_NON_AUTHORITATIVE")]
    NonAuthoritative,
    #[doc(alias = "SOUP_STATUS_NO_CONTENT")]
    NoContent,
    #[doc(alias = "SOUP_STATUS_RESET_CONTENT")]
    ResetContent,
    #[doc(alias = "SOUP_STATUS_PARTIAL_CONTENT")]
    PartialContent,
    #[doc(alias = "SOUP_STATUS_MULTI_STATUS")]
    MultiStatus,
    #[doc(alias = "SOUP_STATUS_MULTIPLE_CHOICES")]
    MultipleChoices,
    #[doc(alias = "SOUP_STATUS_MOVED_PERMANENTLY")]
    MovedPermanently,
    #[doc(alias = "SOUP_STATUS_FOUND")]
    Found,
    #[doc(alias = "SOUP_STATUS_SEE_OTHER")]
    SeeOther,
    #[doc(alias = "SOUP_STATUS_NOT_MODIFIED")]
    NotModified,
    #[doc(alias = "SOUP_STATUS_USE_PROXY")]
    UseProxy,
    #[doc(alias = "SOUP_STATUS_NOT_APPEARING_IN_THIS_PROTOCOL")]
    NotAppearingInThisProtocol,
    #[doc(alias = "SOUP_STATUS_TEMPORARY_REDIRECT")]
    TemporaryRedirect,
    #[doc(alias = "SOUP_STATUS_PERMANENT_REDIRECT")]
    PermanentRedirect,
    #[doc(alias = "SOUP_STATUS_BAD_REQUEST")]
    BadRequest,
    #[doc(alias = "SOUP_STATUS_UNAUTHORIZED")]
    Unauthorized,
    #[doc(alias = "SOUP_STATUS_PAYMENT_REQUIRED")]
    PaymentRequired,
    #[doc(alias = "SOUP_STATUS_FORBIDDEN")]
    Forbidden,
    #[doc(alias = "SOUP_STATUS_NOT_FOUND")]
    NotFound,
    #[doc(alias = "SOUP_STATUS_METHOD_NOT_ALLOWED")]
    MethodNotAllowed,
    #[doc(alias = "SOUP_STATUS_NOT_ACCEPTABLE")]
    NotAcceptable,
    #[doc(alias = "SOUP_STATUS_PROXY_AUTHENTICATION_REQUIRED")]
    ProxyAuthenticationRequired,
    #[doc(alias = "SOUP_STATUS_REQUEST_TIMEOUT")]
    RequestTimeout,
    #[doc(alias = "SOUP_STATUS_CONFLICT")]
    Conflict,
    #[doc(alias = "SOUP_STATUS_GONE")]
    Gone,
    #[doc(alias = "SOUP_STATUS_LENGTH_REQUIRED")]
    LengthRequired,
    #[doc(alias = "SOUP_STATUS_PRECONDITION_FAILED")]
    PreconditionFailed,
    #[doc(alias = "SOUP_STATUS_REQUEST_ENTITY_TOO_LARGE")]
    RequestEntityTooLarge,
    #[doc(alias = "SOUP_STATUS_REQUEST_URI_TOO_LONG")]
    RequestUriTooLong,
    #[doc(alias = "SOUP_STATUS_UNSUPPORTED_MEDIA_TYPE")]
    UnsupportedMediaType,
    #[doc(alias = "SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE")]
    RequestedRangeNotSatisfiable,
    #[doc(alias = "SOUP_STATUS_EXPECTATION_FAILED")]
    ExpectationFailed,
    #[doc(alias = "SOUP_STATUS_MISDIRECTED_REQUEST")]
    MisdirectedRequest,
    #[doc(alias = "SOUP_STATUS_UNPROCESSABLE_ENTITY")]
    UnprocessableEntity,
    #[doc(alias = "SOUP_STATUS_LOCKED")]
    Locked,
    #[doc(alias = "SOUP_STATUS_FAILED_DEPENDENCY")]
    FailedDependency,
    #[doc(alias = "SOUP_STATUS_INTERNAL_SERVER_ERROR")]
    InternalServerError,
    #[doc(alias = "SOUP_STATUS_NOT_IMPLEMENTED")]
    NotImplemented,
    #[doc(alias = "SOUP_STATUS_BAD_GATEWAY")]
    BadGateway,
    #[doc(alias = "SOUP_STATUS_SERVICE_UNAVAILABLE")]
    ServiceUnavailable,
    #[doc(alias = "SOUP_STATUS_GATEWAY_TIMEOUT")]
    GatewayTimeout,
    #[doc(alias = "SOUP_STATUS_HTTP_VERSION_NOT_SUPPORTED")]
    HttpVersionNotSupported,
    #[doc(alias = "SOUP_STATUS_INSUFFICIENT_STORAGE")]
    InsufficientStorage,
    #[doc(alias = "SOUP_STATUS_NOT_EXTENDED")]
    NotExtended,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Status {
    #[doc(alias = "soup_status_get_phrase")]
    #[doc(alias = "get_phrase")]
    pub fn phrase(status_code: u32) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::soup_status_get_phrase(status_code)) }
    }
}

impl fmt::Display for Status {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Status::{}",
            match *self {
                Self::None => "None",
                Self::Continue => "Continue",
                Self::SwitchingProtocols => "SwitchingProtocols",
                Self::Processing => "Processing",
                Self::Ok => "Ok",
                Self::Created => "Created",
                Self::Accepted => "Accepted",
                Self::NonAuthoritative => "NonAuthoritative",
                Self::NoContent => "NoContent",
                Self::ResetContent => "ResetContent",
                Self::PartialContent => "PartialContent",
                Self::MultiStatus => "MultiStatus",
                Self::MultipleChoices => "MultipleChoices",
                Self::MovedPermanently => "MovedPermanently",
                Self::Found => "Found",
                Self::SeeOther => "SeeOther",
                Self::NotModified => "NotModified",
                Self::UseProxy => "UseProxy",
                Self::NotAppearingInThisProtocol => "NotAppearingInThisProtocol",
                Self::TemporaryRedirect => "TemporaryRedirect",
                Self::PermanentRedirect => "PermanentRedirect",
                Self::BadRequest => "BadRequest",
                Self::Unauthorized => "Unauthorized",
                Self::PaymentRequired => "PaymentRequired",
                Self::Forbidden => "Forbidden",
                Self::NotFound => "NotFound",
                Self::MethodNotAllowed => "MethodNotAllowed",
                Self::NotAcceptable => "NotAcceptable",
                Self::ProxyAuthenticationRequired => "ProxyAuthenticationRequired",
                Self::RequestTimeout => "RequestTimeout",
                Self::Conflict => "Conflict",
                Self::Gone => "Gone",
                Self::LengthRequired => "LengthRequired",
                Self::PreconditionFailed => "PreconditionFailed",
                Self::RequestEntityTooLarge => "RequestEntityTooLarge",
                Self::RequestUriTooLong => "RequestUriTooLong",
                Self::UnsupportedMediaType => "UnsupportedMediaType",
                Self::RequestedRangeNotSatisfiable => "RequestedRangeNotSatisfiable",
                Self::ExpectationFailed => "ExpectationFailed",
                Self::MisdirectedRequest => "MisdirectedRequest",
                Self::UnprocessableEntity => "UnprocessableEntity",
                Self::Locked => "Locked",
                Self::FailedDependency => "FailedDependency",
                Self::InternalServerError => "InternalServerError",
                Self::NotImplemented => "NotImplemented",
                Self::BadGateway => "BadGateway",
                Self::ServiceUnavailable => "ServiceUnavailable",
                Self::GatewayTimeout => "GatewayTimeout",
                Self::HttpVersionNotSupported => "HttpVersionNotSupported",
                Self::InsufficientStorage => "InsufficientStorage",
                Self::NotExtended => "NotExtended",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Status {
    type GlibType = ffi::SoupStatus;

    fn into_glib(self) -> ffi::SoupStatus {
        match self {
            Self::None => ffi::SOUP_STATUS_NONE,
            Self::Continue => ffi::SOUP_STATUS_CONTINUE,
            Self::SwitchingProtocols => ffi::SOUP_STATUS_SWITCHING_PROTOCOLS,
            Self::Processing => ffi::SOUP_STATUS_PROCESSING,
            Self::Ok => ffi::SOUP_STATUS_OK,
            Self::Created => ffi::SOUP_STATUS_CREATED,
            Self::Accepted => ffi::SOUP_STATUS_ACCEPTED,
            Self::NonAuthoritative => ffi::SOUP_STATUS_NON_AUTHORITATIVE,
            Self::NoContent => ffi::SOUP_STATUS_NO_CONTENT,
            Self::ResetContent => ffi::SOUP_STATUS_RESET_CONTENT,
            Self::PartialContent => ffi::SOUP_STATUS_PARTIAL_CONTENT,
            Self::MultiStatus => ffi::SOUP_STATUS_MULTI_STATUS,
            Self::MultipleChoices => ffi::SOUP_STATUS_MULTIPLE_CHOICES,
            Self::MovedPermanently => ffi::SOUP_STATUS_MOVED_PERMANENTLY,
            Self::Found => ffi::SOUP_STATUS_FOUND,
            Self::SeeOther => ffi::SOUP_STATUS_SEE_OTHER,
            Self::NotModified => ffi::SOUP_STATUS_NOT_MODIFIED,
            Self::UseProxy => ffi::SOUP_STATUS_USE_PROXY,
            Self::NotAppearingInThisProtocol => ffi::SOUP_STATUS_NOT_APPEARING_IN_THIS_PROTOCOL,
            Self::TemporaryRedirect => ffi::SOUP_STATUS_TEMPORARY_REDIRECT,
            Self::PermanentRedirect => ffi::SOUP_STATUS_PERMANENT_REDIRECT,
            Self::BadRequest => ffi::SOUP_STATUS_BAD_REQUEST,
            Self::Unauthorized => ffi::SOUP_STATUS_UNAUTHORIZED,
            Self::PaymentRequired => ffi::SOUP_STATUS_PAYMENT_REQUIRED,
            Self::Forbidden => ffi::SOUP_STATUS_FORBIDDEN,
            Self::NotFound => ffi::SOUP_STATUS_NOT_FOUND,
            Self::MethodNotAllowed => ffi::SOUP_STATUS_METHOD_NOT_ALLOWED,
            Self::NotAcceptable => ffi::SOUP_STATUS_NOT_ACCEPTABLE,
            Self::ProxyAuthenticationRequired => ffi::SOUP_STATUS_PROXY_AUTHENTICATION_REQUIRED,
            Self::RequestTimeout => ffi::SOUP_STATUS_REQUEST_TIMEOUT,
            Self::Conflict => ffi::SOUP_STATUS_CONFLICT,
            Self::Gone => ffi::SOUP_STATUS_GONE,
            Self::LengthRequired => ffi::SOUP_STATUS_LENGTH_REQUIRED,
            Self::PreconditionFailed => ffi::SOUP_STATUS_PRECONDITION_FAILED,
            Self::RequestEntityTooLarge => ffi::SOUP_STATUS_REQUEST_ENTITY_TOO_LARGE,
            Self::RequestUriTooLong => ffi::SOUP_STATUS_REQUEST_URI_TOO_LONG,
            Self::UnsupportedMediaType => ffi::SOUP_STATUS_UNSUPPORTED_MEDIA_TYPE,
            Self::RequestedRangeNotSatisfiable => ffi::SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE,
            Self::ExpectationFailed => ffi::SOUP_STATUS_EXPECTATION_FAILED,
            Self::MisdirectedRequest => ffi::SOUP_STATUS_MISDIRECTED_REQUEST,
            Self::UnprocessableEntity => ffi::SOUP_STATUS_UNPROCESSABLE_ENTITY,
            Self::Locked => ffi::SOUP_STATUS_LOCKED,
            Self::FailedDependency => ffi::SOUP_STATUS_FAILED_DEPENDENCY,
            Self::InternalServerError => ffi::SOUP_STATUS_INTERNAL_SERVER_ERROR,
            Self::NotImplemented => ffi::SOUP_STATUS_NOT_IMPLEMENTED,
            Self::BadGateway => ffi::SOUP_STATUS_BAD_GATEWAY,
            Self::ServiceUnavailable => ffi::SOUP_STATUS_SERVICE_UNAVAILABLE,
            Self::GatewayTimeout => ffi::SOUP_STATUS_GATEWAY_TIMEOUT,
            Self::HttpVersionNotSupported => ffi::SOUP_STATUS_HTTP_VERSION_NOT_SUPPORTED,
            Self::InsufficientStorage => ffi::SOUP_STATUS_INSUFFICIENT_STORAGE,
            Self::NotExtended => ffi::SOUP_STATUS_NOT_EXTENDED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupStatus> for Status {
    unsafe fn from_glib(value: ffi::SoupStatus) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_STATUS_NONE => Self::None,
            ffi::SOUP_STATUS_CONTINUE => Self::Continue,
            ffi::SOUP_STATUS_SWITCHING_PROTOCOLS => Self::SwitchingProtocols,
            ffi::SOUP_STATUS_PROCESSING => Self::Processing,
            ffi::SOUP_STATUS_OK => Self::Ok,
            ffi::SOUP_STATUS_CREATED => Self::Created,
            ffi::SOUP_STATUS_ACCEPTED => Self::Accepted,
            ffi::SOUP_STATUS_NON_AUTHORITATIVE => Self::NonAuthoritative,
            ffi::SOUP_STATUS_NO_CONTENT => Self::NoContent,
            ffi::SOUP_STATUS_RESET_CONTENT => Self::ResetContent,
            ffi::SOUP_STATUS_PARTIAL_CONTENT => Self::PartialContent,
            ffi::SOUP_STATUS_MULTI_STATUS => Self::MultiStatus,
            ffi::SOUP_STATUS_MULTIPLE_CHOICES => Self::MultipleChoices,
            ffi::SOUP_STATUS_MOVED_PERMANENTLY => Self::MovedPermanently,
            ffi::SOUP_STATUS_FOUND => Self::Found,
            ffi::SOUP_STATUS_SEE_OTHER => Self::SeeOther,
            ffi::SOUP_STATUS_NOT_MODIFIED => Self::NotModified,
            ffi::SOUP_STATUS_USE_PROXY => Self::UseProxy,
            ffi::SOUP_STATUS_NOT_APPEARING_IN_THIS_PROTOCOL => Self::NotAppearingInThisProtocol,
            ffi::SOUP_STATUS_TEMPORARY_REDIRECT => Self::TemporaryRedirect,
            ffi::SOUP_STATUS_PERMANENT_REDIRECT => Self::PermanentRedirect,
            ffi::SOUP_STATUS_BAD_REQUEST => Self::BadRequest,
            ffi::SOUP_STATUS_UNAUTHORIZED => Self::Unauthorized,
            ffi::SOUP_STATUS_PAYMENT_REQUIRED => Self::PaymentRequired,
            ffi::SOUP_STATUS_FORBIDDEN => Self::Forbidden,
            ffi::SOUP_STATUS_NOT_FOUND => Self::NotFound,
            ffi::SOUP_STATUS_METHOD_NOT_ALLOWED => Self::MethodNotAllowed,
            ffi::SOUP_STATUS_NOT_ACCEPTABLE => Self::NotAcceptable,
            ffi::SOUP_STATUS_PROXY_AUTHENTICATION_REQUIRED => Self::ProxyAuthenticationRequired,
            ffi::SOUP_STATUS_REQUEST_TIMEOUT => Self::RequestTimeout,
            ffi::SOUP_STATUS_CONFLICT => Self::Conflict,
            ffi::SOUP_STATUS_GONE => Self::Gone,
            ffi::SOUP_STATUS_LENGTH_REQUIRED => Self::LengthRequired,
            ffi::SOUP_STATUS_PRECONDITION_FAILED => Self::PreconditionFailed,
            ffi::SOUP_STATUS_REQUEST_ENTITY_TOO_LARGE => Self::RequestEntityTooLarge,
            ffi::SOUP_STATUS_REQUEST_URI_TOO_LONG => Self::RequestUriTooLong,
            ffi::SOUP_STATUS_UNSUPPORTED_MEDIA_TYPE => Self::UnsupportedMediaType,
            ffi::SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE => Self::RequestedRangeNotSatisfiable,
            ffi::SOUP_STATUS_EXPECTATION_FAILED => Self::ExpectationFailed,
            ffi::SOUP_STATUS_MISDIRECTED_REQUEST => Self::MisdirectedRequest,
            ffi::SOUP_STATUS_UNPROCESSABLE_ENTITY => Self::UnprocessableEntity,
            ffi::SOUP_STATUS_LOCKED => Self::Locked,
            ffi::SOUP_STATUS_FAILED_DEPENDENCY => Self::FailedDependency,
            ffi::SOUP_STATUS_INTERNAL_SERVER_ERROR => Self::InternalServerError,
            ffi::SOUP_STATUS_NOT_IMPLEMENTED => Self::NotImplemented,
            ffi::SOUP_STATUS_BAD_GATEWAY => Self::BadGateway,
            ffi::SOUP_STATUS_SERVICE_UNAVAILABLE => Self::ServiceUnavailable,
            ffi::SOUP_STATUS_GATEWAY_TIMEOUT => Self::GatewayTimeout,
            ffi::SOUP_STATUS_HTTP_VERSION_NOT_SUPPORTED => Self::HttpVersionNotSupported,
            ffi::SOUP_STATUS_INSUFFICIENT_STORAGE => Self::InsufficientStorage,
            ffi::SOUP_STATUS_NOT_EXTENDED => Self::NotExtended,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Status {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_status_get_type()) }
    }
}

impl glib::value::ValueType for Status {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Status {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Status {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupTLDError")]
pub enum TLDError {
    #[doc(alias = "SOUP_TLD_ERROR_INVALID_HOSTNAME")]
    InvalidHostname,
    #[doc(alias = "SOUP_TLD_ERROR_IS_IP_ADDRESS")]
    IsIpAddress,
    #[doc(alias = "SOUP_TLD_ERROR_NOT_ENOUGH_DOMAINS")]
    NotEnoughDomains,
    #[doc(alias = "SOUP_TLD_ERROR_NO_BASE_DOMAIN")]
    NoBaseDomain,
    #[doc(alias = "SOUP_TLD_ERROR_NO_PSL_DATA")]
    NoPslData,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TLDError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TLDError::{}",
            match *self {
                Self::InvalidHostname => "InvalidHostname",
                Self::IsIpAddress => "IsIpAddress",
                Self::NotEnoughDomains => "NotEnoughDomains",
                Self::NoBaseDomain => "NoBaseDomain",
                Self::NoPslData => "NoPslData",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TLDError {
    type GlibType = ffi::SoupTLDError;

    fn into_glib(self) -> ffi::SoupTLDError {
        match self {
            Self::InvalidHostname => ffi::SOUP_TLD_ERROR_INVALID_HOSTNAME,
            Self::IsIpAddress => ffi::SOUP_TLD_ERROR_IS_IP_ADDRESS,
            Self::NotEnoughDomains => ffi::SOUP_TLD_ERROR_NOT_ENOUGH_DOMAINS,
            Self::NoBaseDomain => ffi::SOUP_TLD_ERROR_NO_BASE_DOMAIN,
            Self::NoPslData => ffi::SOUP_TLD_ERROR_NO_PSL_DATA,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupTLDError> for TLDError {
    unsafe fn from_glib(value: ffi::SoupTLDError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_TLD_ERROR_INVALID_HOSTNAME => Self::InvalidHostname,
            ffi::SOUP_TLD_ERROR_IS_IP_ADDRESS => Self::IsIpAddress,
            ffi::SOUP_TLD_ERROR_NOT_ENOUGH_DOMAINS => Self::NotEnoughDomains,
            ffi::SOUP_TLD_ERROR_NO_BASE_DOMAIN => Self::NoBaseDomain,
            ffi::SOUP_TLD_ERROR_NO_PSL_DATA => Self::NoPslData,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for TLDError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::soup_tld_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::SOUP_TLD_ERROR_INVALID_HOSTNAME => Some(Self::InvalidHostname),
            ffi::SOUP_TLD_ERROR_IS_IP_ADDRESS => Some(Self::IsIpAddress),
            ffi::SOUP_TLD_ERROR_NOT_ENOUGH_DOMAINS => Some(Self::NotEnoughDomains),
            ffi::SOUP_TLD_ERROR_NO_BASE_DOMAIN => Some(Self::NoBaseDomain),
            ffi::SOUP_TLD_ERROR_NO_PSL_DATA => Some(Self::NoPslData),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for TLDError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_tld_error_get_type()) }
    }
}

impl glib::value::ValueType for TLDError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TLDError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TLDError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketCloseCode")]
pub enum WebsocketCloseCode {
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_NORMAL")]
    Normal,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_GOING_AWAY")]
    GoingAway,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_PROTOCOL_ERROR")]
    ProtocolError,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_UNSUPPORTED_DATA")]
    UnsupportedData,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_NO_STATUS")]
    NoStatus,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_ABNORMAL")]
    Abnormal,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_BAD_DATA")]
    BadData,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_POLICY_VIOLATION")]
    PolicyViolation,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_TOO_BIG")]
    TooBig,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_NO_EXTENSION")]
    NoExtension,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_SERVER_ERROR")]
    ServerError,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_TLS_HANDSHAKE")]
    TlsHandshake,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WebsocketCloseCode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WebsocketCloseCode::{}",
            match *self {
                Self::Normal => "Normal",
                Self::GoingAway => "GoingAway",
                Self::ProtocolError => "ProtocolError",
                Self::UnsupportedData => "UnsupportedData",
                Self::NoStatus => "NoStatus",
                Self::Abnormal => "Abnormal",
                Self::BadData => "BadData",
                Self::PolicyViolation => "PolicyViolation",
                Self::TooBig => "TooBig",
                Self::NoExtension => "NoExtension",
                Self::ServerError => "ServerError",
                Self::TlsHandshake => "TlsHandshake",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WebsocketCloseCode {
    type GlibType = ffi::SoupWebsocketCloseCode;

    fn into_glib(self) -> ffi::SoupWebsocketCloseCode {
        match self {
            Self::Normal => ffi::SOUP_WEBSOCKET_CLOSE_NORMAL,
            Self::GoingAway => ffi::SOUP_WEBSOCKET_CLOSE_GOING_AWAY,
            Self::ProtocolError => ffi::SOUP_WEBSOCKET_CLOSE_PROTOCOL_ERROR,
            Self::UnsupportedData => ffi::SOUP_WEBSOCKET_CLOSE_UNSUPPORTED_DATA,
            Self::NoStatus => ffi::SOUP_WEBSOCKET_CLOSE_NO_STATUS,
            Self::Abnormal => ffi::SOUP_WEBSOCKET_CLOSE_ABNORMAL,
            Self::BadData => ffi::SOUP_WEBSOCKET_CLOSE_BAD_DATA,
            Self::PolicyViolation => ffi::SOUP_WEBSOCKET_CLOSE_POLICY_VIOLATION,
            Self::TooBig => ffi::SOUP_WEBSOCKET_CLOSE_TOO_BIG,
            Self::NoExtension => ffi::SOUP_WEBSOCKET_CLOSE_NO_EXTENSION,
            Self::ServerError => ffi::SOUP_WEBSOCKET_CLOSE_SERVER_ERROR,
            Self::TlsHandshake => ffi::SOUP_WEBSOCKET_CLOSE_TLS_HANDSHAKE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketCloseCode> for WebsocketCloseCode {
    unsafe fn from_glib(value: ffi::SoupWebsocketCloseCode) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_CLOSE_NORMAL => Self::Normal,
            ffi::SOUP_WEBSOCKET_CLOSE_GOING_AWAY => Self::GoingAway,
            ffi::SOUP_WEBSOCKET_CLOSE_PROTOCOL_ERROR => Self::ProtocolError,
            ffi::SOUP_WEBSOCKET_CLOSE_UNSUPPORTED_DATA => Self::UnsupportedData,
            ffi::SOUP_WEBSOCKET_CLOSE_NO_STATUS => Self::NoStatus,
            ffi::SOUP_WEBSOCKET_CLOSE_ABNORMAL => Self::Abnormal,
            ffi::SOUP_WEBSOCKET_CLOSE_BAD_DATA => Self::BadData,
            ffi::SOUP_WEBSOCKET_CLOSE_POLICY_VIOLATION => Self::PolicyViolation,
            ffi::SOUP_WEBSOCKET_CLOSE_TOO_BIG => Self::TooBig,
            ffi::SOUP_WEBSOCKET_CLOSE_NO_EXTENSION => Self::NoExtension,
            ffi::SOUP_WEBSOCKET_CLOSE_SERVER_ERROR => Self::ServerError,
            ffi::SOUP_WEBSOCKET_CLOSE_TLS_HANDSHAKE => Self::TlsHandshake,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WebsocketCloseCode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_close_code_get_type()) }
    }
}

impl glib::value::ValueType for WebsocketCloseCode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WebsocketCloseCode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WebsocketCloseCode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketConnectionType")]
pub enum WebsocketConnectionType {
    #[doc(alias = "SOUP_WEBSOCKET_CONNECTION_UNKNOWN")]
    Unknown,
    #[doc(alias = "SOUP_WEBSOCKET_CONNECTION_CLIENT")]
    Client,
    #[doc(alias = "SOUP_WEBSOCKET_CONNECTION_SERVER")]
    Server,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WebsocketConnectionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WebsocketConnectionType::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Client => "Client",
                Self::Server => "Server",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WebsocketConnectionType {
    type GlibType = ffi::SoupWebsocketConnectionType;

    fn into_glib(self) -> ffi::SoupWebsocketConnectionType {
        match self {
            Self::Unknown => ffi::SOUP_WEBSOCKET_CONNECTION_UNKNOWN,
            Self::Client => ffi::SOUP_WEBSOCKET_CONNECTION_CLIENT,
            Self::Server => ffi::SOUP_WEBSOCKET_CONNECTION_SERVER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketConnectionType> for WebsocketConnectionType {
    unsafe fn from_glib(value: ffi::SoupWebsocketConnectionType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_CONNECTION_UNKNOWN => Self::Unknown,
            ffi::SOUP_WEBSOCKET_CONNECTION_CLIENT => Self::Client,
            ffi::SOUP_WEBSOCKET_CONNECTION_SERVER => Self::Server,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WebsocketConnectionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_connection_type_get_type()) }
    }
}

impl glib::value::ValueType for WebsocketConnectionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WebsocketConnectionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WebsocketConnectionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketDataType")]
pub enum WebsocketDataType {
    #[doc(alias = "SOUP_WEBSOCKET_DATA_TEXT")]
    Text,
    #[doc(alias = "SOUP_WEBSOCKET_DATA_BINARY")]
    Binary,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WebsocketDataType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WebsocketDataType::{}",
            match *self {
                Self::Text => "Text",
                Self::Binary => "Binary",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WebsocketDataType {
    type GlibType = ffi::SoupWebsocketDataType;

    fn into_glib(self) -> ffi::SoupWebsocketDataType {
        match self {
            Self::Text => ffi::SOUP_WEBSOCKET_DATA_TEXT,
            Self::Binary => ffi::SOUP_WEBSOCKET_DATA_BINARY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketDataType> for WebsocketDataType {
    unsafe fn from_glib(value: ffi::SoupWebsocketDataType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_DATA_TEXT => Self::Text,
            ffi::SOUP_WEBSOCKET_DATA_BINARY => Self::Binary,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WebsocketDataType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_data_type_get_type()) }
    }
}

impl glib::value::ValueType for WebsocketDataType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WebsocketDataType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WebsocketDataType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketError")]
pub enum WebsocketError {
    #[doc(alias = "SOUP_WEBSOCKET_ERROR_FAILED")]
    Failed,
    #[doc(alias = "SOUP_WEBSOCKET_ERROR_NOT_WEBSOCKET")]
    NotWebsocket,
    #[doc(alias = "SOUP_WEBSOCKET_ERROR_BAD_HANDSHAKE")]
    BadHandshake,
    #[doc(alias = "SOUP_WEBSOCKET_ERROR_BAD_ORIGIN")]
    BadOrigin,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WebsocketError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WebsocketError::{}",
            match *self {
                Self::Failed => "Failed",
                Self::NotWebsocket => "NotWebsocket",
                Self::BadHandshake => "BadHandshake",
                Self::BadOrigin => "BadOrigin",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WebsocketError {
    type GlibType = ffi::SoupWebsocketError;

    fn into_glib(self) -> ffi::SoupWebsocketError {
        match self {
            Self::Failed => ffi::SOUP_WEBSOCKET_ERROR_FAILED,
            Self::NotWebsocket => ffi::SOUP_WEBSOCKET_ERROR_NOT_WEBSOCKET,
            Self::BadHandshake => ffi::SOUP_WEBSOCKET_ERROR_BAD_HANDSHAKE,
            Self::BadOrigin => ffi::SOUP_WEBSOCKET_ERROR_BAD_ORIGIN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketError> for WebsocketError {
    unsafe fn from_glib(value: ffi::SoupWebsocketError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_ERROR_FAILED => Self::Failed,
            ffi::SOUP_WEBSOCKET_ERROR_NOT_WEBSOCKET => Self::NotWebsocket,
            ffi::SOUP_WEBSOCKET_ERROR_BAD_HANDSHAKE => Self::BadHandshake,
            ffi::SOUP_WEBSOCKET_ERROR_BAD_ORIGIN => Self::BadOrigin,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for WebsocketError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::soup_websocket_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::SOUP_WEBSOCKET_ERROR_FAILED => Some(Self::Failed),
            ffi::SOUP_WEBSOCKET_ERROR_NOT_WEBSOCKET => Some(Self::NotWebsocket),
            ffi::SOUP_WEBSOCKET_ERROR_BAD_HANDSHAKE => Some(Self::BadHandshake),
            ffi::SOUP_WEBSOCKET_ERROR_BAD_ORIGIN => Some(Self::BadOrigin),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for WebsocketError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_error_get_type()) }
    }
}

impl glib::value::ValueType for WebsocketError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WebsocketError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WebsocketError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketState")]
pub enum WebsocketState {
    #[doc(alias = "SOUP_WEBSOCKET_STATE_OPEN")]
    Open,
    #[doc(alias = "SOUP_WEBSOCKET_STATE_CLOSING")]
    Closing,
    #[doc(alias = "SOUP_WEBSOCKET_STATE_CLOSED")]
    Closed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WebsocketState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WebsocketState::{}",
            match *self {
                Self::Open => "Open",
                Self::Closing => "Closing",
                Self::Closed => "Closed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for WebsocketState {
    type GlibType = ffi::SoupWebsocketState;

    fn into_glib(self) -> ffi::SoupWebsocketState {
        match self {
            Self::Open => ffi::SOUP_WEBSOCKET_STATE_OPEN,
            Self::Closing => ffi::SOUP_WEBSOCKET_STATE_CLOSING,
            Self::Closed => ffi::SOUP_WEBSOCKET_STATE_CLOSED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketState> for WebsocketState {
    unsafe fn from_glib(value: ffi::SoupWebsocketState) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_STATE_OPEN => Self::Open,
            ffi::SOUP_WEBSOCKET_STATE_CLOSING => Self::Closing,
            ffi::SOUP_WEBSOCKET_STATE_CLOSED => Self::Closed,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WebsocketState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_state_get_type()) }
    }
}

impl glib::value::ValueType for WebsocketState {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for WebsocketState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WebsocketState {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
