// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files)
// DO NOT EDIT

use crate::DateFormat;
use glib::translate::*;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct Date(Boxed<ffi::SoupDate>);

    match fn {
        copy => |ptr| ffi::soup_date_copy(mut_override(ptr)),
        free => |ptr| ffi::soup_date_free(ptr),
        type_ => || ffi::soup_date_get_type(),
    }
}

impl Date {
    #[doc(alias = "soup_date_new")]
    pub fn new(year: i32, month: i32, day: i32, hour: i32, minute: i32, second: i32) -> Date {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_date_new(year, month, day, hour, minute, second))
        }
    }

    #[doc(alias = "soup_date_new_from_now")]
    #[doc(alias = "new_from_now")]
    pub fn from_now(offset_seconds: i32) -> Date {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_date_new_from_now(offset_seconds))
        }
    }

    #[doc(alias = "soup_date_new_from_string")]
    #[doc(alias = "new_from_string")]
    pub fn from_string(date_string: &str) -> Option<Date> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_date_new_from_string(date_string.to_glib_none().0))
        }
    }

    #[doc(alias = "soup_date_new_from_time_t")]
    #[doc(alias = "new_from_time_t")]
    pub fn from_time_t(when: libc::c_long) -> Date {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_date_new_from_time_t(when))
        }
    }

    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_date_get_day")]
    #[doc(alias = "get_day")]
    pub fn day(&mut self) -> i32 {
        unsafe {
            ffi::soup_date_get_day(self.to_glib_none_mut().0)
        }
    }

    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_date_get_hour")]
    #[doc(alias = "get_hour")]
    pub fn hour(&mut self) -> i32 {
        unsafe {
            ffi::soup_date_get_hour(self.to_glib_none_mut().0)
        }
    }

    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_date_get_minute")]
    #[doc(alias = "get_minute")]
    pub fn minute(&mut self) -> i32 {
        unsafe {
            ffi::soup_date_get_minute(self.to_glib_none_mut().0)
        }
    }

    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_date_get_month")]
    #[doc(alias = "get_month")]
    pub fn month(&mut self) -> i32 {
        unsafe {
            ffi::soup_date_get_month(self.to_glib_none_mut().0)
        }
    }

    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_date_get_offset")]
    #[doc(alias = "get_offset")]
    pub fn offset(&mut self) -> i32 {
        unsafe {
            ffi::soup_date_get_offset(self.to_glib_none_mut().0)
        }
    }

    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_date_get_second")]
    #[doc(alias = "get_second")]
    pub fn second(&mut self) -> i32 {
        unsafe {
            ffi::soup_date_get_second(self.to_glib_none_mut().0)
        }
    }

    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_date_get_utc")]
    #[doc(alias = "get_utc")]
    pub fn utc(&mut self) -> i32 {
        unsafe {
            ffi::soup_date_get_utc(self.to_glib_none_mut().0)
        }
    }

    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_date_get_year")]
    #[doc(alias = "get_year")]
    pub fn year(&mut self) -> i32 {
        unsafe {
            ffi::soup_date_get_year(self.to_glib_none_mut().0)
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "soup_date_is_past")]
    pub fn is_past(&mut self) -> bool {
        unsafe {
            from_glib(ffi::soup_date_is_past(self.to_glib_none_mut().0))
        }
    }

    #[doc(alias = "soup_date_to_string")]
    pub fn to_string(&mut self, format: DateFormat) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::soup_date_to_string(self.to_glib_none_mut().0, format.into_glib()))
        }
    }

    #[doc(alias = "soup_date_to_time_t")]
    pub fn to_time_t(&mut self) -> libc::c_long {
        unsafe {
            ffi::soup_date_to_time_t(self.to_glib_none_mut().0)
        }
    }

    //#[cfg(any(feature = "v2_24", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    //#[doc(alias = "soup_date_to_timeval")]
    //pub fn to_timeval(&mut self, time: /*Ignored*/glib::TimeVal) {
    //    unsafe { TODO: call ffi:soup_date_to_timeval() }
    //}
}
