// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

#[cfg(any(feature = "v2_38", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
use crate::Address;
use crate::Auth;
use crate::Message;
#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
use crate::Request;
#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
use crate::RequestHTTP;
#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
use crate::SessionFeature;
use crate::Socket;
use crate::URI;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
use std::pin::Pin;
#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
use std::ptr;

glib::wrapper! {
    #[doc(alias = "SoupSession")]
    pub struct Session(Object<ffi::SoupSession, ffi::SoupSessionClass>);

    match fn {
        type_ => || ffi::soup_session_get_type(),
    }
}

impl Session {
    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_session_new")]
    pub fn new() -> Session {
        crate::assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_session_new())
        }
    }

    //#[cfg(any(feature = "v2_42", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    //#[doc(alias = "soup_session_new_with_options")]
    //#[doc(alias = "new_with_options")]
    //pub fn with_options(optname1: &str, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> Session {
    //    unsafe { TODO: call ffi:soup_session_new_with_options() }
    //}
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
impl Default for Session {
                     fn default() -> Self {
                         Self::new()
                     }
                 }

pub const NONE_SESSION: Option<&Session> = None;

pub trait SessionExt: 'static {
    #[doc(alias = "soup_session_abort")]
    fn abort(&self);

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "soup_session_add_feature")]
    fn add_feature(&self, feature: &impl IsA<SessionFeature>);

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "soup_session_add_feature_by_type")]
    fn add_feature_by_type(&self, feature_type: glib::types::Type);

    #[doc(alias = "soup_session_cancel_message")]
    fn cancel_message(&self, msg: &impl IsA<Message>, status_code: u32);

    //#[cfg(any(feature = "v2_62", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_62")))]
    //#[doc(alias = "soup_session_connect_async")]
    //fn connect_async<P: FnOnce(Result<gio::IOStream, glib::Error>) + Send + 'static, Q: FnOnce(Result<gio::IOStream, glib::Error>) + Send + 'static>(&self, uri: &mut URI, cancellable: Option<&impl IsA<gio::Cancellable>>, progress_callback: P, callback: Q);

    //
    //#[cfg(any(feature = "v2_62", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_62")))]
    //fn connect_async_future<P: FnOnce(Result<gio::IOStream, glib::Error>) + Send + 'static>(&self, uri: &mut URI, progress_callback: P) -> Pin<Box_<dyn std::future::Future<Output = Result<gio::IOStream, glib::Error>> + 'static>>;

    #[doc(alias = "soup_session_get_async_context")]
    #[doc(alias = "get_async_context")]
    fn async_context(&self) -> Option<glib::MainContext>;

    #[cfg(any(feature = "v2_26", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_26")))]
    #[doc(alias = "soup_session_get_feature")]
    #[doc(alias = "get_feature")]
    fn feature(&self, feature_type: glib::types::Type) -> Option<SessionFeature>;

    #[cfg(any(feature = "v2_28", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
    #[doc(alias = "soup_session_get_feature_for_message")]
    #[doc(alias = "get_feature_for_message")]
    fn feature_for_message(&self, feature_type: glib::types::Type, msg: &impl IsA<Message>) -> Option<SessionFeature>;

    #[cfg(any(feature = "v2_26", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_26")))]
    #[doc(alias = "soup_session_get_features")]
    #[doc(alias = "get_features")]
    fn features(&self, feature_type: glib::types::Type) -> Vec<SessionFeature>;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_session_has_feature")]
    fn has_feature(&self, feature_type: glib::types::Type) -> bool;

    #[doc(alias = "soup_session_pause_message")]
    fn pause_message(&self, msg: &impl IsA<Message>);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "soup_session_prefetch_dns")]
    fn prefetch_dns(&self, hostname: &str, cancellable: Option<&impl IsA<gio::Cancellable>>, callback: Option<Box_<dyn FnOnce(&Address, u32) + 'static>>);

    #[cfg_attr(feature = "v2_38", deprecated = "Since 2.38")]
    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "soup_session_prepare_for_uri")]
    fn prepare_for_uri(&self, uri: &mut URI);

    #[doc(alias = "soup_session_queue_message")]
    fn queue_message(&self, msg: &impl IsA<Message>, callback: Option<Box_<dyn FnOnce(&Session, &Message) + 'static>>);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "soup_session_redirect_message")]
    fn redirect_message(&self, msg: &impl IsA<Message>) -> bool;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "soup_session_remove_feature")]
    fn remove_feature(&self, feature: &impl IsA<SessionFeature>);

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "soup_session_remove_feature_by_type")]
    fn remove_feature_by_type(&self, feature_type: glib::types::Type);

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_session_request")]
    fn request(&self, uri_string: &str) -> Result<Request, glib::Error>;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_session_request_http")]
    fn request_http(&self, method: &str, uri_string: &str) -> Result<RequestHTTP, glib::Error>;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_session_request_http_uri")]
    fn request_http_uri(&self, method: &str, uri: &mut URI) -> Result<RequestHTTP, glib::Error>;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_session_request_uri")]
    fn request_uri(&self, uri: &mut URI) -> Result<Request, glib::Error>;

    #[doc(alias = "soup_session_requeue_message")]
    fn requeue_message(&self, msg: &impl IsA<Message>);

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_session_send")]
    fn send(&self, msg: &impl IsA<Message>, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<gio::InputStream, glib::Error>;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_session_send_async")]
    fn send_async<P: FnOnce(Result<gio::InputStream, glib::Error>) + Send + 'static>(&self, msg: &impl IsA<Message>, cancellable: Option<&impl IsA<gio::Cancellable>>, callback: P);

    
    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn send_async_future(&self, msg: &(impl IsA<Message> + Clone + 'static)) -> Pin<Box_<dyn std::future::Future<Output = Result<gio::InputStream, glib::Error>> + 'static>>;

    #[doc(alias = "soup_session_send_message")]
    fn send_message(&self, msg: &impl IsA<Message>) -> u32;

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    #[doc(alias = "soup_session_steal_connection")]
    fn steal_connection(&self, msg: &impl IsA<Message>) -> Option<gio::IOStream>;

    #[doc(alias = "soup_session_unpause_message")]
    fn unpause_message(&self, msg: &impl IsA<Message>);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "soup_session_would_redirect")]
    fn would_redirect(&self, msg: &impl IsA<Message>) -> bool;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "accept-language")]
    fn accept_language(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "accept-language")]
    fn set_accept_language(&self, accept_language: Option<&str>);

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "accept-language-auto")]
    fn accepts_language_auto(&self) -> bool;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "accept-language-auto")]
    fn set_accept_language_auto(&self, accept_language_auto: bool);

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "add-feature")]
    fn set_add_feature<P: IsA<SessionFeature>>(&self, add_feature: Option<&P>);

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "add-feature-by-type")]
    fn set_add_feature_by_type(&self, add_feature_by_type: glib::types::Type);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "http-aliases")]
    fn http_aliases(&self) -> Vec<glib::GString>;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "http-aliases")]
    fn set_http_aliases(&self, http_aliases: &[&str]);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "https-aliases")]
    fn https_aliases(&self) -> Vec<glib::GString>;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "https-aliases")]
    fn set_https_aliases(&self, https_aliases: &[&str]);

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "idle-timeout")]
    fn idle_timeout(&self) -> u32;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "idle-timeout")]
    fn set_idle_timeout(&self, idle_timeout: u32);

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "local-address")]
    fn local_address(&self) -> Option<Address>;

    #[doc(alias = "max-conns")]
    fn max_conns(&self) -> i32;

    #[doc(alias = "max-conns")]
    fn set_max_conns(&self, max_conns: i32);

    #[doc(alias = "max-conns-per-host")]
    fn max_conns_per_host(&self) -> i32;

    #[doc(alias = "max-conns-per-host")]
    fn set_max_conns_per_host(&self, max_conns_per_host: i32);

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "proxy-resolver")]
    fn proxy_resolver(&self) -> Option<gio::ProxyResolver>;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "proxy-resolver")]
    fn set_proxy_resolver<P: IsA<gio::ProxyResolver>>(&self, proxy_resolver: Option<&P>);

    #[cfg_attr(feature = "v2_70", deprecated = "Since 2.70")]
    #[doc(alias = "proxy-uri")]
    fn proxy_uri(&self) -> Option<URI>;

    #[cfg_attr(feature = "v2_70", deprecated = "Since 2.70")]
    #[doc(alias = "proxy-uri")]
    fn set_proxy_uri(&self, proxy_uri: Option<&URI>);

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "remove-feature-by-type")]
    fn set_remove_feature_by_type(&self, remove_feature_by_type: glib::types::Type);

    #[doc(alias = "ssl-ca-file")]
    fn ssl_ca_file(&self) -> Option<glib::GString>;

    #[doc(alias = "ssl-ca-file")]
    fn set_ssl_ca_file(&self, ssl_ca_file: Option<&str>);

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "ssl-strict")]
    fn is_ssl_strict(&self) -> bool;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "ssl-strict")]
    fn set_ssl_strict(&self, ssl_strict: bool);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "ssl-use-system-ca-file")]
    fn is_ssl_use_system_ca_file(&self) -> bool;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "ssl-use-system-ca-file")]
    fn set_ssl_use_system_ca_file(&self, ssl_use_system_ca_file: bool);

    fn timeout(&self) -> u32;

    fn set_timeout(&self, timeout: u32);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "tls-database")]
    fn tls_database(&self) -> Option<gio::TlsDatabase>;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "tls-database")]
    fn set_tls_database<P: IsA<gio::TlsDatabase>>(&self, tls_database: Option<&P>);

    #[cfg(any(feature = "v2_48", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_48")))]
    #[doc(alias = "tls-interaction")]
    fn tls_interaction(&self) -> Option<gio::TlsInteraction>;

    #[cfg(any(feature = "v2_48", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_48")))]
    #[doc(alias = "tls-interaction")]
    fn set_tls_interaction<P: IsA<gio::TlsInteraction>>(&self, tls_interaction: Option<&P>);

    #[doc(alias = "use-ntlm")]
    fn uses_ntlm(&self) -> bool;

    #[doc(alias = "use-ntlm")]
    fn set_use_ntlm(&self, use_ntlm: bool);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "use-thread-context")]
    fn uses_thread_context(&self) -> bool;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "use-thread-context")]
    fn set_use_thread_context(&self, use_thread_context: bool);

    #[doc(alias = "user-agent")]
    fn user_agent(&self) -> Option<glib::GString>;

    #[doc(alias = "user-agent")]
    fn set_user_agent(&self, user_agent: Option<&str>);

    #[doc(alias = "authenticate")]
    fn connect_authenticate<F: Fn(&Self, &Message, &Auth, bool) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "connection-created")]
    fn connect_connection_created<F: Fn(&Self, &glib::Object) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "request-queued")]
    fn connect_request_queued<F: Fn(&Self, &Message) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v2_50", deprecated = "Since 2.50")]
    #[doc(alias = "request-started")]
    fn connect_request_started<F: Fn(&Self, &Message, &Socket) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "request-unqueued")]
    fn connect_request_unqueued<F: Fn(&Self, &Message) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "tunneling")]
    fn connect_tunneling<F: Fn(&Self, &glib::Object) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "accept-language")]
    fn connect_accept_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "accept-language-auto")]
    fn connect_accept_language_auto_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "add-feature")]
    fn connect_add_feature_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "add-feature-by-type")]
    fn connect_add_feature_by_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "http-aliases")]
    fn connect_http_aliases_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "https-aliases")]
    fn connect_https_aliases_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "idle-timeout")]
    fn connect_idle_timeout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-conns")]
    fn connect_max_conns_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-conns-per-host")]
    fn connect_max_conns_per_host_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "proxy-resolver")]
    fn connect_proxy_resolver_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg_attr(feature = "v2_70", deprecated = "Since 2.70")]
    #[doc(alias = "proxy-uri")]
    fn connect_proxy_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "remove-feature-by-type")]
    fn connect_remove_feature_by_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "ssl-ca-file")]
    fn connect_ssl_ca_file_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "ssl-strict")]
    fn connect_ssl_strict_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "ssl-use-system-ca-file")]
    fn connect_ssl_use_system_ca_file_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "timeout")]
    fn connect_timeout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "tls-database")]
    fn connect_tls_database_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_48", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_48")))]
    #[doc(alias = "tls-interaction")]
    fn connect_tls_interaction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "use-ntlm")]
    fn connect_use_ntlm_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "use-thread-context")]
    fn connect_use_thread_context_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "user-agent")]
    fn connect_user_agent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Session>> SessionExt for O {
    fn abort(&self) {
        unsafe {
            ffi::soup_session_abort(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn add_feature(&self, feature: &impl IsA<SessionFeature>) {
        unsafe {
            ffi::soup_session_add_feature(self.as_ref().to_glib_none().0, feature.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn add_feature_by_type(&self, feature_type: glib::types::Type) {
        unsafe {
            ffi::soup_session_add_feature_by_type(self.as_ref().to_glib_none().0, feature_type.into_glib());
        }
    }

    fn cancel_message(&self, msg: &impl IsA<Message>, status_code: u32) {
        unsafe {
            ffi::soup_session_cancel_message(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0, status_code);
        }
    }

    //#[cfg(any(feature = "v2_62", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_62")))]
    //fn connect_async<P: FnOnce(Result<gio::IOStream, glib::Error>) + Send + 'static, Q: FnOnce(Result<gio::IOStream, glib::Error>) + Send + 'static>(&self, uri: &mut URI, cancellable: Option<&impl IsA<gio::Cancellable>>, progress_callback: P, callback: Q) {
    //    unsafe { TODO: call ffi:soup_session_connect_async() }
    //}

    //
    //#[cfg(any(feature = "v2_62", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_62")))]
    //fn connect_async_future<P: FnOnce(Result<gio::IOStream, glib::Error>) + Send + 'static>(&self, uri: &mut URI, progress_callback: P) -> Pin<Box_<dyn std::future::Future<Output = Result<gio::IOStream, glib::Error>> + 'static>> {

        //let uri = uri.clone();
        //let progress_callback = progress_callback.map(ToOwned::to_owned);
        //Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
        //    obj.connect_async(
        //        &uri,
        //        Some(cancellable),
        //        progress_callback.as_ref().map(::std::borrow::Borrow::borrow),
        //        move |res| {
        //            send.resolve(res);
        //        },
        //    );
        //}))
    //}

    fn async_context(&self) -> Option<glib::MainContext> {
        unsafe {
            from_glib_none(ffi::soup_session_get_async_context(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_26", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_26")))]
    fn feature(&self, feature_type: glib::types::Type) -> Option<SessionFeature> {
        unsafe {
            from_glib_none(ffi::soup_session_get_feature(self.as_ref().to_glib_none().0, feature_type.into_glib()))
        }
    }

    #[cfg(any(feature = "v2_28", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
    fn feature_for_message(&self, feature_type: glib::types::Type, msg: &impl IsA<Message>) -> Option<SessionFeature> {
        unsafe {
            from_glib_none(ffi::soup_session_get_feature_for_message(self.as_ref().to_glib_none().0, feature_type.into_glib(), msg.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_26", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_26")))]
    fn features(&self, feature_type: glib::types::Type) -> Vec<SessionFeature> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::soup_session_get_features(self.as_ref().to_glib_none().0, feature_type.into_glib()))
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn has_feature(&self, feature_type: glib::types::Type) -> bool {
        unsafe {
            from_glib(ffi::soup_session_has_feature(self.as_ref().to_glib_none().0, feature_type.into_glib()))
        }
    }

    fn pause_message(&self, msg: &impl IsA<Message>) {
        unsafe {
            ffi::soup_session_pause_message(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn prefetch_dns(&self, hostname: &str, cancellable: Option<&impl IsA<gio::Cancellable>>, callback: Option<Box_<dyn FnOnce(&Address, u32) + 'static>>) {
        let callback_data: Box_<Option<Box_<dyn FnOnce(&Address, u32) + 'static>>> = Box_::new(callback);
        unsafe extern "C" fn callback_func(addr: *mut ffi::SoupAddress, status: libc::c_uint, user_data: glib::ffi::gpointer) {
            let addr = from_glib_borrow(addr);
            let callback: Box_<Option<Box_<dyn FnOnce(&Address, u32) + 'static>>> = Box_::from_raw(user_data as *mut _);
            let callback = (*callback).expect("cannot get closure...");
            callback(&addr, status)
        }
        let callback = if callback_data.is_some() { Some(callback_func as _) } else { None };
        let super_callback0: Box_<Option<Box_<dyn FnOnce(&Address, u32) + 'static>>> = callback_data;
        unsafe {
            ffi::soup_session_prefetch_dns(self.as_ref().to_glib_none().0, hostname.to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, callback, Box_::into_raw(super_callback0) as *mut _);
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn prepare_for_uri(&self, uri: &mut URI) {
        unsafe {
            ffi::soup_session_prepare_for_uri(self.as_ref().to_glib_none().0, uri.to_glib_none_mut().0);
        }
    }

    fn queue_message(&self, msg: &impl IsA<Message>, callback: Option<Box_<dyn FnOnce(&Session, &Message) + 'static>>) {
        let callback_data: Box_<Option<Box_<dyn FnOnce(&Session, &Message) + 'static>>> = Box_::new(callback);
        unsafe extern "C" fn callback_func(session: *mut ffi::SoupSession, msg: *mut ffi::SoupMessage, user_data: glib::ffi::gpointer) {
            let session = from_glib_borrow(session);
            let msg = from_glib_borrow(msg);
            let callback: Box_<Option<Box_<dyn FnOnce(&Session, &Message) + 'static>>> = Box_::from_raw(user_data as *mut _);
            let callback = (*callback).expect("cannot get closure...");
            callback(&session, &msg)
        }
        let callback = if callback_data.is_some() { Some(callback_func as _) } else { None };
        let super_callback0: Box_<Option<Box_<dyn FnOnce(&Session, &Message) + 'static>>> = callback_data;
        unsafe {
            ffi::soup_session_queue_message(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_full(), callback, Box_::into_raw(super_callback0) as *mut _);
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn redirect_message(&self, msg: &impl IsA<Message>) -> bool {
        unsafe {
            from_glib(ffi::soup_session_redirect_message(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn remove_feature(&self, feature: &impl IsA<SessionFeature>) {
        unsafe {
            ffi::soup_session_remove_feature(self.as_ref().to_glib_none().0, feature.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn remove_feature_by_type(&self, feature_type: glib::types::Type) {
        unsafe {
            ffi::soup_session_remove_feature_by_type(self.as_ref().to_glib_none().0, feature_type.into_glib());
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn request(&self, uri_string: &str) -> Result<Request, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::soup_session_request(self.as_ref().to_glib_none().0, uri_string.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn request_http(&self, method: &str, uri_string: &str) -> Result<RequestHTTP, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::soup_session_request_http(self.as_ref().to_glib_none().0, method.to_glib_none().0, uri_string.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn request_http_uri(&self, method: &str, uri: &mut URI) -> Result<RequestHTTP, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::soup_session_request_http_uri(self.as_ref().to_glib_none().0, method.to_glib_none().0, uri.to_glib_none_mut().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn request_uri(&self, uri: &mut URI) -> Result<Request, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::soup_session_request_uri(self.as_ref().to_glib_none().0, uri.to_glib_none_mut().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn requeue_message(&self, msg: &impl IsA<Message>) {
        unsafe {
            ffi::soup_session_requeue_message(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn send(&self, msg: &impl IsA<Message>, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<gio::InputStream, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::soup_session_send(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn send_async<P: FnOnce(Result<gio::InputStream, glib::Error>) + Send + 'static>(&self, msg: &impl IsA<Message>, cancellable: Option<&impl IsA<gio::Cancellable>>, callback: P) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn send_async_trampoline<P: FnOnce(Result<gio::InputStream, glib::Error>) + Send + 'static>(_source_object: *mut glib::gobject_ffi::GObject, res: *mut gio::ffi::GAsyncResult, user_data: glib::ffi::gpointer) {
            let mut error = ptr::null_mut();
            let ret = ffi::soup_session_send_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = send_async_trampoline::<P>;
        unsafe {
            ffi::soup_session_send_async(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0, cancellable.map(|p| p.as_ref()).to_glib_none().0, Some(callback), Box_::into_raw(user_data) as *mut _);
        }
    }

    
    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn send_async_future(&self, msg: &(impl IsA<Message> + Clone + 'static)) -> Pin<Box_<dyn std::future::Future<Output = Result<gio::InputStream, glib::Error>> + 'static>> {

        let msg = msg.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.send_async(
                &msg,
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    fn send_message(&self, msg: &impl IsA<Message>) -> u32 {
        unsafe {
            ffi::soup_session_send_message(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    fn steal_connection(&self, msg: &impl IsA<Message>) -> Option<gio::IOStream> {
        unsafe {
            from_glib_full(ffi::soup_session_steal_connection(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0))
        }
    }

    fn unpause_message(&self, msg: &impl IsA<Message>) {
        unsafe {
            ffi::soup_session_unpause_message(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn would_redirect(&self, msg: &impl IsA<Message>) -> bool {
        unsafe {
            from_glib(ffi::soup_session_would_redirect(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn accept_language(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"accept-language\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `accept-language` getter")
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn set_accept_language(&self, accept_language: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"accept-language\0".as_ptr() as *const _, accept_language.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn accepts_language_auto(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"accept-language-auto\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `accept-language-auto` getter")
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn set_accept_language_auto(&self, accept_language_auto: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"accept-language-auto\0".as_ptr() as *const _, accept_language_auto.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn set_add_feature<P: IsA<SessionFeature>>(&self, add_feature: Option<&P>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"add-feature\0".as_ptr() as *const _, add_feature.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn set_add_feature_by_type(&self, add_feature_by_type: glib::types::Type) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"add-feature-by-type\0".as_ptr() as *const _, add_feature_by_type.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn http_aliases(&self) -> Vec<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<Vec<glib::GString> as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"http-aliases\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `http-aliases` getter")
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn set_http_aliases(&self, http_aliases: &[&str]) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"http-aliases\0".as_ptr() as *const _, http_aliases.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn https_aliases(&self) -> Vec<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<Vec<glib::GString> as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"https-aliases\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `https-aliases` getter")
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn set_https_aliases(&self, https_aliases: &[&str]) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"https-aliases\0".as_ptr() as *const _, https_aliases.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn idle_timeout(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"idle-timeout\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `idle-timeout` getter")
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn set_idle_timeout(&self, idle_timeout: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"idle-timeout\0".as_ptr() as *const _, idle_timeout.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn local_address(&self) -> Option<Address> {
        unsafe {
            let mut value = glib::Value::from_type(<Address as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"local-address\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `local-address` getter")
        }
    }

    fn max_conns(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"max-conns\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `max-conns` getter")
        }
    }

    fn set_max_conns(&self, max_conns: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"max-conns\0".as_ptr() as *const _, max_conns.to_value().to_glib_none().0);
        }
    }

    fn max_conns_per_host(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"max-conns-per-host\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `max-conns-per-host` getter")
        }
    }

    fn set_max_conns_per_host(&self, max_conns_per_host: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"max-conns-per-host\0".as_ptr() as *const _, max_conns_per_host.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn proxy_resolver(&self) -> Option<gio::ProxyResolver> {
        unsafe {
            let mut value = glib::Value::from_type(<gio::ProxyResolver as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"proxy-resolver\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `proxy-resolver` getter")
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn set_proxy_resolver<P: IsA<gio::ProxyResolver>>(&self, proxy_resolver: Option<&P>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"proxy-resolver\0".as_ptr() as *const _, proxy_resolver.to_value().to_glib_none().0);
        }
    }

    fn proxy_uri(&self) -> Option<URI> {
        unsafe {
            let mut value = glib::Value::from_type(<URI as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"proxy-uri\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `proxy-uri` getter")
        }
    }

    fn set_proxy_uri(&self, proxy_uri: Option<&URI>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"proxy-uri\0".as_ptr() as *const _, proxy_uri.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn set_remove_feature_by_type(&self, remove_feature_by_type: glib::types::Type) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"remove-feature-by-type\0".as_ptr() as *const _, remove_feature_by_type.to_value().to_glib_none().0);
        }
    }

    fn ssl_ca_file(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"ssl-ca-file\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `ssl-ca-file` getter")
        }
    }

    fn set_ssl_ca_file(&self, ssl_ca_file: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"ssl-ca-file\0".as_ptr() as *const _, ssl_ca_file.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn is_ssl_strict(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"ssl-strict\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `ssl-strict` getter")
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn set_ssl_strict(&self, ssl_strict: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"ssl-strict\0".as_ptr() as *const _, ssl_strict.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn is_ssl_use_system_ca_file(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"ssl-use-system-ca-file\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `ssl-use-system-ca-file` getter")
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn set_ssl_use_system_ca_file(&self, ssl_use_system_ca_file: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"ssl-use-system-ca-file\0".as_ptr() as *const _, ssl_use_system_ca_file.to_value().to_glib_none().0);
        }
    }

    fn timeout(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"timeout\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `timeout` getter")
        }
    }

    fn set_timeout(&self, timeout: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"timeout\0".as_ptr() as *const _, timeout.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn tls_database(&self) -> Option<gio::TlsDatabase> {
        unsafe {
            let mut value = glib::Value::from_type(<gio::TlsDatabase as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"tls-database\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `tls-database` getter")
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn set_tls_database<P: IsA<gio::TlsDatabase>>(&self, tls_database: Option<&P>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"tls-database\0".as_ptr() as *const _, tls_database.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_48", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_48")))]
    fn tls_interaction(&self) -> Option<gio::TlsInteraction> {
        unsafe {
            let mut value = glib::Value::from_type(<gio::TlsInteraction as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"tls-interaction\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `tls-interaction` getter")
        }
    }

    #[cfg(any(feature = "v2_48", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_48")))]
    fn set_tls_interaction<P: IsA<gio::TlsInteraction>>(&self, tls_interaction: Option<&P>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"tls-interaction\0".as_ptr() as *const _, tls_interaction.to_value().to_glib_none().0);
        }
    }

    fn uses_ntlm(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"use-ntlm\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `use-ntlm` getter")
        }
    }

    fn set_use_ntlm(&self, use_ntlm: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"use-ntlm\0".as_ptr() as *const _, use_ntlm.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn uses_thread_context(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"use-thread-context\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `use-thread-context` getter")
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn set_use_thread_context(&self, use_thread_context: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"use-thread-context\0".as_ptr() as *const _, use_thread_context.to_value().to_glib_none().0);
        }
    }

    fn user_agent(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"user-agent\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `user-agent` getter")
        }
    }

    fn set_user_agent(&self, user_agent: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"user-agent\0".as_ptr() as *const _, user_agent.to_value().to_glib_none().0);
        }
    }

    fn connect_authenticate<F: Fn(&Self, &Message, &Auth, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn authenticate_trampoline<P: IsA<Session>, F: Fn(&P, &Message, &Auth, bool) + 'static>(this: *mut ffi::SoupSession, msg: *mut ffi::SoupMessage, auth: *mut ffi::SoupAuth, retrying: glib::ffi::gboolean, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(msg), &from_glib_borrow(auth), from_glib(retrying))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"authenticate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(authenticate_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn connect_connection_created<F: Fn(&Self, &glib::Object) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn connection_created_trampoline<P: IsA<Session>, F: Fn(&P, &glib::Object) + 'static>(this: *mut ffi::SoupSession, connection: *mut glib::gobject_ffi::GObject, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(connection))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"connection-created\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(connection_created_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn connect_request_queued<F: Fn(&Self, &Message) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn request_queued_trampoline<P: IsA<Session>, F: Fn(&P, &Message) + 'static>(this: *mut ffi::SoupSession, msg: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(msg))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"request-queued\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(request_queued_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_request_started<F: Fn(&Self, &Message, &Socket) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn request_started_trampoline<P: IsA<Session>, F: Fn(&P, &Message, &Socket) + 'static>(this: *mut ffi::SoupSession, msg: *mut ffi::SoupMessage, socket: *mut ffi::SoupSocket, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(msg), &from_glib_borrow(socket))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"request-started\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(request_started_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn connect_request_unqueued<F: Fn(&Self, &Message) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn request_unqueued_trampoline<P: IsA<Session>, F: Fn(&P, &Message) + 'static>(this: *mut ffi::SoupSession, msg: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(msg))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"request-unqueued\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(request_unqueued_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn connect_tunneling<F: Fn(&Self, &glib::Object) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn tunneling_trampoline<P: IsA<Session>, F: Fn(&P, &glib::Object) + 'static>(this: *mut ffi::SoupSession, connection: *mut glib::gobject_ffi::GObject, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(connection))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"tunneling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(tunneling_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn connect_accept_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accept_language_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::accept-language\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_accept_language_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn connect_accept_language_auto_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accept_language_auto_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::accept-language-auto\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_accept_language_auto_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn connect_add_feature_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_add_feature_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::add-feature\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_add_feature_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn connect_add_feature_by_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_add_feature_by_type_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::add-feature-by-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_add_feature_by_type_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn connect_http_aliases_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_http_aliases_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::http-aliases\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_http_aliases_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn connect_https_aliases_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_https_aliases_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::https-aliases\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_https_aliases_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn connect_idle_timeout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_idle_timeout_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::idle-timeout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_idle_timeout_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_max_conns_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_conns_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::max-conns\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_max_conns_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_max_conns_per_host_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_conns_per_host_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::max-conns-per-host\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_max_conns_per_host_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn connect_proxy_resolver_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_proxy_resolver_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::proxy-resolver\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_proxy_resolver_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_proxy_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_proxy_uri_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::proxy-uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_proxy_uri_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn connect_remove_feature_by_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_remove_feature_by_type_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::remove-feature-by-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_remove_feature_by_type_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_ssl_ca_file_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ssl_ca_file_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::ssl-ca-file\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_ssl_ca_file_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn connect_ssl_strict_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ssl_strict_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::ssl-strict\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_ssl_strict_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn connect_ssl_use_system_ca_file_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ssl_use_system_ca_file_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::ssl-use-system-ca-file\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_ssl_use_system_ca_file_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_timeout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_timeout_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::timeout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_timeout_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn connect_tls_database_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_database_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::tls-database\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_tls_database_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_48", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_48")))]
    fn connect_tls_interaction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_interaction_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::tls-interaction\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_tls_interaction_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_use_ntlm_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_ntlm_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::use-ntlm\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_use_ntlm_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn connect_use_thread_context_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_thread_context_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::use-thread-context\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_use_thread_context_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_user_agent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_user_agent_trampoline<P: IsA<Session>, F: Fn(&P) + 'static>(this: *mut ffi::SoupSession, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Session::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::user-agent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_user_agent_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Session {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Session")
    }
}
