// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupAddressFamily")]
pub enum AddressFamily {
    #[doc(alias = "SOUP_ADDRESS_FAMILY_INVALID")]
    Invalid,
    #[doc(alias = "SOUP_ADDRESS_FAMILY_IPV4")]
    Ipv4,
    #[doc(alias = "SOUP_ADDRESS_FAMILY_IPV6")]
    Ipv6,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AddressFamily {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "AddressFamily::{}", match *self {
            Self::Invalid => "Invalid",
            Self::Ipv4 => "Ipv4",
            Self::Ipv6 => "Ipv6",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for AddressFamily {
    type GlibType = ffi::SoupAddressFamily;

    fn into_glib(self) -> ffi::SoupAddressFamily {
        match self {
            Self::Invalid => ffi::SOUP_ADDRESS_FAMILY_INVALID,
            Self::Ipv4 => ffi::SOUP_ADDRESS_FAMILY_IPV4,
            Self::Ipv6 => ffi::SOUP_ADDRESS_FAMILY_IPV6,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupAddressFamily> for AddressFamily {
    unsafe fn from_glib(value: ffi::SoupAddressFamily) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_ADDRESS_FAMILY_INVALID => Self::Invalid,
            ffi::SOUP_ADDRESS_FAMILY_IPV4 => Self::Ipv4,
            ffi::SOUP_ADDRESS_FAMILY_IPV6 => Self::Ipv6,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for AddressFamily {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_address_family_get_type()) }
    }
}

impl glib::value::ValueType for AddressFamily {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AddressFamily {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AddressFamily {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupCacheResponse")]
pub enum CacheResponse {
    #[doc(alias = "SOUP_CACHE_RESPONSE_FRESH")]
    Fresh,
    #[doc(alias = "SOUP_CACHE_RESPONSE_NEEDS_VALIDATION")]
    NeedsValidation,
    #[doc(alias = "SOUP_CACHE_RESPONSE_STALE")]
    Stale,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CacheResponse {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "CacheResponse::{}", match *self {
            Self::Fresh => "Fresh",
            Self::NeedsValidation => "NeedsValidation",
            Self::Stale => "Stale",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for CacheResponse {
    type GlibType = ffi::SoupCacheResponse;

    fn into_glib(self) -> ffi::SoupCacheResponse {
        match self {
            Self::Fresh => ffi::SOUP_CACHE_RESPONSE_FRESH,
            Self::NeedsValidation => ffi::SOUP_CACHE_RESPONSE_NEEDS_VALIDATION,
            Self::Stale => ffi::SOUP_CACHE_RESPONSE_STALE,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupCacheResponse> for CacheResponse {
    unsafe fn from_glib(value: ffi::SoupCacheResponse) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_CACHE_RESPONSE_FRESH => Self::Fresh,
            ffi::SOUP_CACHE_RESPONSE_NEEDS_VALIDATION => Self::NeedsValidation,
            ffi::SOUP_CACHE_RESPONSE_STALE => Self::Stale,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for CacheResponse {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_cache_response_get_type()) }
    }
}

impl glib::value::ValueType for CacheResponse {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CacheResponse {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CacheResponse {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupCacheType")]
pub enum CacheType {
    #[doc(alias = "SOUP_CACHE_SINGLE_USER")]
    SingleUser,
    #[doc(alias = "SOUP_CACHE_SHARED")]
    Shared,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
impl fmt::Display for CacheType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "CacheType::{}", match *self {
            Self::SingleUser => "SingleUser",
            Self::Shared => "Shared",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
#[doc(hidden)]
impl IntoGlib for CacheType {
    type GlibType = ffi::SoupCacheType;

    fn into_glib(self) -> ffi::SoupCacheType {
        match self {
            Self::SingleUser => ffi::SOUP_CACHE_SINGLE_USER,
            Self::Shared => ffi::SOUP_CACHE_SHARED,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupCacheType> for CacheType {
    unsafe fn from_glib(value: ffi::SoupCacheType) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_CACHE_SINGLE_USER => Self::SingleUser,
            ffi::SOUP_CACHE_SHARED => Self::Shared,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
impl StaticType for CacheType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_cache_type_get_type()) }
    }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
impl glib::value::ValueType for CacheType {
    type Type = Self;
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
unsafe impl<'a> FromValue<'a> for CacheType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
impl ToValue for CacheType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupConnectionState")]
pub enum ConnectionState {
    #[doc(alias = "SOUP_CONNECTION_NEW")]
    New,
    #[doc(alias = "SOUP_CONNECTION_CONNECTING")]
    Connecting,
    #[doc(alias = "SOUP_CONNECTION_IDLE")]
    Idle,
    #[doc(alias = "SOUP_CONNECTION_IN_USE")]
    InUse,
    #[doc(alias = "SOUP_CONNECTION_REMOTE_DISCONNECTED")]
    RemoteDisconnected,
    #[doc(alias = "SOUP_CONNECTION_DISCONNECTED")]
    Disconnected,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ConnectionState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "ConnectionState::{}", match *self {
            Self::New => "New",
            Self::Connecting => "Connecting",
            Self::Idle => "Idle",
            Self::InUse => "InUse",
            Self::RemoteDisconnected => "RemoteDisconnected",
            Self::Disconnected => "Disconnected",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for ConnectionState {
    type GlibType = ffi::SoupConnectionState;

    fn into_glib(self) -> ffi::SoupConnectionState {
        match self {
            Self::New => ffi::SOUP_CONNECTION_NEW,
            Self::Connecting => ffi::SOUP_CONNECTION_CONNECTING,
            Self::Idle => ffi::SOUP_CONNECTION_IDLE,
            Self::InUse => ffi::SOUP_CONNECTION_IN_USE,
            Self::RemoteDisconnected => ffi::SOUP_CONNECTION_REMOTE_DISCONNECTED,
            Self::Disconnected => ffi::SOUP_CONNECTION_DISCONNECTED,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupConnectionState> for ConnectionState {
    unsafe fn from_glib(value: ffi::SoupConnectionState) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_CONNECTION_NEW => Self::New,
            ffi::SOUP_CONNECTION_CONNECTING => Self::Connecting,
            ffi::SOUP_CONNECTION_IDLE => Self::Idle,
            ffi::SOUP_CONNECTION_IN_USE => Self::InUse,
            ffi::SOUP_CONNECTION_REMOTE_DISCONNECTED => Self::RemoteDisconnected,
            ffi::SOUP_CONNECTION_DISCONNECTED => Self::Disconnected,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for ConnectionState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_connection_state_get_type()) }
    }
}

impl glib::value::ValueType for ConnectionState {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ConnectionState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ConnectionState {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupCookieJarAcceptPolicy")]
pub enum CookieJarAcceptPolicy {
    #[doc(alias = "SOUP_COOKIE_JAR_ACCEPT_ALWAYS")]
    Always,
    #[doc(alias = "SOUP_COOKIE_JAR_ACCEPT_NEVER")]
    Never,
    #[doc(alias = "SOUP_COOKIE_JAR_ACCEPT_NO_THIRD_PARTY")]
    NoThirdParty,
    #[doc(alias = "SOUP_COOKIE_JAR_ACCEPT_GRANDFATHERED_THIRD_PARTY")]
    GrandfatheredThirdParty,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
impl fmt::Display for CookieJarAcceptPolicy {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "CookieJarAcceptPolicy::{}", match *self {
            Self::Always => "Always",
            Self::Never => "Never",
            Self::NoThirdParty => "NoThirdParty",
            Self::GrandfatheredThirdParty => "GrandfatheredThirdParty",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
#[doc(hidden)]
impl IntoGlib for CookieJarAcceptPolicy {
    type GlibType = ffi::SoupCookieJarAcceptPolicy;

    fn into_glib(self) -> ffi::SoupCookieJarAcceptPolicy {
        match self {
            Self::Always => ffi::SOUP_COOKIE_JAR_ACCEPT_ALWAYS,
            Self::Never => ffi::SOUP_COOKIE_JAR_ACCEPT_NEVER,
            Self::NoThirdParty => ffi::SOUP_COOKIE_JAR_ACCEPT_NO_THIRD_PARTY,
            Self::GrandfatheredThirdParty => ffi::SOUP_COOKIE_JAR_ACCEPT_GRANDFATHERED_THIRD_PARTY,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupCookieJarAcceptPolicy> for CookieJarAcceptPolicy {
    unsafe fn from_glib(value: ffi::SoupCookieJarAcceptPolicy) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_COOKIE_JAR_ACCEPT_ALWAYS => Self::Always,
            ffi::SOUP_COOKIE_JAR_ACCEPT_NEVER => Self::Never,
            ffi::SOUP_COOKIE_JAR_ACCEPT_NO_THIRD_PARTY => Self::NoThirdParty,
            ffi::SOUP_COOKIE_JAR_ACCEPT_GRANDFATHERED_THIRD_PARTY => Self::GrandfatheredThirdParty,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
impl StaticType for CookieJarAcceptPolicy {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_cookie_jar_accept_policy_get_type()) }
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
impl glib::value::ValueType for CookieJarAcceptPolicy {
    type Type = Self;
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
unsafe impl<'a> FromValue<'a> for CookieJarAcceptPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
impl ToValue for CookieJarAcceptPolicy {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupDateFormat")]
pub enum DateFormat {
    #[doc(alias = "SOUP_DATE_HTTP")]
    Http,
    #[doc(alias = "SOUP_DATE_COOKIE")]
    Cookie,
    #[doc(alias = "SOUP_DATE_RFC2822")]
    Rfc2822,
    #[doc(alias = "SOUP_DATE_ISO8601_COMPACT")]
    Iso8601Compact,
    #[doc(alias = "SOUP_DATE_ISO8601_FULL")]
    Iso8601Full,
    #[doc(alias = "SOUP_DATE_ISO8601_XMLRPC")]
    Iso8601Xmlrpc,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DateFormat {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "DateFormat::{}", match *self {
            Self::Http => "Http",
            Self::Cookie => "Cookie",
            Self::Rfc2822 => "Rfc2822",
            Self::Iso8601Compact => "Iso8601Compact",
            Self::Iso8601Full => "Iso8601Full",
            Self::Iso8601Xmlrpc => "Iso8601Xmlrpc",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for DateFormat {
    type GlibType = ffi::SoupDateFormat;

    fn into_glib(self) -> ffi::SoupDateFormat {
        match self {
            Self::Http => ffi::SOUP_DATE_HTTP,
            Self::Cookie => ffi::SOUP_DATE_COOKIE,
            Self::Rfc2822 => ffi::SOUP_DATE_RFC2822,
            Self::Iso8601Compact => ffi::SOUP_DATE_ISO8601_COMPACT,
            Self::Iso8601Full => ffi::SOUP_DATE_ISO8601_FULL,
            Self::Iso8601Xmlrpc => ffi::SOUP_DATE_ISO8601_XMLRPC,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupDateFormat> for DateFormat {
    unsafe fn from_glib(value: ffi::SoupDateFormat) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_DATE_HTTP => Self::Http,
            ffi::SOUP_DATE_COOKIE => Self::Cookie,
            ffi::SOUP_DATE_RFC2822 => Self::Rfc2822,
            ffi::SOUP_DATE_ISO8601_COMPACT => Self::Iso8601Compact,
            ffi::SOUP_DATE_ISO8601_FULL => Self::Iso8601Full,
            ffi::SOUP_DATE_ISO8601_XMLRPC => Self::Iso8601Xmlrpc,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for DateFormat {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_date_format_get_type()) }
    }
}

impl glib::value::ValueType for DateFormat {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DateFormat {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DateFormat {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupEncoding")]
pub enum Encoding {
    #[doc(alias = "SOUP_ENCODING_UNRECOGNIZED")]
    Unrecognized,
    #[doc(alias = "SOUP_ENCODING_NONE")]
    None,
    #[doc(alias = "SOUP_ENCODING_CONTENT_LENGTH")]
    ContentLength,
    #[doc(alias = "SOUP_ENCODING_EOF")]
    Eof,
    #[doc(alias = "SOUP_ENCODING_CHUNKED")]
    Chunked,
    #[doc(alias = "SOUP_ENCODING_BYTERANGES")]
    Byteranges,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Encoding {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Encoding::{}", match *self {
            Self::Unrecognized => "Unrecognized",
            Self::None => "None",
            Self::ContentLength => "ContentLength",
            Self::Eof => "Eof",
            Self::Chunked => "Chunked",
            Self::Byteranges => "Byteranges",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for Encoding {
    type GlibType = ffi::SoupEncoding;

    fn into_glib(self) -> ffi::SoupEncoding {
        match self {
            Self::Unrecognized => ffi::SOUP_ENCODING_UNRECOGNIZED,
            Self::None => ffi::SOUP_ENCODING_NONE,
            Self::ContentLength => ffi::SOUP_ENCODING_CONTENT_LENGTH,
            Self::Eof => ffi::SOUP_ENCODING_EOF,
            Self::Chunked => ffi::SOUP_ENCODING_CHUNKED,
            Self::Byteranges => ffi::SOUP_ENCODING_BYTERANGES,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupEncoding> for Encoding {
    unsafe fn from_glib(value: ffi::SoupEncoding) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_ENCODING_UNRECOGNIZED => Self::Unrecognized,
            ffi::SOUP_ENCODING_NONE => Self::None,
            ffi::SOUP_ENCODING_CONTENT_LENGTH => Self::ContentLength,
            ffi::SOUP_ENCODING_EOF => Self::Eof,
            ffi::SOUP_ENCODING_CHUNKED => Self::Chunked,
            ffi::SOUP_ENCODING_BYTERANGES => Self::Byteranges,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for Encoding {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_encoding_get_type()) }
    }
}

impl glib::value::ValueType for Encoding {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Encoding {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Encoding {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupHTTPVersion")]
pub enum HTTPVersion {
    #[doc(alias = "SOUP_HTTP_1_0")]
    Http10,
    #[doc(alias = "SOUP_HTTP_1_1")]
    Http11,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for HTTPVersion {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "HTTPVersion::{}", match *self {
            Self::Http10 => "Http10",
            Self::Http11 => "Http11",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for HTTPVersion {
    type GlibType = ffi::SoupHTTPVersion;

    fn into_glib(self) -> ffi::SoupHTTPVersion {
        match self {
            Self::Http10 => ffi::SOUP_HTTP_1_0,
            Self::Http11 => ffi::SOUP_HTTP_1_1,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupHTTPVersion> for HTTPVersion {
    unsafe fn from_glib(value: ffi::SoupHTTPVersion) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_HTTP_1_0 => Self::Http10,
            ffi::SOUP_HTTP_1_1 => Self::Http11,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for HTTPVersion {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_http_version_get_type()) }
    }
}

impl glib::value::ValueType for HTTPVersion {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for HTTPVersion {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for HTTPVersion {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupKnownStatusCode")]
pub enum KnownStatusCode {
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NONE")]
    None,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_CANCELLED")]
    Cancelled,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_CANT_RESOLVE")]
    CantResolve,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_CANT_RESOLVE_PROXY")]
    CantResolveProxy,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_CANT_CONNECT")]
    CantConnect,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_CANT_CONNECT_PROXY")]
    CantConnectProxy,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_SSL_FAILED")]
    SslFailed,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_IO_ERROR")]
    IoError,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_MALFORMED")]
    Malformed,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_TRY_AGAIN")]
    TryAgain,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_TOO_MANY_REDIRECTS")]
    TooManyRedirects,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_TLS_FAILED")]
    TlsFailed,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_CONTINUE")]
    Continue,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_SWITCHING_PROTOCOLS")]
    SwitchingProtocols,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_PROCESSING")]
    Processing,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_OK")]
    Ok,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_CREATED")]
    Created,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_ACCEPTED")]
    Accepted,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NON_AUTHORITATIVE")]
    NonAuthoritative,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NO_CONTENT")]
    NoContent,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_RESET_CONTENT")]
    ResetContent,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_PARTIAL_CONTENT")]
    PartialContent,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_MULTI_STATUS")]
    MultiStatus,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_MULTIPLE_CHOICES")]
    MultipleChoices,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_MOVED_PERMANENTLY")]
    MovedPermanently,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_FOUND")]
    Found,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_SEE_OTHER")]
    SeeOther,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NOT_MODIFIED")]
    NotModified,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_USE_PROXY")]
    UseProxy,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NOT_APPEARING_IN_THIS_PROTOCOL")]
    NotAppearingInThisProtocol,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_TEMPORARY_REDIRECT")]
    TemporaryRedirect,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_BAD_REQUEST")]
    BadRequest,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_UNAUTHORIZED")]
    Unauthorized,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_PAYMENT_REQUIRED")]
    PaymentRequired,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_FORBIDDEN")]
    Forbidden,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NOT_FOUND")]
    NotFound,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_METHOD_NOT_ALLOWED")]
    MethodNotAllowed,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NOT_ACCEPTABLE")]
    NotAcceptable,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_PROXY_AUTHENTICATION_REQUIRED")]
    ProxyAuthenticationRequired,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_REQUEST_TIMEOUT")]
    RequestTimeout,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_CONFLICT")]
    Conflict,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_GONE")]
    Gone,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_LENGTH_REQUIRED")]
    LengthRequired,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_PRECONDITION_FAILED")]
    PreconditionFailed,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_REQUEST_ENTITY_TOO_LARGE")]
    RequestEntityTooLarge,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_REQUEST_URI_TOO_LONG")]
    RequestUriTooLong,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_UNSUPPORTED_MEDIA_TYPE")]
    UnsupportedMediaType,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_REQUESTED_RANGE_NOT_SATISFIABLE")]
    RequestedRangeNotSatisfiable,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_EXPECTATION_FAILED")]
    ExpectationFailed,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_UNPROCESSABLE_ENTITY")]
    UnprocessableEntity,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_LOCKED")]
    Locked,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_FAILED_DEPENDENCY")]
    FailedDependency,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_INTERNAL_SERVER_ERROR")]
    InternalServerError,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NOT_IMPLEMENTED")]
    NotImplemented,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_BAD_GATEWAY")]
    BadGateway,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_SERVICE_UNAVAILABLE")]
    ServiceUnavailable,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_GATEWAY_TIMEOUT")]
    GatewayTimeout,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_HTTP_VERSION_NOT_SUPPORTED")]
    HttpVersionNotSupported,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_INSUFFICIENT_STORAGE")]
    InsufficientStorage,
    #[doc(alias = "SOUP_KNOWN_STATUS_CODE_NOT_EXTENDED")]
    NotExtended,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for KnownStatusCode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "KnownStatusCode::{}", match *self {
            Self::None => "None",
            Self::Cancelled => "Cancelled",
            Self::CantResolve => "CantResolve",
            Self::CantResolveProxy => "CantResolveProxy",
            Self::CantConnect => "CantConnect",
            Self::CantConnectProxy => "CantConnectProxy",
            Self::SslFailed => "SslFailed",
            Self::IoError => "IoError",
            Self::Malformed => "Malformed",
            Self::TryAgain => "TryAgain",
            Self::TooManyRedirects => "TooManyRedirects",
            Self::TlsFailed => "TlsFailed",
            Self::Continue => "Continue",
            Self::SwitchingProtocols => "SwitchingProtocols",
            Self::Processing => "Processing",
            Self::Ok => "Ok",
            Self::Created => "Created",
            Self::Accepted => "Accepted",
            Self::NonAuthoritative => "NonAuthoritative",
            Self::NoContent => "NoContent",
            Self::ResetContent => "ResetContent",
            Self::PartialContent => "PartialContent",
            Self::MultiStatus => "MultiStatus",
            Self::MultipleChoices => "MultipleChoices",
            Self::MovedPermanently => "MovedPermanently",
            Self::Found => "Found",
            Self::SeeOther => "SeeOther",
            Self::NotModified => "NotModified",
            Self::UseProxy => "UseProxy",
            Self::NotAppearingInThisProtocol => "NotAppearingInThisProtocol",
            Self::TemporaryRedirect => "TemporaryRedirect",
            Self::BadRequest => "BadRequest",
            Self::Unauthorized => "Unauthorized",
            Self::PaymentRequired => "PaymentRequired",
            Self::Forbidden => "Forbidden",
            Self::NotFound => "NotFound",
            Self::MethodNotAllowed => "MethodNotAllowed",
            Self::NotAcceptable => "NotAcceptable",
            Self::ProxyAuthenticationRequired => "ProxyAuthenticationRequired",
            Self::RequestTimeout => "RequestTimeout",
            Self::Conflict => "Conflict",
            Self::Gone => "Gone",
            Self::LengthRequired => "LengthRequired",
            Self::PreconditionFailed => "PreconditionFailed",
            Self::RequestEntityTooLarge => "RequestEntityTooLarge",
            Self::RequestUriTooLong => "RequestUriTooLong",
            Self::UnsupportedMediaType => "UnsupportedMediaType",
            Self::RequestedRangeNotSatisfiable => "RequestedRangeNotSatisfiable",
            Self::ExpectationFailed => "ExpectationFailed",
            Self::UnprocessableEntity => "UnprocessableEntity",
            Self::Locked => "Locked",
            Self::FailedDependency => "FailedDependency",
            Self::InternalServerError => "InternalServerError",
            Self::NotImplemented => "NotImplemented",
            Self::BadGateway => "BadGateway",
            Self::ServiceUnavailable => "ServiceUnavailable",
            Self::GatewayTimeout => "GatewayTimeout",
            Self::HttpVersionNotSupported => "HttpVersionNotSupported",
            Self::InsufficientStorage => "InsufficientStorage",
            Self::NotExtended => "NotExtended",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for KnownStatusCode {
    type GlibType = ffi::SoupKnownStatusCode;

    fn into_glib(self) -> ffi::SoupKnownStatusCode {
        match self {
            Self::None => ffi::SOUP_KNOWN_STATUS_CODE_NONE,
            Self::Cancelled => ffi::SOUP_KNOWN_STATUS_CODE_CANCELLED,
            Self::CantResolve => ffi::SOUP_KNOWN_STATUS_CODE_CANT_RESOLVE,
            Self::CantResolveProxy => ffi::SOUP_KNOWN_STATUS_CODE_CANT_RESOLVE_PROXY,
            Self::CantConnect => ffi::SOUP_KNOWN_STATUS_CODE_CANT_CONNECT,
            Self::CantConnectProxy => ffi::SOUP_KNOWN_STATUS_CODE_CANT_CONNECT_PROXY,
            Self::SslFailed => ffi::SOUP_KNOWN_STATUS_CODE_SSL_FAILED,
            Self::IoError => ffi::SOUP_KNOWN_STATUS_CODE_IO_ERROR,
            Self::Malformed => ffi::SOUP_KNOWN_STATUS_CODE_MALFORMED,
            Self::TryAgain => ffi::SOUP_KNOWN_STATUS_CODE_TRY_AGAIN,
            Self::TooManyRedirects => ffi::SOUP_KNOWN_STATUS_CODE_TOO_MANY_REDIRECTS,
            Self::TlsFailed => ffi::SOUP_KNOWN_STATUS_CODE_TLS_FAILED,
            Self::Continue => ffi::SOUP_KNOWN_STATUS_CODE_CONTINUE,
            Self::SwitchingProtocols => ffi::SOUP_KNOWN_STATUS_CODE_SWITCHING_PROTOCOLS,
            Self::Processing => ffi::SOUP_KNOWN_STATUS_CODE_PROCESSING,
            Self::Ok => ffi::SOUP_KNOWN_STATUS_CODE_OK,
            Self::Created => ffi::SOUP_KNOWN_STATUS_CODE_CREATED,
            Self::Accepted => ffi::SOUP_KNOWN_STATUS_CODE_ACCEPTED,
            Self::NonAuthoritative => ffi::SOUP_KNOWN_STATUS_CODE_NON_AUTHORITATIVE,
            Self::NoContent => ffi::SOUP_KNOWN_STATUS_CODE_NO_CONTENT,
            Self::ResetContent => ffi::SOUP_KNOWN_STATUS_CODE_RESET_CONTENT,
            Self::PartialContent => ffi::SOUP_KNOWN_STATUS_CODE_PARTIAL_CONTENT,
            Self::MultiStatus => ffi::SOUP_KNOWN_STATUS_CODE_MULTI_STATUS,
            Self::MultipleChoices => ffi::SOUP_KNOWN_STATUS_CODE_MULTIPLE_CHOICES,
            Self::MovedPermanently => ffi::SOUP_KNOWN_STATUS_CODE_MOVED_PERMANENTLY,
            Self::Found => ffi::SOUP_KNOWN_STATUS_CODE_FOUND,
            Self::SeeOther => ffi::SOUP_KNOWN_STATUS_CODE_SEE_OTHER,
            Self::NotModified => ffi::SOUP_KNOWN_STATUS_CODE_NOT_MODIFIED,
            Self::UseProxy => ffi::SOUP_KNOWN_STATUS_CODE_USE_PROXY,
            Self::NotAppearingInThisProtocol => ffi::SOUP_KNOWN_STATUS_CODE_NOT_APPEARING_IN_THIS_PROTOCOL,
            Self::TemporaryRedirect => ffi::SOUP_KNOWN_STATUS_CODE_TEMPORARY_REDIRECT,
            Self::BadRequest => ffi::SOUP_KNOWN_STATUS_CODE_BAD_REQUEST,
            Self::Unauthorized => ffi::SOUP_KNOWN_STATUS_CODE_UNAUTHORIZED,
            Self::PaymentRequired => ffi::SOUP_KNOWN_STATUS_CODE_PAYMENT_REQUIRED,
            Self::Forbidden => ffi::SOUP_KNOWN_STATUS_CODE_FORBIDDEN,
            Self::NotFound => ffi::SOUP_KNOWN_STATUS_CODE_NOT_FOUND,
            Self::MethodNotAllowed => ffi::SOUP_KNOWN_STATUS_CODE_METHOD_NOT_ALLOWED,
            Self::NotAcceptable => ffi::SOUP_KNOWN_STATUS_CODE_NOT_ACCEPTABLE,
            Self::ProxyAuthenticationRequired => ffi::SOUP_KNOWN_STATUS_CODE_PROXY_AUTHENTICATION_REQUIRED,
            Self::RequestTimeout => ffi::SOUP_KNOWN_STATUS_CODE_REQUEST_TIMEOUT,
            Self::Conflict => ffi::SOUP_KNOWN_STATUS_CODE_CONFLICT,
            Self::Gone => ffi::SOUP_KNOWN_STATUS_CODE_GONE,
            Self::LengthRequired => ffi::SOUP_KNOWN_STATUS_CODE_LENGTH_REQUIRED,
            Self::PreconditionFailed => ffi::SOUP_KNOWN_STATUS_CODE_PRECONDITION_FAILED,
            Self::RequestEntityTooLarge => ffi::SOUP_KNOWN_STATUS_CODE_REQUEST_ENTITY_TOO_LARGE,
            Self::RequestUriTooLong => ffi::SOUP_KNOWN_STATUS_CODE_REQUEST_URI_TOO_LONG,
            Self::UnsupportedMediaType => ffi::SOUP_KNOWN_STATUS_CODE_UNSUPPORTED_MEDIA_TYPE,
            Self::RequestedRangeNotSatisfiable => ffi::SOUP_KNOWN_STATUS_CODE_REQUESTED_RANGE_NOT_SATISFIABLE,
            Self::ExpectationFailed => ffi::SOUP_KNOWN_STATUS_CODE_EXPECTATION_FAILED,
            Self::UnprocessableEntity => ffi::SOUP_KNOWN_STATUS_CODE_UNPROCESSABLE_ENTITY,
            Self::Locked => ffi::SOUP_KNOWN_STATUS_CODE_LOCKED,
            Self::FailedDependency => ffi::SOUP_KNOWN_STATUS_CODE_FAILED_DEPENDENCY,
            Self::InternalServerError => ffi::SOUP_KNOWN_STATUS_CODE_INTERNAL_SERVER_ERROR,
            Self::NotImplemented => ffi::SOUP_KNOWN_STATUS_CODE_NOT_IMPLEMENTED,
            Self::BadGateway => ffi::SOUP_KNOWN_STATUS_CODE_BAD_GATEWAY,
            Self::ServiceUnavailable => ffi::SOUP_KNOWN_STATUS_CODE_SERVICE_UNAVAILABLE,
            Self::GatewayTimeout => ffi::SOUP_KNOWN_STATUS_CODE_GATEWAY_TIMEOUT,
            Self::HttpVersionNotSupported => ffi::SOUP_KNOWN_STATUS_CODE_HTTP_VERSION_NOT_SUPPORTED,
            Self::InsufficientStorage => ffi::SOUP_KNOWN_STATUS_CODE_INSUFFICIENT_STORAGE,
            Self::NotExtended => ffi::SOUP_KNOWN_STATUS_CODE_NOT_EXTENDED,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupKnownStatusCode> for KnownStatusCode {
    unsafe fn from_glib(value: ffi::SoupKnownStatusCode) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_KNOWN_STATUS_CODE_NONE => Self::None,
            ffi::SOUP_KNOWN_STATUS_CODE_CANCELLED => Self::Cancelled,
            ffi::SOUP_KNOWN_STATUS_CODE_CANT_RESOLVE => Self::CantResolve,
            ffi::SOUP_KNOWN_STATUS_CODE_CANT_RESOLVE_PROXY => Self::CantResolveProxy,
            ffi::SOUP_KNOWN_STATUS_CODE_CANT_CONNECT => Self::CantConnect,
            ffi::SOUP_KNOWN_STATUS_CODE_CANT_CONNECT_PROXY => Self::CantConnectProxy,
            ffi::SOUP_KNOWN_STATUS_CODE_SSL_FAILED => Self::SslFailed,
            ffi::SOUP_KNOWN_STATUS_CODE_IO_ERROR => Self::IoError,
            ffi::SOUP_KNOWN_STATUS_CODE_MALFORMED => Self::Malformed,
            ffi::SOUP_KNOWN_STATUS_CODE_TRY_AGAIN => Self::TryAgain,
            ffi::SOUP_KNOWN_STATUS_CODE_TOO_MANY_REDIRECTS => Self::TooManyRedirects,
            ffi::SOUP_KNOWN_STATUS_CODE_TLS_FAILED => Self::TlsFailed,
            ffi::SOUP_KNOWN_STATUS_CODE_CONTINUE => Self::Continue,
            ffi::SOUP_KNOWN_STATUS_CODE_SWITCHING_PROTOCOLS => Self::SwitchingProtocols,
            ffi::SOUP_KNOWN_STATUS_CODE_PROCESSING => Self::Processing,
            ffi::SOUP_KNOWN_STATUS_CODE_OK => Self::Ok,
            ffi::SOUP_KNOWN_STATUS_CODE_CREATED => Self::Created,
            ffi::SOUP_KNOWN_STATUS_CODE_ACCEPTED => Self::Accepted,
            ffi::SOUP_KNOWN_STATUS_CODE_NON_AUTHORITATIVE => Self::NonAuthoritative,
            ffi::SOUP_KNOWN_STATUS_CODE_NO_CONTENT => Self::NoContent,
            ffi::SOUP_KNOWN_STATUS_CODE_RESET_CONTENT => Self::ResetContent,
            ffi::SOUP_KNOWN_STATUS_CODE_PARTIAL_CONTENT => Self::PartialContent,
            ffi::SOUP_KNOWN_STATUS_CODE_MULTI_STATUS => Self::MultiStatus,
            ffi::SOUP_KNOWN_STATUS_CODE_MULTIPLE_CHOICES => Self::MultipleChoices,
            ffi::SOUP_KNOWN_STATUS_CODE_MOVED_PERMANENTLY => Self::MovedPermanently,
            ffi::SOUP_KNOWN_STATUS_CODE_FOUND => Self::Found,
            ffi::SOUP_KNOWN_STATUS_CODE_SEE_OTHER => Self::SeeOther,
            ffi::SOUP_KNOWN_STATUS_CODE_NOT_MODIFIED => Self::NotModified,
            ffi::SOUP_KNOWN_STATUS_CODE_USE_PROXY => Self::UseProxy,
            ffi::SOUP_KNOWN_STATUS_CODE_NOT_APPEARING_IN_THIS_PROTOCOL => Self::NotAppearingInThisProtocol,
            ffi::SOUP_KNOWN_STATUS_CODE_TEMPORARY_REDIRECT => Self::TemporaryRedirect,
            ffi::SOUP_KNOWN_STATUS_CODE_BAD_REQUEST => Self::BadRequest,
            ffi::SOUP_KNOWN_STATUS_CODE_UNAUTHORIZED => Self::Unauthorized,
            ffi::SOUP_KNOWN_STATUS_CODE_PAYMENT_REQUIRED => Self::PaymentRequired,
            ffi::SOUP_KNOWN_STATUS_CODE_FORBIDDEN => Self::Forbidden,
            ffi::SOUP_KNOWN_STATUS_CODE_NOT_FOUND => Self::NotFound,
            ffi::SOUP_KNOWN_STATUS_CODE_METHOD_NOT_ALLOWED => Self::MethodNotAllowed,
            ffi::SOUP_KNOWN_STATUS_CODE_NOT_ACCEPTABLE => Self::NotAcceptable,
            ffi::SOUP_KNOWN_STATUS_CODE_PROXY_AUTHENTICATION_REQUIRED => Self::ProxyAuthenticationRequired,
            ffi::SOUP_KNOWN_STATUS_CODE_REQUEST_TIMEOUT => Self::RequestTimeout,
            ffi::SOUP_KNOWN_STATUS_CODE_CONFLICT => Self::Conflict,
            ffi::SOUP_KNOWN_STATUS_CODE_GONE => Self::Gone,
            ffi::SOUP_KNOWN_STATUS_CODE_LENGTH_REQUIRED => Self::LengthRequired,
            ffi::SOUP_KNOWN_STATUS_CODE_PRECONDITION_FAILED => Self::PreconditionFailed,
            ffi::SOUP_KNOWN_STATUS_CODE_REQUEST_ENTITY_TOO_LARGE => Self::RequestEntityTooLarge,
            ffi::SOUP_KNOWN_STATUS_CODE_REQUEST_URI_TOO_LONG => Self::RequestUriTooLong,
            ffi::SOUP_KNOWN_STATUS_CODE_UNSUPPORTED_MEDIA_TYPE => Self::UnsupportedMediaType,
            ffi::SOUP_KNOWN_STATUS_CODE_REQUESTED_RANGE_NOT_SATISFIABLE => Self::RequestedRangeNotSatisfiable,
            ffi::SOUP_KNOWN_STATUS_CODE_EXPECTATION_FAILED => Self::ExpectationFailed,
            ffi::SOUP_KNOWN_STATUS_CODE_UNPROCESSABLE_ENTITY => Self::UnprocessableEntity,
            ffi::SOUP_KNOWN_STATUS_CODE_LOCKED => Self::Locked,
            ffi::SOUP_KNOWN_STATUS_CODE_FAILED_DEPENDENCY => Self::FailedDependency,
            ffi::SOUP_KNOWN_STATUS_CODE_INTERNAL_SERVER_ERROR => Self::InternalServerError,
            ffi::SOUP_KNOWN_STATUS_CODE_NOT_IMPLEMENTED => Self::NotImplemented,
            ffi::SOUP_KNOWN_STATUS_CODE_BAD_GATEWAY => Self::BadGateway,
            ffi::SOUP_KNOWN_STATUS_CODE_SERVICE_UNAVAILABLE => Self::ServiceUnavailable,
            ffi::SOUP_KNOWN_STATUS_CODE_GATEWAY_TIMEOUT => Self::GatewayTimeout,
            ffi::SOUP_KNOWN_STATUS_CODE_HTTP_VERSION_NOT_SUPPORTED => Self::HttpVersionNotSupported,
            ffi::SOUP_KNOWN_STATUS_CODE_INSUFFICIENT_STORAGE => Self::InsufficientStorage,
            ffi::SOUP_KNOWN_STATUS_CODE_NOT_EXTENDED => Self::NotExtended,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for KnownStatusCode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_known_status_code_get_type()) }
    }
}

impl glib::value::ValueType for KnownStatusCode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for KnownStatusCode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for KnownStatusCode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupLoggerLogLevel")]
pub enum LoggerLogLevel {
    #[doc(alias = "SOUP_LOGGER_LOG_NONE")]
    None,
    #[doc(alias = "SOUP_LOGGER_LOG_MINIMAL")]
    Minimal,
    #[doc(alias = "SOUP_LOGGER_LOG_HEADERS")]
    Headers,
    #[doc(alias = "SOUP_LOGGER_LOG_BODY")]
    Body,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for LoggerLogLevel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "LoggerLogLevel::{}", match *self {
            Self::None => "None",
            Self::Minimal => "Minimal",
            Self::Headers => "Headers",
            Self::Body => "Body",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for LoggerLogLevel {
    type GlibType = ffi::SoupLoggerLogLevel;

    fn into_glib(self) -> ffi::SoupLoggerLogLevel {
        match self {
            Self::None => ffi::SOUP_LOGGER_LOG_NONE,
            Self::Minimal => ffi::SOUP_LOGGER_LOG_MINIMAL,
            Self::Headers => ffi::SOUP_LOGGER_LOG_HEADERS,
            Self::Body => ffi::SOUP_LOGGER_LOG_BODY,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupLoggerLogLevel> for LoggerLogLevel {
    unsafe fn from_glib(value: ffi::SoupLoggerLogLevel) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_LOGGER_LOG_NONE => Self::None,
            ffi::SOUP_LOGGER_LOG_MINIMAL => Self::Minimal,
            ffi::SOUP_LOGGER_LOG_HEADERS => Self::Headers,
            ffi::SOUP_LOGGER_LOG_BODY => Self::Body,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for LoggerLogLevel {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_logger_log_level_get_type()) }
    }
}

impl glib::value::ValueType for LoggerLogLevel {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for LoggerLogLevel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for LoggerLogLevel {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupMemoryUse")]
pub enum MemoryUse {
    #[doc(alias = "SOUP_MEMORY_STATIC")]
    Static,
    #[doc(alias = "SOUP_MEMORY_TAKE")]
    Take,
    #[doc(alias = "SOUP_MEMORY_COPY")]
    Copy,
    #[doc(alias = "SOUP_MEMORY_TEMPORARY")]
    Temporary,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MemoryUse {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "MemoryUse::{}", match *self {
            Self::Static => "Static",
            Self::Take => "Take",
            Self::Copy => "Copy",
            Self::Temporary => "Temporary",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for MemoryUse {
    type GlibType = ffi::SoupMemoryUse;

    fn into_glib(self) -> ffi::SoupMemoryUse {
        match self {
            Self::Static => ffi::SOUP_MEMORY_STATIC,
            Self::Take => ffi::SOUP_MEMORY_TAKE,
            Self::Copy => ffi::SOUP_MEMORY_COPY,
            Self::Temporary => ffi::SOUP_MEMORY_TEMPORARY,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupMemoryUse> for MemoryUse {
    unsafe fn from_glib(value: ffi::SoupMemoryUse) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_MEMORY_STATIC => Self::Static,
            ffi::SOUP_MEMORY_TAKE => Self::Take,
            ffi::SOUP_MEMORY_COPY => Self::Copy,
            ffi::SOUP_MEMORY_TEMPORARY => Self::Temporary,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for MemoryUse {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_memory_use_get_type()) }
    }
}

impl glib::value::ValueType for MemoryUse {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MemoryUse {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MemoryUse {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupMessageHeadersType")]
pub enum MessageHeadersType {
    #[doc(alias = "SOUP_MESSAGE_HEADERS_REQUEST")]
    Request,
    #[doc(alias = "SOUP_MESSAGE_HEADERS_RESPONSE")]
    Response,
    #[doc(alias = "SOUP_MESSAGE_HEADERS_MULTIPART")]
    Multipart,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MessageHeadersType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "MessageHeadersType::{}", match *self {
            Self::Request => "Request",
            Self::Response => "Response",
            Self::Multipart => "Multipart",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for MessageHeadersType {
    type GlibType = ffi::SoupMessageHeadersType;

    fn into_glib(self) -> ffi::SoupMessageHeadersType {
        match self {
            Self::Request => ffi::SOUP_MESSAGE_HEADERS_REQUEST,
            Self::Response => ffi::SOUP_MESSAGE_HEADERS_RESPONSE,
            Self::Multipart => ffi::SOUP_MESSAGE_HEADERS_MULTIPART,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupMessageHeadersType> for MessageHeadersType {
    unsafe fn from_glib(value: ffi::SoupMessageHeadersType) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_MESSAGE_HEADERS_REQUEST => Self::Request,
            ffi::SOUP_MESSAGE_HEADERS_RESPONSE => Self::Response,
            ffi::SOUP_MESSAGE_HEADERS_MULTIPART => Self::Multipart,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for MessageHeadersType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_message_headers_type_get_type()) }
    }
}

impl glib::value::ValueType for MessageHeadersType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MessageHeadersType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MessageHeadersType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupMessagePriority")]
pub enum MessagePriority {
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_VERY_LOW")]
    VeryLow,
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_LOW")]
    Low,
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_NORMAL")]
    Normal,
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_HIGH")]
    High,
    #[doc(alias = "SOUP_MESSAGE_PRIORITY_VERY_HIGH")]
    VeryHigh,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MessagePriority {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "MessagePriority::{}", match *self {
            Self::VeryLow => "VeryLow",
            Self::Low => "Low",
            Self::Normal => "Normal",
            Self::High => "High",
            Self::VeryHigh => "VeryHigh",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for MessagePriority {
    type GlibType = ffi::SoupMessagePriority;

    fn into_glib(self) -> ffi::SoupMessagePriority {
        match self {
            Self::VeryLow => ffi::SOUP_MESSAGE_PRIORITY_VERY_LOW,
            Self::Low => ffi::SOUP_MESSAGE_PRIORITY_LOW,
            Self::Normal => ffi::SOUP_MESSAGE_PRIORITY_NORMAL,
            Self::High => ffi::SOUP_MESSAGE_PRIORITY_HIGH,
            Self::VeryHigh => ffi::SOUP_MESSAGE_PRIORITY_VERY_HIGH,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupMessagePriority> for MessagePriority {
    unsafe fn from_glib(value: ffi::SoupMessagePriority) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_MESSAGE_PRIORITY_VERY_LOW => Self::VeryLow,
            ffi::SOUP_MESSAGE_PRIORITY_LOW => Self::Low,
            ffi::SOUP_MESSAGE_PRIORITY_NORMAL => Self::Normal,
            ffi::SOUP_MESSAGE_PRIORITY_HIGH => Self::High,
            ffi::SOUP_MESSAGE_PRIORITY_VERY_HIGH => Self::VeryHigh,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for MessagePriority {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_message_priority_get_type()) }
    }
}

impl glib::value::ValueType for MessagePriority {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MessagePriority {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MessagePriority {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupRequestError")]
pub enum RequestError {
    #[doc(alias = "SOUP_REQUEST_ERROR_BAD_URI")]
    BadUri,
    #[doc(alias = "SOUP_REQUEST_ERROR_UNSUPPORTED_URI_SCHEME")]
    UnsupportedUriScheme,
    #[doc(alias = "SOUP_REQUEST_ERROR_PARSING")]
    Parsing,
    #[doc(alias = "SOUP_REQUEST_ERROR_ENCODING")]
    Encoding,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
impl fmt::Display for RequestError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "RequestError::{}", match *self {
            Self::BadUri => "BadUri",
            Self::UnsupportedUriScheme => "UnsupportedUriScheme",
            Self::Parsing => "Parsing",
            Self::Encoding => "Encoding",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
#[doc(hidden)]
impl IntoGlib for RequestError {
    type GlibType = ffi::SoupRequestError;

    fn into_glib(self) -> ffi::SoupRequestError {
        match self {
            Self::BadUri => ffi::SOUP_REQUEST_ERROR_BAD_URI,
            Self::UnsupportedUriScheme => ffi::SOUP_REQUEST_ERROR_UNSUPPORTED_URI_SCHEME,
            Self::Parsing => ffi::SOUP_REQUEST_ERROR_PARSING,
            Self::Encoding => ffi::SOUP_REQUEST_ERROR_ENCODING,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupRequestError> for RequestError {
    unsafe fn from_glib(value: ffi::SoupRequestError) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_REQUEST_ERROR_BAD_URI => Self::BadUri,
            ffi::SOUP_REQUEST_ERROR_UNSUPPORTED_URI_SCHEME => Self::UnsupportedUriScheme,
            ffi::SOUP_REQUEST_ERROR_PARSING => Self::Parsing,
            ffi::SOUP_REQUEST_ERROR_ENCODING => Self::Encoding,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
impl ErrorDomain for RequestError {
    fn domain() -> Quark {
        crate::skip_assert_initialized!();
        
        unsafe { from_glib(ffi::soup_request_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        crate::skip_assert_initialized!();
        match code {
            ffi::SOUP_REQUEST_ERROR_BAD_URI => Some(Self::BadUri),
            ffi::SOUP_REQUEST_ERROR_UNSUPPORTED_URI_SCHEME => Some(Self::UnsupportedUriScheme),
            ffi::SOUP_REQUEST_ERROR_PARSING => Some(Self::Parsing),
            ffi::SOUP_REQUEST_ERROR_ENCODING => Some(Self::Encoding),
            value => Some(Self::__Unknown(value)),
}
    }
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
impl StaticType for RequestError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_request_error_get_type()) }
    }
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
impl glib::value::ValueType for RequestError {
    type Type = Self;
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
unsafe impl<'a> FromValue<'a> for RequestError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
impl ToValue for RequestError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupRequesterError")]
pub enum RequesterError {
    #[doc(alias = "SOUP_REQUESTER_ERROR_BAD_URI")]
    BadUri,
    #[doc(alias = "SOUP_REQUESTER_ERROR_UNSUPPORTED_URI_SCHEME")]
    UnsupportedUriScheme,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RequesterError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "RequesterError::{}", match *self {
            Self::BadUri => "BadUri",
            Self::UnsupportedUriScheme => "UnsupportedUriScheme",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for RequesterError {
    type GlibType = ffi::SoupRequesterError;

    fn into_glib(self) -> ffi::SoupRequesterError {
        match self {
            Self::BadUri => ffi::SOUP_REQUESTER_ERROR_BAD_URI,
            Self::UnsupportedUriScheme => ffi::SOUP_REQUESTER_ERROR_UNSUPPORTED_URI_SCHEME,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupRequesterError> for RequesterError {
    unsafe fn from_glib(value: ffi::SoupRequesterError) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_REQUESTER_ERROR_BAD_URI => Self::BadUri,
            ffi::SOUP_REQUESTER_ERROR_UNSUPPORTED_URI_SCHEME => Self::UnsupportedUriScheme,
            value => Self::__Unknown(value),
}
    }
}

impl ErrorDomain for RequesterError {
    fn domain() -> Quark {
        crate::skip_assert_initialized!();
        
        unsafe { from_glib(ffi::soup_requester_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        crate::skip_assert_initialized!();
        match code {
            ffi::SOUP_REQUESTER_ERROR_BAD_URI => Some(Self::BadUri),
            ffi::SOUP_REQUESTER_ERROR_UNSUPPORTED_URI_SCHEME => Some(Self::UnsupportedUriScheme),
            value => Some(Self::__Unknown(value)),
}
    }
}

impl StaticType for RequesterError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_requester_error_get_type()) }
    }
}

impl glib::value::ValueType for RequesterError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RequesterError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RequesterError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_70", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupSameSitePolicy")]
pub enum SameSitePolicy {
    #[doc(alias = "SOUP_SAME_SITE_POLICY_NONE")]
    None,
    #[doc(alias = "SOUP_SAME_SITE_POLICY_LAX")]
    Lax,
    #[doc(alias = "SOUP_SAME_SITE_POLICY_STRICT")]
    Strict,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_70", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
impl fmt::Display for SameSitePolicy {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "SameSitePolicy::{}", match *self {
            Self::None => "None",
            Self::Lax => "Lax",
            Self::Strict => "Strict",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_70", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
#[doc(hidden)]
impl IntoGlib for SameSitePolicy {
    type GlibType = ffi::SoupSameSitePolicy;

    fn into_glib(self) -> ffi::SoupSameSitePolicy {
        match self {
            Self::None => ffi::SOUP_SAME_SITE_POLICY_NONE,
            Self::Lax => ffi::SOUP_SAME_SITE_POLICY_LAX,
            Self::Strict => ffi::SOUP_SAME_SITE_POLICY_STRICT,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_70", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupSameSitePolicy> for SameSitePolicy {
    unsafe fn from_glib(value: ffi::SoupSameSitePolicy) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_SAME_SITE_POLICY_NONE => Self::None,
            ffi::SOUP_SAME_SITE_POLICY_LAX => Self::Lax,
            ffi::SOUP_SAME_SITE_POLICY_STRICT => Self::Strict,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_70", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
impl StaticType for SameSitePolicy {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_same_site_policy_get_type()) }
    }
}

#[cfg(any(feature = "v2_70", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
impl glib::value::ValueType for SameSitePolicy {
    type Type = Self;
}

#[cfg(any(feature = "v2_70", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
unsafe impl<'a> FromValue<'a> for SameSitePolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_70", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
impl ToValue for SameSitePolicy {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupSocketIOStatus")]
pub enum SocketIOStatus {
    #[doc(alias = "SOUP_SOCKET_OK")]
    Ok,
    #[doc(alias = "SOUP_SOCKET_WOULD_BLOCK")]
    WouldBlock,
    #[doc(alias = "SOUP_SOCKET_EOF")]
    Eof,
    #[doc(alias = "SOUP_SOCKET_ERROR")]
    Error,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SocketIOStatus {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "SocketIOStatus::{}", match *self {
            Self::Ok => "Ok",
            Self::WouldBlock => "WouldBlock",
            Self::Eof => "Eof",
            Self::Error => "Error",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for SocketIOStatus {
    type GlibType = ffi::SoupSocketIOStatus;

    fn into_glib(self) -> ffi::SoupSocketIOStatus {
        match self {
            Self::Ok => ffi::SOUP_SOCKET_OK,
            Self::WouldBlock => ffi::SOUP_SOCKET_WOULD_BLOCK,
            Self::Eof => ffi::SOUP_SOCKET_EOF,
            Self::Error => ffi::SOUP_SOCKET_ERROR,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupSocketIOStatus> for SocketIOStatus {
    unsafe fn from_glib(value: ffi::SoupSocketIOStatus) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_SOCKET_OK => Self::Ok,
            ffi::SOUP_SOCKET_WOULD_BLOCK => Self::WouldBlock,
            ffi::SOUP_SOCKET_EOF => Self::Eof,
            ffi::SOUP_SOCKET_ERROR => Self::Error,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for SocketIOStatus {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_socket_io_status_get_type()) }
    }
}

impl glib::value::ValueType for SocketIOStatus {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SocketIOStatus {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SocketIOStatus {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupStatus")]
pub enum Status {
    #[doc(alias = "SOUP_STATUS_NONE")]
    None,
    #[doc(alias = "SOUP_STATUS_CANCELLED")]
    Cancelled,
    #[doc(alias = "SOUP_STATUS_CANT_RESOLVE")]
    CantResolve,
    #[doc(alias = "SOUP_STATUS_CANT_RESOLVE_PROXY")]
    CantResolveProxy,
    #[doc(alias = "SOUP_STATUS_CANT_CONNECT")]
    CantConnect,
    #[doc(alias = "SOUP_STATUS_CANT_CONNECT_PROXY")]
    CantConnectProxy,
    #[doc(alias = "SOUP_STATUS_SSL_FAILED")]
    SslFailed,
    #[doc(alias = "SOUP_STATUS_IO_ERROR")]
    IoError,
    #[doc(alias = "SOUP_STATUS_MALFORMED")]
    Malformed,
    #[doc(alias = "SOUP_STATUS_TRY_AGAIN")]
    TryAgain,
    #[doc(alias = "SOUP_STATUS_TOO_MANY_REDIRECTS")]
    TooManyRedirects,
    #[doc(alias = "SOUP_STATUS_TLS_FAILED")]
    TlsFailed,
    #[doc(alias = "SOUP_STATUS_CONTINUE")]
    Continue,
    #[doc(alias = "SOUP_STATUS_SWITCHING_PROTOCOLS")]
    SwitchingProtocols,
    #[doc(alias = "SOUP_STATUS_PROCESSING")]
    Processing,
    #[doc(alias = "SOUP_STATUS_OK")]
    Ok,
    #[doc(alias = "SOUP_STATUS_CREATED")]
    Created,
    #[doc(alias = "SOUP_STATUS_ACCEPTED")]
    Accepted,
    #[doc(alias = "SOUP_STATUS_NON_AUTHORITATIVE")]
    NonAuthoritative,
    #[doc(alias = "SOUP_STATUS_NO_CONTENT")]
    NoContent,
    #[doc(alias = "SOUP_STATUS_RESET_CONTENT")]
    ResetContent,
    #[doc(alias = "SOUP_STATUS_PARTIAL_CONTENT")]
    PartialContent,
    #[doc(alias = "SOUP_STATUS_MULTI_STATUS")]
    MultiStatus,
    #[doc(alias = "SOUP_STATUS_MULTIPLE_CHOICES")]
    MultipleChoices,
    #[doc(alias = "SOUP_STATUS_MOVED_PERMANENTLY")]
    MovedPermanently,
    #[doc(alias = "SOUP_STATUS_FOUND")]
    Found,
    #[doc(alias = "SOUP_STATUS_SEE_OTHER")]
    SeeOther,
    #[doc(alias = "SOUP_STATUS_NOT_MODIFIED")]
    NotModified,
    #[doc(alias = "SOUP_STATUS_USE_PROXY")]
    UseProxy,
    #[doc(alias = "SOUP_STATUS_NOT_APPEARING_IN_THIS_PROTOCOL")]
    NotAppearingInThisProtocol,
    #[doc(alias = "SOUP_STATUS_TEMPORARY_REDIRECT")]
    TemporaryRedirect,
    #[doc(alias = "SOUP_STATUS_PERMANENT_REDIRECT")]
    PermanentRedirect,
    #[doc(alias = "SOUP_STATUS_BAD_REQUEST")]
    BadRequest,
    #[doc(alias = "SOUP_STATUS_UNAUTHORIZED")]
    Unauthorized,
    #[doc(alias = "SOUP_STATUS_PAYMENT_REQUIRED")]
    PaymentRequired,
    #[doc(alias = "SOUP_STATUS_FORBIDDEN")]
    Forbidden,
    #[doc(alias = "SOUP_STATUS_NOT_FOUND")]
    NotFound,
    #[doc(alias = "SOUP_STATUS_METHOD_NOT_ALLOWED")]
    MethodNotAllowed,
    #[doc(alias = "SOUP_STATUS_NOT_ACCEPTABLE")]
    NotAcceptable,
    #[doc(alias = "SOUP_STATUS_PROXY_AUTHENTICATION_REQUIRED")]
    ProxyAuthenticationRequired,
    #[doc(alias = "SOUP_STATUS_REQUEST_TIMEOUT")]
    RequestTimeout,
    #[doc(alias = "SOUP_STATUS_CONFLICT")]
    Conflict,
    #[doc(alias = "SOUP_STATUS_GONE")]
    Gone,
    #[doc(alias = "SOUP_STATUS_LENGTH_REQUIRED")]
    LengthRequired,
    #[doc(alias = "SOUP_STATUS_PRECONDITION_FAILED")]
    PreconditionFailed,
    #[doc(alias = "SOUP_STATUS_REQUEST_ENTITY_TOO_LARGE")]
    RequestEntityTooLarge,
    #[doc(alias = "SOUP_STATUS_REQUEST_URI_TOO_LONG")]
    RequestUriTooLong,
    #[doc(alias = "SOUP_STATUS_UNSUPPORTED_MEDIA_TYPE")]
    UnsupportedMediaType,
    #[doc(alias = "SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE")]
    RequestedRangeNotSatisfiable,
    #[doc(alias = "SOUP_STATUS_EXPECTATION_FAILED")]
    ExpectationFailed,
    #[doc(alias = "SOUP_STATUS_UNPROCESSABLE_ENTITY")]
    UnprocessableEntity,
    #[doc(alias = "SOUP_STATUS_LOCKED")]
    Locked,
    #[doc(alias = "SOUP_STATUS_FAILED_DEPENDENCY")]
    FailedDependency,
    #[doc(alias = "SOUP_STATUS_INTERNAL_SERVER_ERROR")]
    InternalServerError,
    #[doc(alias = "SOUP_STATUS_NOT_IMPLEMENTED")]
    NotImplemented,
    #[doc(alias = "SOUP_STATUS_BAD_GATEWAY")]
    BadGateway,
    #[doc(alias = "SOUP_STATUS_SERVICE_UNAVAILABLE")]
    ServiceUnavailable,
    #[doc(alias = "SOUP_STATUS_GATEWAY_TIMEOUT")]
    GatewayTimeout,
    #[doc(alias = "SOUP_STATUS_HTTP_VERSION_NOT_SUPPORTED")]
    HttpVersionNotSupported,
    #[doc(alias = "SOUP_STATUS_INSUFFICIENT_STORAGE")]
    InsufficientStorage,
    #[doc(alias = "SOUP_STATUS_NOT_EXTENDED")]
    NotExtended,
#[doc(hidden)]
    __Unknown(i32),
}

impl Status {
    #[doc(alias = "soup_status_get_phrase")]
    #[doc(alias = "get_phrase")]
    pub fn phrase(status_code: u32) -> Option<glib::GString> {
        crate::assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::soup_status_get_phrase(status_code))
        }
    }

    #[cfg(any(feature = "v2_26", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_26")))]
    #[doc(alias = "soup_status_proxify")]
    pub fn proxify(status_code: u32) -> u32 {
        crate::assert_initialized_main_thread!();
        unsafe {
            ffi::soup_status_proxify(status_code)
        }
    }
}

impl fmt::Display for Status {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Status::{}", match *self {
            Self::None => "None",
            Self::Cancelled => "Cancelled",
            Self::CantResolve => "CantResolve",
            Self::CantResolveProxy => "CantResolveProxy",
            Self::CantConnect => "CantConnect",
            Self::CantConnectProxy => "CantConnectProxy",
            Self::SslFailed => "SslFailed",
            Self::IoError => "IoError",
            Self::Malformed => "Malformed",
            Self::TryAgain => "TryAgain",
            Self::TooManyRedirects => "TooManyRedirects",
            Self::TlsFailed => "TlsFailed",
            Self::Continue => "Continue",
            Self::SwitchingProtocols => "SwitchingProtocols",
            Self::Processing => "Processing",
            Self::Ok => "Ok",
            Self::Created => "Created",
            Self::Accepted => "Accepted",
            Self::NonAuthoritative => "NonAuthoritative",
            Self::NoContent => "NoContent",
            Self::ResetContent => "ResetContent",
            Self::PartialContent => "PartialContent",
            Self::MultiStatus => "MultiStatus",
            Self::MultipleChoices => "MultipleChoices",
            Self::MovedPermanently => "MovedPermanently",
            Self::Found => "Found",
            Self::SeeOther => "SeeOther",
            Self::NotModified => "NotModified",
            Self::UseProxy => "UseProxy",
            Self::NotAppearingInThisProtocol => "NotAppearingInThisProtocol",
            Self::TemporaryRedirect => "TemporaryRedirect",
            Self::PermanentRedirect => "PermanentRedirect",
            Self::BadRequest => "BadRequest",
            Self::Unauthorized => "Unauthorized",
            Self::PaymentRequired => "PaymentRequired",
            Self::Forbidden => "Forbidden",
            Self::NotFound => "NotFound",
            Self::MethodNotAllowed => "MethodNotAllowed",
            Self::NotAcceptable => "NotAcceptable",
            Self::ProxyAuthenticationRequired => "ProxyAuthenticationRequired",
            Self::RequestTimeout => "RequestTimeout",
            Self::Conflict => "Conflict",
            Self::Gone => "Gone",
            Self::LengthRequired => "LengthRequired",
            Self::PreconditionFailed => "PreconditionFailed",
            Self::RequestEntityTooLarge => "RequestEntityTooLarge",
            Self::RequestUriTooLong => "RequestUriTooLong",
            Self::UnsupportedMediaType => "UnsupportedMediaType",
            Self::RequestedRangeNotSatisfiable => "RequestedRangeNotSatisfiable",
            Self::ExpectationFailed => "ExpectationFailed",
            Self::UnprocessableEntity => "UnprocessableEntity",
            Self::Locked => "Locked",
            Self::FailedDependency => "FailedDependency",
            Self::InternalServerError => "InternalServerError",
            Self::NotImplemented => "NotImplemented",
            Self::BadGateway => "BadGateway",
            Self::ServiceUnavailable => "ServiceUnavailable",
            Self::GatewayTimeout => "GatewayTimeout",
            Self::HttpVersionNotSupported => "HttpVersionNotSupported",
            Self::InsufficientStorage => "InsufficientStorage",
            Self::NotExtended => "NotExtended",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for Status {
    type GlibType = ffi::SoupStatus;

    fn into_glib(self) -> ffi::SoupStatus {
        match self {
            Self::None => ffi::SOUP_STATUS_NONE,
            Self::Cancelled => ffi::SOUP_STATUS_CANCELLED,
            Self::CantResolve => ffi::SOUP_STATUS_CANT_RESOLVE,
            Self::CantResolveProxy => ffi::SOUP_STATUS_CANT_RESOLVE_PROXY,
            Self::CantConnect => ffi::SOUP_STATUS_CANT_CONNECT,
            Self::CantConnectProxy => ffi::SOUP_STATUS_CANT_CONNECT_PROXY,
            Self::SslFailed => ffi::SOUP_STATUS_SSL_FAILED,
            Self::IoError => ffi::SOUP_STATUS_IO_ERROR,
            Self::Malformed => ffi::SOUP_STATUS_MALFORMED,
            Self::TryAgain => ffi::SOUP_STATUS_TRY_AGAIN,
            Self::TooManyRedirects => ffi::SOUP_STATUS_TOO_MANY_REDIRECTS,
            Self::TlsFailed => ffi::SOUP_STATUS_TLS_FAILED,
            Self::Continue => ffi::SOUP_STATUS_CONTINUE,
            Self::SwitchingProtocols => ffi::SOUP_STATUS_SWITCHING_PROTOCOLS,
            Self::Processing => ffi::SOUP_STATUS_PROCESSING,
            Self::Ok => ffi::SOUP_STATUS_OK,
            Self::Created => ffi::SOUP_STATUS_CREATED,
            Self::Accepted => ffi::SOUP_STATUS_ACCEPTED,
            Self::NonAuthoritative => ffi::SOUP_STATUS_NON_AUTHORITATIVE,
            Self::NoContent => ffi::SOUP_STATUS_NO_CONTENT,
            Self::ResetContent => ffi::SOUP_STATUS_RESET_CONTENT,
            Self::PartialContent => ffi::SOUP_STATUS_PARTIAL_CONTENT,
            Self::MultiStatus => ffi::SOUP_STATUS_MULTI_STATUS,
            Self::MultipleChoices => ffi::SOUP_STATUS_MULTIPLE_CHOICES,
            Self::MovedPermanently => ffi::SOUP_STATUS_MOVED_PERMANENTLY,
            Self::Found => ffi::SOUP_STATUS_FOUND,
            Self::SeeOther => ffi::SOUP_STATUS_SEE_OTHER,
            Self::NotModified => ffi::SOUP_STATUS_NOT_MODIFIED,
            Self::UseProxy => ffi::SOUP_STATUS_USE_PROXY,
            Self::NotAppearingInThisProtocol => ffi::SOUP_STATUS_NOT_APPEARING_IN_THIS_PROTOCOL,
            Self::TemporaryRedirect => ffi::SOUP_STATUS_TEMPORARY_REDIRECT,
            Self::PermanentRedirect => ffi::SOUP_STATUS_PERMANENT_REDIRECT,
            Self::BadRequest => ffi::SOUP_STATUS_BAD_REQUEST,
            Self::Unauthorized => ffi::SOUP_STATUS_UNAUTHORIZED,
            Self::PaymentRequired => ffi::SOUP_STATUS_PAYMENT_REQUIRED,
            Self::Forbidden => ffi::SOUP_STATUS_FORBIDDEN,
            Self::NotFound => ffi::SOUP_STATUS_NOT_FOUND,
            Self::MethodNotAllowed => ffi::SOUP_STATUS_METHOD_NOT_ALLOWED,
            Self::NotAcceptable => ffi::SOUP_STATUS_NOT_ACCEPTABLE,
            Self::ProxyAuthenticationRequired => ffi::SOUP_STATUS_PROXY_AUTHENTICATION_REQUIRED,
            Self::RequestTimeout => ffi::SOUP_STATUS_REQUEST_TIMEOUT,
            Self::Conflict => ffi::SOUP_STATUS_CONFLICT,
            Self::Gone => ffi::SOUP_STATUS_GONE,
            Self::LengthRequired => ffi::SOUP_STATUS_LENGTH_REQUIRED,
            Self::PreconditionFailed => ffi::SOUP_STATUS_PRECONDITION_FAILED,
            Self::RequestEntityTooLarge => ffi::SOUP_STATUS_REQUEST_ENTITY_TOO_LARGE,
            Self::RequestUriTooLong => ffi::SOUP_STATUS_REQUEST_URI_TOO_LONG,
            Self::UnsupportedMediaType => ffi::SOUP_STATUS_UNSUPPORTED_MEDIA_TYPE,
            Self::RequestedRangeNotSatisfiable => ffi::SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE,
            Self::ExpectationFailed => ffi::SOUP_STATUS_EXPECTATION_FAILED,
            Self::UnprocessableEntity => ffi::SOUP_STATUS_UNPROCESSABLE_ENTITY,
            Self::Locked => ffi::SOUP_STATUS_LOCKED,
            Self::FailedDependency => ffi::SOUP_STATUS_FAILED_DEPENDENCY,
            Self::InternalServerError => ffi::SOUP_STATUS_INTERNAL_SERVER_ERROR,
            Self::NotImplemented => ffi::SOUP_STATUS_NOT_IMPLEMENTED,
            Self::BadGateway => ffi::SOUP_STATUS_BAD_GATEWAY,
            Self::ServiceUnavailable => ffi::SOUP_STATUS_SERVICE_UNAVAILABLE,
            Self::GatewayTimeout => ffi::SOUP_STATUS_GATEWAY_TIMEOUT,
            Self::HttpVersionNotSupported => ffi::SOUP_STATUS_HTTP_VERSION_NOT_SUPPORTED,
            Self::InsufficientStorage => ffi::SOUP_STATUS_INSUFFICIENT_STORAGE,
            Self::NotExtended => ffi::SOUP_STATUS_NOT_EXTENDED,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupStatus> for Status {
    unsafe fn from_glib(value: ffi::SoupStatus) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_STATUS_NONE => Self::None,
            ffi::SOUP_STATUS_CANCELLED => Self::Cancelled,
            ffi::SOUP_STATUS_CANT_RESOLVE => Self::CantResolve,
            ffi::SOUP_STATUS_CANT_RESOLVE_PROXY => Self::CantResolveProxy,
            ffi::SOUP_STATUS_CANT_CONNECT => Self::CantConnect,
            ffi::SOUP_STATUS_CANT_CONNECT_PROXY => Self::CantConnectProxy,
            ffi::SOUP_STATUS_SSL_FAILED => Self::SslFailed,
            ffi::SOUP_STATUS_IO_ERROR => Self::IoError,
            ffi::SOUP_STATUS_MALFORMED => Self::Malformed,
            ffi::SOUP_STATUS_TRY_AGAIN => Self::TryAgain,
            ffi::SOUP_STATUS_TOO_MANY_REDIRECTS => Self::TooManyRedirects,
            ffi::SOUP_STATUS_TLS_FAILED => Self::TlsFailed,
            ffi::SOUP_STATUS_CONTINUE => Self::Continue,
            ffi::SOUP_STATUS_SWITCHING_PROTOCOLS => Self::SwitchingProtocols,
            ffi::SOUP_STATUS_PROCESSING => Self::Processing,
            ffi::SOUP_STATUS_OK => Self::Ok,
            ffi::SOUP_STATUS_CREATED => Self::Created,
            ffi::SOUP_STATUS_ACCEPTED => Self::Accepted,
            ffi::SOUP_STATUS_NON_AUTHORITATIVE => Self::NonAuthoritative,
            ffi::SOUP_STATUS_NO_CONTENT => Self::NoContent,
            ffi::SOUP_STATUS_RESET_CONTENT => Self::ResetContent,
            ffi::SOUP_STATUS_PARTIAL_CONTENT => Self::PartialContent,
            ffi::SOUP_STATUS_MULTI_STATUS => Self::MultiStatus,
            ffi::SOUP_STATUS_MULTIPLE_CHOICES => Self::MultipleChoices,
            ffi::SOUP_STATUS_MOVED_PERMANENTLY => Self::MovedPermanently,
            ffi::SOUP_STATUS_FOUND => Self::Found,
            ffi::SOUP_STATUS_SEE_OTHER => Self::SeeOther,
            ffi::SOUP_STATUS_NOT_MODIFIED => Self::NotModified,
            ffi::SOUP_STATUS_USE_PROXY => Self::UseProxy,
            ffi::SOUP_STATUS_NOT_APPEARING_IN_THIS_PROTOCOL => Self::NotAppearingInThisProtocol,
            ffi::SOUP_STATUS_TEMPORARY_REDIRECT => Self::TemporaryRedirect,
            ffi::SOUP_STATUS_PERMANENT_REDIRECT => Self::PermanentRedirect,
            ffi::SOUP_STATUS_BAD_REQUEST => Self::BadRequest,
            ffi::SOUP_STATUS_UNAUTHORIZED => Self::Unauthorized,
            ffi::SOUP_STATUS_PAYMENT_REQUIRED => Self::PaymentRequired,
            ffi::SOUP_STATUS_FORBIDDEN => Self::Forbidden,
            ffi::SOUP_STATUS_NOT_FOUND => Self::NotFound,
            ffi::SOUP_STATUS_METHOD_NOT_ALLOWED => Self::MethodNotAllowed,
            ffi::SOUP_STATUS_NOT_ACCEPTABLE => Self::NotAcceptable,
            ffi::SOUP_STATUS_PROXY_AUTHENTICATION_REQUIRED => Self::ProxyAuthenticationRequired,
            ffi::SOUP_STATUS_REQUEST_TIMEOUT => Self::RequestTimeout,
            ffi::SOUP_STATUS_CONFLICT => Self::Conflict,
            ffi::SOUP_STATUS_GONE => Self::Gone,
            ffi::SOUP_STATUS_LENGTH_REQUIRED => Self::LengthRequired,
            ffi::SOUP_STATUS_PRECONDITION_FAILED => Self::PreconditionFailed,
            ffi::SOUP_STATUS_REQUEST_ENTITY_TOO_LARGE => Self::RequestEntityTooLarge,
            ffi::SOUP_STATUS_REQUEST_URI_TOO_LONG => Self::RequestUriTooLong,
            ffi::SOUP_STATUS_UNSUPPORTED_MEDIA_TYPE => Self::UnsupportedMediaType,
            ffi::SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE => Self::RequestedRangeNotSatisfiable,
            ffi::SOUP_STATUS_EXPECTATION_FAILED => Self::ExpectationFailed,
            ffi::SOUP_STATUS_UNPROCESSABLE_ENTITY => Self::UnprocessableEntity,
            ffi::SOUP_STATUS_LOCKED => Self::Locked,
            ffi::SOUP_STATUS_FAILED_DEPENDENCY => Self::FailedDependency,
            ffi::SOUP_STATUS_INTERNAL_SERVER_ERROR => Self::InternalServerError,
            ffi::SOUP_STATUS_NOT_IMPLEMENTED => Self::NotImplemented,
            ffi::SOUP_STATUS_BAD_GATEWAY => Self::BadGateway,
            ffi::SOUP_STATUS_SERVICE_UNAVAILABLE => Self::ServiceUnavailable,
            ffi::SOUP_STATUS_GATEWAY_TIMEOUT => Self::GatewayTimeout,
            ffi::SOUP_STATUS_HTTP_VERSION_NOT_SUPPORTED => Self::HttpVersionNotSupported,
            ffi::SOUP_STATUS_INSUFFICIENT_STORAGE => Self::InsufficientStorage,
            ffi::SOUP_STATUS_NOT_EXTENDED => Self::NotExtended,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for Status {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_status_get_type()) }
    }
}

impl glib::value::ValueType for Status {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Status {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Status {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupTLDError")]
pub enum TLDError {
    #[doc(alias = "SOUP_TLD_ERROR_INVALID_HOSTNAME")]
    InvalidHostname,
    #[doc(alias = "SOUP_TLD_ERROR_IS_IP_ADDRESS")]
    IsIpAddress,
    #[doc(alias = "SOUP_TLD_ERROR_NOT_ENOUGH_DOMAINS")]
    NotEnoughDomains,
    #[doc(alias = "SOUP_TLD_ERROR_NO_BASE_DOMAIN")]
    NoBaseDomain,
    #[doc(alias = "SOUP_TLD_ERROR_NO_PSL_DATA")]
    NoPslData,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
impl fmt::Display for TLDError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TLDError::{}", match *self {
            Self::InvalidHostname => "InvalidHostname",
            Self::IsIpAddress => "IsIpAddress",
            Self::NotEnoughDomains => "NotEnoughDomains",
            Self::NoBaseDomain => "NoBaseDomain",
            Self::NoPslData => "NoPslData",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
#[doc(hidden)]
impl IntoGlib for TLDError {
    type GlibType = ffi::SoupTLDError;

    fn into_glib(self) -> ffi::SoupTLDError {
        match self {
            Self::InvalidHostname => ffi::SOUP_TLD_ERROR_INVALID_HOSTNAME,
            Self::IsIpAddress => ffi::SOUP_TLD_ERROR_IS_IP_ADDRESS,
            Self::NotEnoughDomains => ffi::SOUP_TLD_ERROR_NOT_ENOUGH_DOMAINS,
            Self::NoBaseDomain => ffi::SOUP_TLD_ERROR_NO_BASE_DOMAIN,
            Self::NoPslData => ffi::SOUP_TLD_ERROR_NO_PSL_DATA,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupTLDError> for TLDError {
    unsafe fn from_glib(value: ffi::SoupTLDError) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_TLD_ERROR_INVALID_HOSTNAME => Self::InvalidHostname,
            ffi::SOUP_TLD_ERROR_IS_IP_ADDRESS => Self::IsIpAddress,
            ffi::SOUP_TLD_ERROR_NOT_ENOUGH_DOMAINS => Self::NotEnoughDomains,
            ffi::SOUP_TLD_ERROR_NO_BASE_DOMAIN => Self::NoBaseDomain,
            ffi::SOUP_TLD_ERROR_NO_PSL_DATA => Self::NoPslData,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
impl ErrorDomain for TLDError {
    fn domain() -> Quark {
        crate::skip_assert_initialized!();
        
        unsafe { from_glib(ffi::soup_tld_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        crate::skip_assert_initialized!();
        match code {
            ffi::SOUP_TLD_ERROR_INVALID_HOSTNAME => Some(Self::InvalidHostname),
            ffi::SOUP_TLD_ERROR_IS_IP_ADDRESS => Some(Self::IsIpAddress),
            ffi::SOUP_TLD_ERROR_NOT_ENOUGH_DOMAINS => Some(Self::NotEnoughDomains),
            ffi::SOUP_TLD_ERROR_NO_BASE_DOMAIN => Some(Self::NoBaseDomain),
            ffi::SOUP_TLD_ERROR_NO_PSL_DATA => Some(Self::NoPslData),
            value => Some(Self::__Unknown(value)),
}
    }
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
impl StaticType for TLDError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_tld_error_get_type()) }
    }
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
impl glib::value::ValueType for TLDError {
    type Type = Self;
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
unsafe impl<'a> FromValue<'a> for TLDError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_40", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
impl ToValue for TLDError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketCloseCode")]
pub enum WebsocketCloseCode {
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_NORMAL")]
    Normal,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_GOING_AWAY")]
    GoingAway,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_PROTOCOL_ERROR")]
    ProtocolError,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_UNSUPPORTED_DATA")]
    UnsupportedData,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_NO_STATUS")]
    NoStatus,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_ABNORMAL")]
    Abnormal,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_BAD_DATA")]
    BadData,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_POLICY_VIOLATION")]
    PolicyViolation,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_TOO_BIG")]
    TooBig,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_NO_EXTENSION")]
    NoExtension,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_SERVER_ERROR")]
    ServerError,
    #[doc(alias = "SOUP_WEBSOCKET_CLOSE_TLS_HANDSHAKE")]
    TlsHandshake,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl fmt::Display for WebsocketCloseCode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "WebsocketCloseCode::{}", match *self {
            Self::Normal => "Normal",
            Self::GoingAway => "GoingAway",
            Self::ProtocolError => "ProtocolError",
            Self::UnsupportedData => "UnsupportedData",
            Self::NoStatus => "NoStatus",
            Self::Abnormal => "Abnormal",
            Self::BadData => "BadData",
            Self::PolicyViolation => "PolicyViolation",
            Self::TooBig => "TooBig",
            Self::NoExtension => "NoExtension",
            Self::ServerError => "ServerError",
            Self::TlsHandshake => "TlsHandshake",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl IntoGlib for WebsocketCloseCode {
    type GlibType = ffi::SoupWebsocketCloseCode;

    fn into_glib(self) -> ffi::SoupWebsocketCloseCode {
        match self {
            Self::Normal => ffi::SOUP_WEBSOCKET_CLOSE_NORMAL,
            Self::GoingAway => ffi::SOUP_WEBSOCKET_CLOSE_GOING_AWAY,
            Self::ProtocolError => ffi::SOUP_WEBSOCKET_CLOSE_PROTOCOL_ERROR,
            Self::UnsupportedData => ffi::SOUP_WEBSOCKET_CLOSE_UNSUPPORTED_DATA,
            Self::NoStatus => ffi::SOUP_WEBSOCKET_CLOSE_NO_STATUS,
            Self::Abnormal => ffi::SOUP_WEBSOCKET_CLOSE_ABNORMAL,
            Self::BadData => ffi::SOUP_WEBSOCKET_CLOSE_BAD_DATA,
            Self::PolicyViolation => ffi::SOUP_WEBSOCKET_CLOSE_POLICY_VIOLATION,
            Self::TooBig => ffi::SOUP_WEBSOCKET_CLOSE_TOO_BIG,
            Self::NoExtension => ffi::SOUP_WEBSOCKET_CLOSE_NO_EXTENSION,
            Self::ServerError => ffi::SOUP_WEBSOCKET_CLOSE_SERVER_ERROR,
            Self::TlsHandshake => ffi::SOUP_WEBSOCKET_CLOSE_TLS_HANDSHAKE,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketCloseCode> for WebsocketCloseCode {
    unsafe fn from_glib(value: ffi::SoupWebsocketCloseCode) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_CLOSE_NORMAL => Self::Normal,
            ffi::SOUP_WEBSOCKET_CLOSE_GOING_AWAY => Self::GoingAway,
            ffi::SOUP_WEBSOCKET_CLOSE_PROTOCOL_ERROR => Self::ProtocolError,
            ffi::SOUP_WEBSOCKET_CLOSE_UNSUPPORTED_DATA => Self::UnsupportedData,
            ffi::SOUP_WEBSOCKET_CLOSE_NO_STATUS => Self::NoStatus,
            ffi::SOUP_WEBSOCKET_CLOSE_ABNORMAL => Self::Abnormal,
            ffi::SOUP_WEBSOCKET_CLOSE_BAD_DATA => Self::BadData,
            ffi::SOUP_WEBSOCKET_CLOSE_POLICY_VIOLATION => Self::PolicyViolation,
            ffi::SOUP_WEBSOCKET_CLOSE_TOO_BIG => Self::TooBig,
            ffi::SOUP_WEBSOCKET_CLOSE_NO_EXTENSION => Self::NoExtension,
            ffi::SOUP_WEBSOCKET_CLOSE_SERVER_ERROR => Self::ServerError,
            ffi::SOUP_WEBSOCKET_CLOSE_TLS_HANDSHAKE => Self::TlsHandshake,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl StaticType for WebsocketCloseCode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_close_code_get_type()) }
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl glib::value::ValueType for WebsocketCloseCode {
    type Type = Self;
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
unsafe impl<'a> FromValue<'a> for WebsocketCloseCode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl ToValue for WebsocketCloseCode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketConnectionType")]
pub enum WebsocketConnectionType {
    #[doc(alias = "SOUP_WEBSOCKET_CONNECTION_UNKNOWN")]
    Unknown,
    #[doc(alias = "SOUP_WEBSOCKET_CONNECTION_CLIENT")]
    Client,
    #[doc(alias = "SOUP_WEBSOCKET_CONNECTION_SERVER")]
    Server,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl fmt::Display for WebsocketConnectionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "WebsocketConnectionType::{}", match *self {
            Self::Unknown => "Unknown",
            Self::Client => "Client",
            Self::Server => "Server",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl IntoGlib for WebsocketConnectionType {
    type GlibType = ffi::SoupWebsocketConnectionType;

    fn into_glib(self) -> ffi::SoupWebsocketConnectionType {
        match self {
            Self::Unknown => ffi::SOUP_WEBSOCKET_CONNECTION_UNKNOWN,
            Self::Client => ffi::SOUP_WEBSOCKET_CONNECTION_CLIENT,
            Self::Server => ffi::SOUP_WEBSOCKET_CONNECTION_SERVER,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketConnectionType> for WebsocketConnectionType {
    unsafe fn from_glib(value: ffi::SoupWebsocketConnectionType) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_CONNECTION_UNKNOWN => Self::Unknown,
            ffi::SOUP_WEBSOCKET_CONNECTION_CLIENT => Self::Client,
            ffi::SOUP_WEBSOCKET_CONNECTION_SERVER => Self::Server,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl StaticType for WebsocketConnectionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_connection_type_get_type()) }
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl glib::value::ValueType for WebsocketConnectionType {
    type Type = Self;
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
unsafe impl<'a> FromValue<'a> for WebsocketConnectionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl ToValue for WebsocketConnectionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketDataType")]
pub enum WebsocketDataType {
    #[doc(alias = "SOUP_WEBSOCKET_DATA_TEXT")]
    Text,
    #[doc(alias = "SOUP_WEBSOCKET_DATA_BINARY")]
    Binary,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl fmt::Display for WebsocketDataType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "WebsocketDataType::{}", match *self {
            Self::Text => "Text",
            Self::Binary => "Binary",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl IntoGlib for WebsocketDataType {
    type GlibType = ffi::SoupWebsocketDataType;

    fn into_glib(self) -> ffi::SoupWebsocketDataType {
        match self {
            Self::Text => ffi::SOUP_WEBSOCKET_DATA_TEXT,
            Self::Binary => ffi::SOUP_WEBSOCKET_DATA_BINARY,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketDataType> for WebsocketDataType {
    unsafe fn from_glib(value: ffi::SoupWebsocketDataType) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_DATA_TEXT => Self::Text,
            ffi::SOUP_WEBSOCKET_DATA_BINARY => Self::Binary,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl StaticType for WebsocketDataType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_data_type_get_type()) }
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl glib::value::ValueType for WebsocketDataType {
    type Type = Self;
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
unsafe impl<'a> FromValue<'a> for WebsocketDataType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl ToValue for WebsocketDataType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketError")]
pub enum WebsocketError {
    #[doc(alias = "SOUP_WEBSOCKET_ERROR_FAILED")]
    Failed,
    #[doc(alias = "SOUP_WEBSOCKET_ERROR_NOT_WEBSOCKET")]
    NotWebsocket,
    #[doc(alias = "SOUP_WEBSOCKET_ERROR_BAD_HANDSHAKE")]
    BadHandshake,
    #[doc(alias = "SOUP_WEBSOCKET_ERROR_BAD_ORIGIN")]
    BadOrigin,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl WebsocketError {
    #[doc(alias = "soup_websocket_error_get_quark")]
    #[doc(alias = "get_quark")]
    pub fn quark() -> glib::Quark {
        crate::assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::soup_websocket_error_get_quark())
        }
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl fmt::Display for WebsocketError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "WebsocketError::{}", match *self {
            Self::Failed => "Failed",
            Self::NotWebsocket => "NotWebsocket",
            Self::BadHandshake => "BadHandshake",
            Self::BadOrigin => "BadOrigin",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl IntoGlib for WebsocketError {
    type GlibType = ffi::SoupWebsocketError;

    fn into_glib(self) -> ffi::SoupWebsocketError {
        match self {
            Self::Failed => ffi::SOUP_WEBSOCKET_ERROR_FAILED,
            Self::NotWebsocket => ffi::SOUP_WEBSOCKET_ERROR_NOT_WEBSOCKET,
            Self::BadHandshake => ffi::SOUP_WEBSOCKET_ERROR_BAD_HANDSHAKE,
            Self::BadOrigin => ffi::SOUP_WEBSOCKET_ERROR_BAD_ORIGIN,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketError> for WebsocketError {
    unsafe fn from_glib(value: ffi::SoupWebsocketError) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_ERROR_FAILED => Self::Failed,
            ffi::SOUP_WEBSOCKET_ERROR_NOT_WEBSOCKET => Self::NotWebsocket,
            ffi::SOUP_WEBSOCKET_ERROR_BAD_HANDSHAKE => Self::BadHandshake,
            ffi::SOUP_WEBSOCKET_ERROR_BAD_ORIGIN => Self::BadOrigin,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl StaticType for WebsocketError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_error_get_type()) }
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl glib::value::ValueType for WebsocketError {
    type Type = Self;
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
unsafe impl<'a> FromValue<'a> for WebsocketError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl ToValue for WebsocketError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupWebsocketState")]
pub enum WebsocketState {
    #[doc(alias = "SOUP_WEBSOCKET_STATE_OPEN")]
    Open,
    #[doc(alias = "SOUP_WEBSOCKET_STATE_CLOSING")]
    Closing,
    #[doc(alias = "SOUP_WEBSOCKET_STATE_CLOSED")]
    Closed,
#[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl fmt::Display for WebsocketState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "WebsocketState::{}", match *self {
            Self::Open => "Open",
            Self::Closing => "Closing",
            Self::Closed => "Closed",
            _ => "Unknown",
        })
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl IntoGlib for WebsocketState {
    type GlibType = ffi::SoupWebsocketState;

    fn into_glib(self) -> ffi::SoupWebsocketState {
        match self {
            Self::Open => ffi::SOUP_WEBSOCKET_STATE_OPEN,
            Self::Closing => ffi::SOUP_WEBSOCKET_STATE_CLOSING,
            Self::Closed => ffi::SOUP_WEBSOCKET_STATE_CLOSED,
            Self::__Unknown(value) => value,
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
#[doc(hidden)]
impl FromGlib<ffi::SoupWebsocketState> for WebsocketState {
    unsafe fn from_glib(value: ffi::SoupWebsocketState) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_WEBSOCKET_STATE_OPEN => Self::Open,
            ffi::SOUP_WEBSOCKET_STATE_CLOSING => Self::Closing,
            ffi::SOUP_WEBSOCKET_STATE_CLOSED => Self::Closed,
            value => Self::__Unknown(value),
}
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl StaticType for WebsocketState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_websocket_state_get_type()) }
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl glib::value::ValueType for WebsocketState {
    type Type = Self;
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
unsafe impl<'a> FromValue<'a> for WebsocketState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_50", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
impl ToValue for WebsocketState {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupXMLRPCError")]
pub enum XMLRPCError {
    #[doc(alias = "SOUP_XMLRPC_ERROR_ARGUMENTS")]
    Arguments,
    #[doc(alias = "SOUP_XMLRPC_ERROR_RETVAL")]
    Retval,
#[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for XMLRPCError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "XMLRPCError::{}", match *self {
            Self::Arguments => "Arguments",
            Self::Retval => "Retval",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for XMLRPCError {
    type GlibType = ffi::SoupXMLRPCError;

    fn into_glib(self) -> ffi::SoupXMLRPCError {
        match self {
            Self::Arguments => ffi::SOUP_XMLRPC_ERROR_ARGUMENTS,
            Self::Retval => ffi::SOUP_XMLRPC_ERROR_RETVAL,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupXMLRPCError> for XMLRPCError {
    unsafe fn from_glib(value: ffi::SoupXMLRPCError) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_XMLRPC_ERROR_ARGUMENTS => Self::Arguments,
            ffi::SOUP_XMLRPC_ERROR_RETVAL => Self::Retval,
            value => Self::__Unknown(value),
}
    }
}

impl ErrorDomain for XMLRPCError {
    fn domain() -> Quark {
        crate::skip_assert_initialized!();
        
        unsafe { from_glib(ffi::soup_xmlrpc_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        crate::skip_assert_initialized!();
        match code {
            ffi::SOUP_XMLRPC_ERROR_ARGUMENTS => Some(Self::Arguments),
            ffi::SOUP_XMLRPC_ERROR_RETVAL => Some(Self::Retval),
            value => Some(Self::__Unknown(value)),
}
    }
}

impl StaticType for XMLRPCError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_xmlrpc_error_get_type()) }
    }
}

impl glib::value::ValueType for XMLRPCError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for XMLRPCError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for XMLRPCError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash)]
#[derive(Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SoupXMLRPCFault")]
pub enum XMLRPCFault {
    #[doc(alias = "SOUP_XMLRPC_FAULT_PARSE_ERROR_NOT_WELL_FORMED")]
    ParseErrorNotWellFormed,
    #[doc(alias = "SOUP_XMLRPC_FAULT_PARSE_ERROR_UNSUPPORTED_ENCODING")]
    ParseErrorUnsupportedEncoding,
    #[doc(alias = "SOUP_XMLRPC_FAULT_PARSE_ERROR_INVALID_CHARACTER_FOR_ENCODING")]
    ParseErrorInvalidCharacterForEncoding,
    #[doc(alias = "SOUP_XMLRPC_FAULT_SERVER_ERROR_INVALID_XML_RPC")]
    ServerErrorInvalidXmlRpc,
    #[doc(alias = "SOUP_XMLRPC_FAULT_SERVER_ERROR_REQUESTED_METHOD_NOT_FOUND")]
    ServerErrorRequestedMethodNotFound,
    #[doc(alias = "SOUP_XMLRPC_FAULT_SERVER_ERROR_INVALID_METHOD_PARAMETERS")]
    ServerErrorInvalidMethodParameters,
    #[doc(alias = "SOUP_XMLRPC_FAULT_SERVER_ERROR_INTERNAL_XML_RPC_ERROR")]
    ServerErrorInternalXmlRpcError,
    #[doc(alias = "SOUP_XMLRPC_FAULT_APPLICATION_ERROR")]
    ApplicationError,
    #[doc(alias = "SOUP_XMLRPC_FAULT_SYSTEM_ERROR")]
    SystemError,
    #[doc(alias = "SOUP_XMLRPC_FAULT_TRANSPORT_ERROR")]
    TransportError,
#[doc(hidden)]
    __Unknown(i32),
}

impl XMLRPCFault {
    #[doc(alias = "soup_xmlrpc_fault_quark")]
    pub fn quark() -> glib::Quark {
        crate::assert_initialized_main_thread!();
        unsafe {
            from_glib(ffi::soup_xmlrpc_fault_quark())
        }
    }
}

impl fmt::Display for XMLRPCFault {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "XMLRPCFault::{}", match *self {
            Self::ParseErrorNotWellFormed => "ParseErrorNotWellFormed",
            Self::ParseErrorUnsupportedEncoding => "ParseErrorUnsupportedEncoding",
            Self::ParseErrorInvalidCharacterForEncoding => "ParseErrorInvalidCharacterForEncoding",
            Self::ServerErrorInvalidXmlRpc => "ServerErrorInvalidXmlRpc",
            Self::ServerErrorRequestedMethodNotFound => "ServerErrorRequestedMethodNotFound",
            Self::ServerErrorInvalidMethodParameters => "ServerErrorInvalidMethodParameters",
            Self::ServerErrorInternalXmlRpcError => "ServerErrorInternalXmlRpcError",
            Self::ApplicationError => "ApplicationError",
            Self::SystemError => "SystemError",
            Self::TransportError => "TransportError",
            _ => "Unknown",
        })
    }
}

#[doc(hidden)]
impl IntoGlib for XMLRPCFault {
    type GlibType = ffi::SoupXMLRPCFault;

    fn into_glib(self) -> ffi::SoupXMLRPCFault {
        match self {
            Self::ParseErrorNotWellFormed => ffi::SOUP_XMLRPC_FAULT_PARSE_ERROR_NOT_WELL_FORMED,
            Self::ParseErrorUnsupportedEncoding => ffi::SOUP_XMLRPC_FAULT_PARSE_ERROR_UNSUPPORTED_ENCODING,
            Self::ParseErrorInvalidCharacterForEncoding => ffi::SOUP_XMLRPC_FAULT_PARSE_ERROR_INVALID_CHARACTER_FOR_ENCODING,
            Self::ServerErrorInvalidXmlRpc => ffi::SOUP_XMLRPC_FAULT_SERVER_ERROR_INVALID_XML_RPC,
            Self::ServerErrorRequestedMethodNotFound => ffi::SOUP_XMLRPC_FAULT_SERVER_ERROR_REQUESTED_METHOD_NOT_FOUND,
            Self::ServerErrorInvalidMethodParameters => ffi::SOUP_XMLRPC_FAULT_SERVER_ERROR_INVALID_METHOD_PARAMETERS,
            Self::ServerErrorInternalXmlRpcError => ffi::SOUP_XMLRPC_FAULT_SERVER_ERROR_INTERNAL_XML_RPC_ERROR,
            Self::ApplicationError => ffi::SOUP_XMLRPC_FAULT_APPLICATION_ERROR,
            Self::SystemError => ffi::SOUP_XMLRPC_FAULT_SYSTEM_ERROR,
            Self::TransportError => ffi::SOUP_XMLRPC_FAULT_TRANSPORT_ERROR,
            Self::__Unknown(value) => value,
}
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SoupXMLRPCFault> for XMLRPCFault {
    unsafe fn from_glib(value: ffi::SoupXMLRPCFault) -> Self {
        crate::skip_assert_initialized!();
        match value {
            ffi::SOUP_XMLRPC_FAULT_PARSE_ERROR_NOT_WELL_FORMED => Self::ParseErrorNotWellFormed,
            ffi::SOUP_XMLRPC_FAULT_PARSE_ERROR_UNSUPPORTED_ENCODING => Self::ParseErrorUnsupportedEncoding,
            ffi::SOUP_XMLRPC_FAULT_PARSE_ERROR_INVALID_CHARACTER_FOR_ENCODING => Self::ParseErrorInvalidCharacterForEncoding,
            ffi::SOUP_XMLRPC_FAULT_SERVER_ERROR_INVALID_XML_RPC => Self::ServerErrorInvalidXmlRpc,
            ffi::SOUP_XMLRPC_FAULT_SERVER_ERROR_REQUESTED_METHOD_NOT_FOUND => Self::ServerErrorRequestedMethodNotFound,
            ffi::SOUP_XMLRPC_FAULT_SERVER_ERROR_INVALID_METHOD_PARAMETERS => Self::ServerErrorInvalidMethodParameters,
            ffi::SOUP_XMLRPC_FAULT_SERVER_ERROR_INTERNAL_XML_RPC_ERROR => Self::ServerErrorInternalXmlRpcError,
            ffi::SOUP_XMLRPC_FAULT_APPLICATION_ERROR => Self::ApplicationError,
            ffi::SOUP_XMLRPC_FAULT_SYSTEM_ERROR => Self::SystemError,
            ffi::SOUP_XMLRPC_FAULT_TRANSPORT_ERROR => Self::TransportError,
            value => Self::__Unknown(value),
}
    }
}

impl StaticType for XMLRPCFault {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::soup_xmlrpc_fault_get_type()) }
    }
}

impl glib::value::ValueType for XMLRPCFault {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for XMLRPCFault {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        crate::skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for XMLRPCFault {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

