// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use glib::translate::*;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct Buffer(Boxed<ffi::SoupBuffer>);

    match fn {
        copy => |ptr| ffi::soup_buffer_copy(mut_override(ptr)),
        free => |ptr| ffi::soup_buffer_free(ptr),
        type_ => || ffi::soup_buffer_get_type(),
    }
}

impl Buffer {
    #[cfg(any(feature = "v2_32", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_32")))]
    #[doc(alias = "soup_buffer_new_take")]
    pub fn new_take(data: &[u8]) -> Buffer {
        crate::assert_initialized_main_thread!();
        let length = data.len() as usize;
        unsafe {
            from_glib_full(ffi::soup_buffer_new_take(data.to_glib_full(), length))
        }
    }

    //#[doc(alias = "soup_buffer_new_with_owner")]
    //#[doc(alias = "new_with_owner")]
    //pub fn with_owner(data: &[u8], owner: /*Unimplemented*/Option<Fundamental: Pointer>) -> Buffer {
    //    unsafe { TODO: call ffi:soup_buffer_new_with_owner() }
    //}

    #[cfg(any(feature = "v2_40", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_40")))]
    #[doc(alias = "soup_buffer_get_as_bytes")]
    #[doc(alias = "get_as_bytes")]
    pub fn as_bytes(&mut self) -> Option<glib::Bytes> {
        unsafe {
            from_glib_full(ffi::soup_buffer_get_as_bytes(self.to_glib_none_mut().0))
        }
    }

    //#[doc(alias = "soup_buffer_get_owner")]
    //#[doc(alias = "get_owner")]
    //pub fn owner(&mut self) -> /*Unimplemented*/Option<Fundamental: Pointer> {
    //    unsafe { TODO: call ffi:soup_buffer_get_owner() }
    //}

    #[doc(alias = "soup_buffer_new_subbuffer")]
    pub fn new_subbuffer(&mut self, offset: usize, length: usize) -> Option<Buffer> {
        unsafe {
            from_glib_full(ffi::soup_buffer_new_subbuffer(self.to_glib_none_mut().0, offset, length))
        }
    }
}
