# soundview

![logo: magnifying glass focused over a music note](https://git.sr.ht/~nickbp/soundview/blob/main/src/soundview.webp)

A high-performance voiceprint and analyzer music visualizer - don't miss a beat.

## Install/Quickstart

Install a recent version of [SDL2](https://www.libsdl.org/download-2.0.php) and [Rust/`cargo`](https://www.rust-lang.org/tools/install), then build and run the latest release as follows:
```
$ cargo install soundview
$ ~/.cargo/bin/soundview
```

Several optional arguments can be found by running `~/.cargo/bin/soundview -h`.

### Viewing local audio

Soundview can look at any audio "recording" device on your system, either using the `--device` argument or by pressing the rightarrow/leftarrow keys to rotate between devices.

Out of the box, many systems only have input devices for microphone/line-in. In this situation, visualizing the audio that is playing on the system requires installing a virtual recording device. There are many options for doing this, depending on what operating system you are using.

- Linux: Out of the box, PipeWire and PulseAudio should have input devices named `Monitor of <x>`. If you point Soundview to these Monitor devices, you should be able to visualize any playing audio. On startup, Soundview defaults to devices that have "Monitor of" in their name.
- OSX: [BlackHole](https://github.com/ExistentialAudio/BlackHole) is free and should work, but we haven't tried it ourselves. You should be able to point Soundview to the virtual BlackHole device.
- Windows: [VB-CABLE](https://vb-audio.com/Cable/) is donationware and should work, but we haven't tried it ourselves. You should be able to point Soundview to the virtual VB-CABLE device.

## Keyboard shortcuts

- `Q`/`Esc`: Exit
- `F`/`F11`: Toggle Fullscreen (use `--fullscreen` to enable on startup)
- `R`/`Space`: Rotate between vertical/horizontal modes (use `--orientation` to configure on startup)
- `Right`/`Left`: Switch to next/prev device (use `--device` to select on startup)

## Building from `main`

To build the latest unreleased code, download and build from git as follows:
```
$ git clone https://git.sr.ht/~nickbp/soundview
$ cd soundview
$ cargo build && ./target/debug/soundview # debug build
$ cargo build --release && ./target/release/soundview # release build
```

## License

This project is [licensed](LICENCE.md) under the [FAFOL](https://git.sr.ht/~boringcactus/fafol/tree/master/README.md). This is intended to restrict use of the project for purposes that would be considered unethical by its authors.

## Contributing

Contributions are welcome and appreciated. Contributions must be provided under the license terms described above.
