# soundview

![logo: magnifying glass focused over a music note](src/soundview.svg)

A high-performance voiceprint and analyzer music visualizer - don't miss a beat.

## Install/Quickstart

Install a recent version of [SDL2](https://www.libsdl.org/download-2.0.php) and [Rust/`cargo`](https://www.rust-lang.org/tools/install), then build and run the latest release as follows:
```
$ cargo install soundview
$ ~/.cargo/bin/soundview
```

Optional settings can be found by running `~/.cargo/bin/soundview -h`.

## Keyboard shortcuts

- `Q`/`Esc`: Exit
- `F`/`F11`: Toggle Fullscreen (use `--fullscreen` to enable on startup)
- `R`/`Space`: Rotate between vertical/horizontal modes (use `--orientation` to configure on startup)
- `Right`/`Left`: Switch to next/prev device (use `--device` to select on startup)

## Building from `main`

To build the latest unreleased code, download and build from git as follows:
```
$ git clone https://git.sr.ht/~nickbp/soundview
$ cd soundview
$ cargo build && ./target/debug/soundview # debug build
$ cargo build --release && ./target/release/soundview # release build
```

## License

This project is [licensed](LICENCE.md) under the [FAFOL](https://git.sr.ht/~boringcactus/fafol/tree/master/README.md). This is intended to restrict use of the project for purposes that would be considered unethical by its authors.

## Contributing

Contributions are welcome and appreciated. Contributions must be provided under the license terms described above.
