use crate::flip;
use gen_iter::GenIter;

pub fn pancake_sort<'i, T>(v: &'i [T]) -> impl Iterator<Item = Vec<T>> + 'i
where
    T: Clone + Ord,
{
    let n = v.len();
    let mut v = v.to_vec();
    GenIter(move || {
        if n < 2 {
            yield v.to_vec();
        }
        else {
            yield v.to_vec();
            for i in (0..n).rev() {
                let max_index = v
                    .iter()
                    .take(i + 1)
                    .enumerate()
                    .max_by_key(|&(_, elem)| elem)
                    .map(|(idx, _)| idx)
                    // safe because we already checked if `v` is empty
                    .unwrap();
                if max_index != i {
                    flip(&mut v, max_index);
                    flip(&mut v, i);
                }
                yield v.to_vec();
                if v.is_sorted() {
                    break;
                }
            }
        }
    })
}
