#![feature(generators)]
#![feature(is_sorted)]

mod bogo_sort;
mod bubble_sort;
mod cocktail_sort;
mod comb_sort;
mod counting_sort;
mod errors;
mod gnome_sort;
mod heap_sort;
mod insertion_sort;
mod merge_sort;
mod pancake_sort;
mod quick_sort;
mod selection_sort;
mod shell_sort;
mod stooge_sort;
mod utils;

pub(crate) use self::utils::flip;
pub use self::{
    bogo_sort::{bogo_sort, bogo_sort_by},
    bubble_sort::bubble_sort,
    cocktail_sort::cocktail_sort,
    comb_sort::comb_sort,
    counting_sort::counting_sort,
    gnome_sort::gnome_sort,
    heap_sort::heap_sort,
    insertion_sort::insertion_sort,
    merge_sort::merge_sort,
    pancake_sort::pancake_sort,
    quick_sort::quick_sort_by,
    selection_sort::selection_sort,
    shell_sort::shell_sort,
    stooge_sort::stooge_sort,
};

pub use errors::{Error, Result};
