use gen_iter::GenIter;

pub fn insertion_sort<'i, T>(v: &'i [T]) -> impl Iterator<Item = Vec<T>> + 'i
where
    T: Clone + Ord,
{
    let n = v.len();
    let mut v = v.to_vec();
    GenIter(move || {
        yield v.to_vec();
        for i in 1..n {
            let mut j = i;
            while j > 0 && v[j] < v[j - 1] {
                v.swap(j, j - 1);
                j = j - 1;
                yield v.to_vec();
            }
        }
    })
}
