pub fn comb_sort<T>(v: &mut [T])
where
    T: Ord,
{
    let len = v.len();
    let mut gap = len;
    let mut swapped = true;
    while gap > 1 || swapped {
        gap = (4 * gap) / 5;
        if gap < 1 {
            gap = 1;
        }
        let mut i = 0;
        swapped = false;
        while i + gap < len {
            if v[i] > v[i + gap] {
                v.swap(i, i + gap);
                swapped = true;
            }
            i += 1;
        }
    }
}

#[test]
fn main() {
    let mut v = vec![10, 8, 4, 3, 1, 9, 0, 2, 7, 5, 6];
    println!("before: {:?}", v);
    comb_sort(&mut v);
    println!("after:  {:?}", v);
}
