use gen_iter::GenIter;

pub fn bubble_sort<'i, T>(v: &'i [T]) -> impl Iterator<Item = Vec<T>> + 'i
where
    T: Clone + Ord,
{
    let mut v = v.to_vec();
    let mut n = v.len();
    let mut swapped = true;

    GenIter(move || {
        yield v.to_vec();
        while swapped {
            swapped = false;
            for i in 1..n {
                if v[i - 1] > v[i] {
                    v.swap(i - 1, i);
                    swapped = true;
                    yield v.to_vec()
                }
            }
            n = n - 1;
        }
    })
}
