use gen_iter::GenIter;
use rand::{rngs::SmallRng, seq::SliceRandom, SeedableRng};
use std::cmp::Ordering;

pub fn bogo_sort<'i, T>(v: &'i [T]) -> impl Iterator<Item = Vec<T>> + 'i
where
    T: Clone + PartialOrd,
{
    bogo_sort_by(v, |a, b| a.partial_cmp(b))
}

pub fn bogo_sort_by<'i, T, F>(v: &'i [T], compare: F) -> impl Iterator<Item = Vec<T>> + 'i
where
    T: Clone + PartialOrd,
    F: Fn(&T, &T) -> Option<Ordering>,
    F: Copy + 'i,
{
    let mut v = v.to_vec();
    let mut rng = SmallRng::seed_from_u64(v.len() as u64);
    GenIter(move || {
        yield v.to_vec();
        while !v.is_sorted_by(compare) {
            v.shuffle(&mut rng);
            yield v.to_vec();
        }
    })
}
