//! Convert RDF on stdin from one format to another
use sophia_iri::*;

fn main() -> Result<(), Box<dyn std::error::Error>> {
    let args: Vec<_> = std::env::args().collect();
    if args.len() != 2 {
        let message = if args.len() < 2 {
            "too few arguments"
        } else {
            "too many arguments"
        };
        eprintln!("{}", message);
        std::process::exit(1_i32);
    }
    let candidate = args[1].as_str();
    Iri::new(candidate)?;
    Ok(())
}
