#[derive(Debug)]
pub struct Error;

/// automatic conversion from `std::error::Error` trait
///
/// https://doc.rust-lang.org/nightly/std/error/trait.Error.html

/*
impl From<Box<dyn std::error::Error>> for Error
where
{
    fn from(_e: Box<dyn std::error::Error>) -> Self {
        Error
    }
}
*/

impl<E> From<E> for Error
where
    E: std::error::Error + Sync + Send + Sized + 'static,
{
    fn from(_e: E) -> Self {
        Error
    }
}

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
