/// according to
///
/// https://crates.io/crates/sudo
///
/// the `sudo` crate provides backtrace with RUST_BACKTRACE set
///
/// plus https://docs.rs/anyhow/latest/anyhow/struct.Error.html mentions that
///
/// Error works a lot like Box<dyn std::error::Error>, but with these differences:...
///
/// therefore it's worth looking into
///
pub fn main() -> Result<(), Box<dyn std::error::Error>> {
    sudo::escalate_if_needed()?;
    println!("Hello, Root-World!");
    let _a = i32::from_str_radix("a12", 10)?;
    Ok(())
}
