#!/usr/bin/env python3
# AutoIt wrapper generator

from soloud_codegen import *

fo = open("soloud.au3", "w")

"""
Global $dll = DllOpen(@ScriptDir & "\soloud.dll")

Const $CONSTANT = 1234567890



Func _SoLoud_method($param1, $param2, $paramN)
  Local $ret = DllCall($dll, "return type e.g. int", "function", "type1 if necessary", "param1 if necessary", "typeN  if necessary", "paramN  if necessary")
  If @error Then Return SetError(1, 1, 0)
  Return $ret[0]
EndFunc
"""

fo.write("; SoLoud wrapper for AutoIt\n")
fo.write("; This file is autogenerated; any changes will be overwritten\n")
fo.write('Global $dll = DllOpen(@ScriptDir & "\\soloud_x86.dll")\n')
fo.write("\n")
fo.write("; Enumerations\n")
for x in soloud_enum:
   fo.write("Const $" + x + " = " + str(soloud_enum[x]) + "\n")
fo.write("\n")
fo.write("; Functions\n")
for x in soloud_func:
  funcdef = "Func _" + x[1] + "("
  first = True;
  for p in x[2]:
    if len(p) > 0:      
      if not first:
         funcdef += ", "
      else:
         first = False
      funcdef += "$" + p[1]
  funcdef += ")"  
  
  calldef = "\tLocal $ret = DllCall($dll, "
  calldef += '"' + x[0] + '", ' # return type
  calldef += '"' + x[1] + '"'
  
  for p in x[2]:
    if len(p) > 0:
      calldef += ', "' + p[0] + '", "' + p[1] + '"'
  calldef += ')'
  
  fo.write(funcdef + "\n")
  fo.write(calldef + "\n")
  fo.write('\tIf @error Then Return SetError(1, 1, 0)\n')
  fo.write('\tReturn $ret[0]\n')
  fo.write('EndFunc\n')
  fo.write("\n")
  
fo.close()
print("soloud.au3 generated")
