[package]
name = "solo2"
version = "0.0.1"
authors = ["SoloKeys Developers"]
edition = "2018"
repository = "https://github.com/solokeys/solo2-cli"
description = "Library and CLI for the SoloKeys Solo 2 security key"
license = "Apache-2.0 OR MIT"
readme = "README.md"
documentation = "https://docs.rs/solo2"

[lib]

[[bin]]
name = "solo2"
required-features = ["cli"]

[dependencies]
log = "0.4.14"
anyhow = "1.0.40"
clap = { version = "2.33.3", optional = true }
# ctap-hid-fido2 = "2.1.1"
hex = "0.4.3"
hex-literal = "0.3.1"
iso7816 = "0.1.0-alpha.0"
lazy_static = { version = "1.4.0", optional = true }
lpc55 = "0.1.0-alpha.2"
pcsc = "2.4.0"
pretty_env_logger = { version = "0.4.0", optional = true }

chrono = { version = "0.4.19", optional = true }
p256 = { version = "0.8.1", optional = true }
rand_core = { version = "0.6.2", optional = true }
# x509 = { version = "0.2.0", optional = true }
rcgen = { version = "0.8.11", optional = true }
yasna = { version = "0.4.0", optional = true }

# p256-cortex-m4 = { version = "0.1.0-alpha.5", optional = true }
# salty = { version = "0.0.1", optional = true }

[features]
default = ["cli", "dev-pki"]
cli = ["clap", "lazy_static", "pretty_env_logger"]
dev-pki = ["chrono", "p256", "rand_core", "rcgen", "yasna"]
