use http::Method;
use solarsail_macros::*;

#[test]
fn test_get() {
    match (&Method::GET, &["resources", "42"]) {
        get!("resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_post() {
    match (&Method::POST, &["resources", "42"]) {
        post!("resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_put() {
    match (&Method::PUT, &["resources", "42"]) {
        put!("resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_delete() {
    match (&Method::DELETE, &["resources", "42"]) {
        delete!("resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_patch() {
    match (&Method::PATCH, &["resources", "42"]) {
        patch!("resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_leading_slash() {
    match (&Method::GET, &["resources", "42"]) {
        get!(/ "resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_custom_method() {
    match (&Method::HEAD, &["resources", "42"]) {
        route!(&Method::HEAD, "resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_custom_method_pattern() {
    match (&Method::GET, &["resources", "42"]) {
        route!(&Method::HEAD | &Method::GET, "resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_andy_method() {
    match (&Method::OPTIONS, &["resources", "42"]) {
        route!(_, "resources" / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_empty_path() {
    assert!(matches!((&Method::GET, &["resources", "42"]), get!()));
    assert!(matches!(
        (&Method::GET, &["resources", "42"]),
        route!(&Method::GET)
    ));
}

#[test]
fn test_match_last() {
    match (&Method::GET, &["one", "two", "three", "42"]) {
        get!("one" / .. / id) => assert_eq!(id, "42"),
        _ => unreachable!(),
    }
}

#[test]
fn test_match_first_only() {
    assert!(matches!(
        (&Method::GET, &["one", "two", "three", "42"]),
        get!("one" / ..)
    ));
}

#[test]
fn test_subslice() {
    match (&Method::GET, &["one", "two", "three", "42"]) {
        get!("one" / tail @ ..) => assert_eq!(&tail, &["two", "three", "42"]),
        _ => unreachable!(),
    }
}

#[test]
fn compile_fail() {
    let t = trybuild::TestCases::new();
    t.compile_fail("tests/compile-fail/*.rs");
}
