

use sciimg::{
    imagebuffer,
    enums::ImageMode,
    error
};

use image::Rgba;

use imageproc::geometric_transformations::{
    rotate_about_center,
    Interpolation
};


pub fn rotate_8(buffer:&imagebuffer::ImageBuffer, theta:f32) -> error::Result<imagebuffer::ImageBuffer> {
    let image = buffer.buffer_to_image_8bit();
    let default_pixel = Rgba([0, 0, 0, 0]);
    let rotated = rotate_about_center(&image, theta, Interpolation::Bicubic, default_pixel);

    imagebuffer::ImageBuffer::from_image_u8(&rotated)
}

pub fn rotate_16(buffer:&imagebuffer::ImageBuffer, theta:f32) -> error::Result<imagebuffer::ImageBuffer> {
    let image = buffer.buffer_to_image_16bit();
    let default_pixel = Rgba([0, 0, 0, 0]);
    let rotated = rotate_about_center(&image, theta, Interpolation::Bicubic, default_pixel);

    imagebuffer::ImageBuffer::from_image_u16(&rotated)
}

pub fn rotate(buffer:&imagebuffer::ImageBuffer, theta:f32) -> error::Result<imagebuffer::ImageBuffer> {
    match buffer.mode {
        ImageMode::U8BIT => rotate_8(buffer, theta),
        ImageMode::U16BIT => rotate_16(buffer, theta),
        _ => panic!("Unexpected bit depth encountered!")
    }
}